/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.workflow.jbpm.command;

import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jahia.services.workflow.HistoryWorkflowTask;
import org.jahia.services.workflow.WorkflowDefinition;
import org.jahia.services.workflow.jbpm.BaseCommand;
import org.jahia.services.workflow.jbpm.JBPM6WorkflowProvider;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskSummary;

public class GetHistoryWorkflowTasksCommand
extends BaseCommand<List<HistoryWorkflowTask>> {
    private final String processId;
    private final Locale uiLocale;

    public GetHistoryWorkflowTasksCommand(String processId, Locale uiLocale) {
        this.processId = processId;
        this.uiLocale = uiLocale;
    }

    @Override
    public List<HistoryWorkflowTask> execute() {
        String rbActionName;
        ResourceBundle resourceBundle;
        WorkflowDefinition definition;
        HistoryWorkflowTask workflowTask;
        LinkedList<HistoryWorkflowTask> workflowTaskHistory = new LinkedList<HistoryWorkflowTask>();
        ProcessInstanceLog processInstanceLog = this.getLogService().findProcessInstance(Long.parseLong(this.processId));
        List nodeInstanceLogs = this.getLogService().findNodeInstances(processInstanceLog.getProcessInstanceId());
        for (NodeInstanceLog nodeInstanceLog : nodeInstanceLogs) {
            if (nodeInstanceLog.getWorkItemId() == null || !"HumanTaskNode".equals(nodeInstanceLog.getNodeType())) continue;
            Task task = this.getTaskService().getTaskByWorkItemId(nodeInstanceLog.getWorkItemId().longValue());
            workflowTask = new HistoryWorkflowTask(task.getId().toString(), nodeInstanceLog.getProcessId(), nodeInstanceLog.getNodeName(), this.getKey(), task.getTaskData().getActualOwner() != null ? task.getTaskData().getActualOwner().getId() : null, task.getTaskData().getCreatedOn(), nodeInstanceLog.getDate(), "outcome");
            if (this.uiLocale != null) {
                definition = this.getWorkflowDefinitionById(nodeInstanceLog.getProcessId(), this.uiLocale, this.getKieSession().getKieBase());
                resourceBundle = this.getResourceBundle(this.uiLocale, definition.getPackageName(), definition.getKey());
                rbActionName = this.i18nName(workflowTask.getName(), resourceBundle);
                workflowTask.setDisplayName(rbActionName);
            }
            workflowTaskHistory.add(workflowTask);
        }
        List tasksIds = this.getTaskService().getTasksByStatusByProcessInstanceId(Long.parseLong(this.processId), JBPM6WorkflowProvider.OPEN_STATUS_LIST, "en");
        for (TaskSummary taskSummary : tasksIds) {
            workflowTask = new HistoryWorkflowTask(Long.toString(taskSummary.getId()), Long.toString(taskSummary.getProcessInstanceId()), taskSummary.getName(), this.getKey(), null, taskSummary.getCreatedOn(), null, null);
            workflowTaskHistory.add(workflowTask);
            if (this.uiLocale == null) continue;
            definition = this.getWorkflowDefinitionById(taskSummary.getProcessId(), this.uiLocale, this.getKieSession().getKieBase());
            resourceBundle = this.getResourceBundle(this.uiLocale, definition.getPackageName(), definition.getKey());
            rbActionName = this.i18nName(workflowTask.getName(), resourceBundle);
            workflowTask.setDisplayName(rbActionName);
        }
        return workflowTaskHistory;
    }

    @Override
    public String toString() {
        return super.toString() + String.format("%n processId: %s", this.processId) + String.format("%n uiLocale: %s", this.uiLocale);
    }
}

