/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jahia.utils.LoadAverage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(since="8.2.1.0", forRemoval=true)
public class LoadAverageExecutor {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private final Map<String, ScheduledFuture<?>> schedules = new HashMap();

    public void addLoadAverage(LoadAverage loadAverage) {
        this.LOGGER.info("Adding load average: {}", (Object)loadAverage.getClass().getName());
        if (this.schedules.containsKey(loadAverage.getClass().getName())) {
            this.schedules.get(loadAverage.getClass().getName()).cancel(false);
            this.schedules.remove(loadAverage.getClass().getName());
        }
        ScheduledFuture<?> scheduledFuture = executor.scheduleAtFixedRate(loadAverage, 0L, loadAverage.calcFreqMillis, TimeUnit.MILLISECONDS);
        this.schedules.put(loadAverage.getClass().getName(), scheduledFuture);
    }

    public void removeLoadAverage(LoadAverage loadAverage) {
        this.LOGGER.info("Removing load average: {}", (Object)loadAverage.getClass().getName());
        if (this.schedules.containsKey(loadAverage.getClass().getName())) {
            this.schedules.get(loadAverage.getClass().getName()).cancel(false);
            this.schedules.remove(loadAverage.getClass().getName());
        }
    }

    public void start() {
        this.LOGGER.info("Starting load average executor...");
    }

    public void stop() {
        this.LOGGER.info("Stopping load average executor...");
        try {
            executor.shutdown();
            if (!executor.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
                this.LOGGER.info("Load Average Executor did not terminate in the specified time.");
                List<Runnable> droppedTasks = executor.shutdownNow();
                this.LOGGER.info("Load Average Executor was abruptly shut down. " + droppedTasks.size() + " tasks will not be executed.");
            }
        }
        catch (InterruptedException e) {
            executor.shutdownNow();
        }
        this.schedules.clear();
    }
}

