/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.filter.LevelRangeFilter;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.jahia.utils.Log4jEventCollector;

public class Log4jEventCollectorWrapper
implements AutoCloseable {
    private Log4jEventCollector target;

    public Log4jEventCollectorWrapper(String level) {
        this(level, level);
    }

    public Log4jEventCollectorWrapper(String minLevel, String maxLevel) {
        this.target = Log4jEventCollector.createAppender("eventCollector", LevelRangeFilter.createFilter((Level)Level.getLevel((String)minLevel), (Level)Level.getLevel((String)maxLevel), (Filter.Result)Filter.Result.ACCEPT, (Filter.Result)Filter.Result.DENY));
        this.getRootLoggerConfig().addAppender((Appender)this.target, Level.getLevel((String)minLevel), null);
    }

    public Log4jEventCollectorWrapper(String minLevel, String maxLevel, String name, Layout<? extends Serializable> layout, boolean start) {
        this.target = Log4jEventCollector.createAppender(name, LevelRangeFilter.createFilter((Level)Level.getLevel((String)minLevel), (Level)Level.getLevel((String)maxLevel), (Filter.Result)Filter.Result.ACCEPT, (Filter.Result)Filter.Result.DENY), layout);
        if (start) {
            this.target.start();
        }
        this.getRootLoggerConfig().addAppender((Appender)this.target, Level.getLevel((String)minLevel), null);
    }

    @Override
    public void close() {
        this.getRootLoggerConfig().removeAppender(this.target.getName());
        this.target.stop();
    }

    public List<LoggingEventWrapper> getCollectedEvents() {
        return Log4jEventCollectorWrapper.convert(this.target.getCollectedEvents());
    }

    private LoggerConfig getRootLoggerConfig() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        return config.getLoggerConfig(LogManager.getRootLogger().getName());
    }

    private static List<LoggingEventWrapper> convert(List<LogEvent> events) {
        ArrayList<LoggingEventWrapper> result = new ArrayList<LoggingEventWrapper>(events.size());
        for (LogEvent event : events) {
            result.add(new LoggingEventWrapper(event));
        }
        return result;
    }

    public static class LoggingEventWrapper {
        private LogEvent target;

        public LoggingEventWrapper(LogEvent target) {
            this.target = target;
        }

        public int getLevel() {
            return this.target.getLevel().intLevel();
        }

        public long getTimestamp() {
            return this.target.getTimeMillis();
        }

        public String getMessage() {
            return this.target.getMessage().getFormattedMessage();
        }

        public String[] getThrowableInfo() {
            ThrowableProxy t = this.target.getThrownProxy();
            return t != null ? t.getExtendedStackTraceAsString("").split("\n") : null;
        }
    }
}

