/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.i18n;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.templates.TemplatePackageRegistry;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.i18n.JahiaPropertyResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JahiaResourceBundleControl
extends ResourceBundle.Control {
    private static volatile JahiaResourceBundleControl defaultControl;
    private static final Logger logger;
    private TemplatePackageRegistry templatePackageRegistry;
    private boolean considerDefaultJVMLocale;

    private JahiaResourceBundleControl(boolean considerDefaultJVMLocale) {
        this.considerDefaultJVMLocale = considerDefaultJVMLocale;
        this.templatePackageRegistry = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JahiaResourceBundleControl getInstance() {
        if (defaultControl != null) return defaultControl;
        Class<JahiaResourceBundleControl> clazz = JahiaResourceBundleControl.class;
        synchronized (JahiaResourceBundleControl.class) {
            if (defaultControl != null) return defaultControl;
            defaultControl = new JahiaResourceBundleControl(SettingsBean.getInstance().isConsiderDefaultJVMLocale());
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultControl;
        }
    }

    private InputStream getClasspathStream(final ClassLoader classLoader, final boolean reloadFlag, final String resourceName) throws IOException {
        InputStream stream = null;
        try {
            stream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws IOException {
                    InputStream is = null;
                    if (reloadFlag) {
                        URLConnection connection;
                        URL url = classLoader.getResource(resourceName);
                        if (url != null && (connection = url.openConnection()) != null) {
                            connection.setUseCaches(false);
                            is = connection.getInputStream();
                        }
                    } else {
                        is = classLoader.getResourceAsStream(resourceName);
                    }
                    return is;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        return stream;
    }

    @Override
    public Locale getFallbackLocale(String baseName, Locale locale) {
        return this.considerDefaultJVMLocale ? super.getFallbackLocale(baseName, locale) : null;
    }

    @Override
    public List<String> getFormats(String baseName) {
        return FORMAT_PROPERTIES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        if (!format.equals("java.properties")) {
            throw new IllegalArgumentException("Unknown format: " + format);
        }
        JahiaPropertyResourceBundle bundle = null;
        String resourceName = this.toResourceName(this.toBundleName(baseName, locale), "properties");
        InputStream stream = this.getStreamFromSources(baseName, resourceName);
        if (stream == null) {
            stream = this.getClasspathStream(loader, reload, resourceName);
        }
        if (stream != null) {
            try {
                bundle = new JahiaPropertyResourceBundle(stream);
            }
            finally {
                stream.close();
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{} resource bundle for basename '{}' and locale '{}' under: {}", new Object[]{bundle != null ? "Found" : "Cannot find", baseName, locale, resourceName});
        }
        return bundle;
    }

    private InputStream getStreamFromSources(String baseName, String resourceName) throws FileNotFoundException {
        JahiaTemplatesPackage aPackage = this.templatePackageRegistry.getPackageForResourceBundle(baseName);
        if (aPackage == null || aPackage.getSourcesFolder() == null) {
            return null;
        }
        File sourcesFolder = new File(new File(aPackage.getSourcesFolder(), "src/main/resources"), resourceName);
        if (sourcesFolder.exists()) {
            return new BufferedInputStream(new FileInputStream(sourcesFolder));
        }
        sourcesFolder = new File(new File(aPackage.getSourcesFolder(), "src/main/webapp"), resourceName);
        if (sourcesFolder.exists()) {
            return new BufferedInputStream(new FileInputStream(sourcesFolder));
        }
        return null;
    }

    @Override
    public long getTimeToLive(String baseName, Locale locale) {
        JahiaTemplatesPackage aPackage = this.templatePackageRegistry.getPackageForResourceBundle(baseName);
        if (aPackage != null && aPackage.getSourcesFolder() != null) {
            return 1000L;
        }
        return super.getTimeToLive(baseName, locale);
    }

    @Override
    public boolean needsReload(String baseName, Locale locale, String format, ClassLoader loader, ResourceBundle bundle, long loadTime) {
        JahiaTemplatesPackage aPackage;
        boolean needsReload = super.needsReload(baseName, locale, format, loader, bundle, loadTime);
        if (!needsReload && (aPackage = this.templatePackageRegistry.getPackageForResourceBundle(baseName)) != null && aPackage.getSourcesFolder() != null) {
            String resourceName = this.toResourceName(this.toBundleName(baseName, locale), "properties");
            File rbSrc = new File(new File(aPackage.getSourcesFolder(), "src/main/resources"), resourceName);
            if (rbSrc.exists() && rbSrc.lastModified() > loadTime) {
                needsReload = true;
            }
        }
        return needsReload;
    }

    static {
        logger = LoggerFactory.getLogger(JahiaResourceBundleControl.class);
    }
}

