/*
 * ==========================================================================================
 * =                   JAHIA'S DUAL LICENSING - IMPORTANT INFORMATION                       =
 * ==========================================================================================
 *
 *                                 http://www.jahia.com
 *
 *     Copyright (C) 2002-2025 Jahia Solutions Group SA. All rights reserved.
 *
 *     THIS FILE IS AVAILABLE UNDER TWO DIFFERENT LICENSES:
 *     1/Apache2 OR 2/JSEL
 *
 *     1/ Apache2
 *     ==================================================================================
 *
 *     Copyright (C) 2002-2025 Jahia Solutions Group SA. All rights reserved.
 *
 *     Licensed under the Apache License, Version 2.0 (the "License");
 *     you may not use this file except in compliance with the License.
 *     You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *     Unless required by applicable law or agreed to in writing, software
 *     distributed under the License is distributed on an "AS IS" BASIS,
 *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *     See the License for the specific language governing permissions and
 *     limitations under the License.
 *
 *
 *     2/ JSEL - Commercial and Supported Versions of the program
 *     ===================================================================================
 *
 *     IF YOU DECIDE TO CHOOSE THE JSEL LICENSE, YOU MUST COMPLY WITH THE FOLLOWING TERMS:
 *
 *     Alternatively, commercial and supported versions of the program - also known as
 *     Enterprise Distributions - must be used in accordance with the terms and conditions
 *     contained in a separate written agreement between you and Jahia Solutions Group SA.
 *
 *     If you are unsure which license is appropriate for your use,
 *     please contact the sales department at sales@jahia.com.
 */
package org.jahia.services.content.nodetypes.initializers;

import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;

import java.util.List;
import java.util.Locale;
import java.util.Map;

/**
 * Defines the choice list value initializer.
 *
 * @author : rincevent
 * @since JAHIA 6.5
 *        Created : 17 nov. 2009
 */
public interface ChoiceListInitializer {

    /**
     * Build a list of ChoiceListValue objects that contain the name, the displayName and the properties for each
     * entry in a choice list
     * @param epd the related property definition
     * @param param the parameter string passed to the choicelist initializer (in the definition)
     * @param values the values generated by the choicelist initializer that was called just before this one in the
     *               chain
     * @param locale the locale for which to generate the choicelist values
     * @param context This map is designed to be used freely
     *                by implementations to pass context information between initializers as it is always the same object
     *                passed to all initializers in a chain. Here are a few entries that are already used by the system:
     *                can contain: dependentProperties: a list of properties that this property depends on, to be able
     *               to modify the choicelist values based on changes in other properties (useful for example for
     *                locations going from coarse to more precise), contextNode: the node we are editing, or any other
     *                information that may be useful to specific implementations.
     * @return a list of ChoiceListValue object that contain the name, displayName and custom properties to render the
     * choicelist values in a user interface
     */
    public List<ChoiceListValue> getChoiceListValues(ExtendedPropertyDefinition epd, String param, List<ChoiceListValue> values, Locale locale,
                                                     Map<String, Object> context);
}
