/*
 * ==========================================================================================
 * =                   JAHIA'S DUAL LICENSING - IMPORTANT INFORMATION                       =
 * ==========================================================================================
 *
 *                                 http://www.jahia.com
 *
 *     Copyright (C) 2002-2025 Jahia Solutions Group SA. All rights reserved.
 *
 *     THIS FILE IS AVAILABLE UNDER TWO DIFFERENT LICENSES:
 *     1/Apache2 OR 2/JSEL
 *
 *     1/ Apache2
 *     ==================================================================================
 *
 *     Copyright (C) 2002-2025 Jahia Solutions Group SA. All rights reserved.
 *
 *     Licensed under the Apache License, Version 2.0 (the "License");
 *     you may not use this file except in compliance with the License.
 *     You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *     Unless required by applicable law or agreed to in writing, software
 *     distributed under the License is distributed on an "AS IS" BASIS,
 *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *     See the License for the specific language governing permissions and
 *     limitations under the License.
 *
 *
 *     2/ JSEL - Commercial and Supported Versions of the program
 *     ===================================================================================
 *
 *     IF YOU DECIDE TO CHOOSE THE JSEL LICENSE, YOU MUST COMPLY WITH THE FOLLOWING TERMS:
 *
 *     Alternatively, commercial and supported versions of the program - also known as
 *     Enterprise Distributions - must be used in accordance with the terms and conditions
 *     contained in a separate written agreement between you and Jahia Solutions Group SA.
 *
 *     If you are unsure which license is appropriate for your use,
 *     please contact the sales department at sales@jahia.com.
 */
package org.jahia.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;

/**
 * Output stream implementation that writes to a string buffer.
 *
 * @author Sergiy Shyrkov
 */
public class StringOutputStream extends OutputStream {

    private StringWriter stringWriter = new StringWriter(256);

    private OutputStream wrapped;

    /**
     * Initializes an instance of this class.
     */
    public StringOutputStream() {
        this(null);
    }

    /**
     * Initializes an instance of this class with the supplied wrapped {@link OutputStream}.
     *
     * @param wrapped
     *            a stream to write the output into
     */
    public StringOutputStream(OutputStream wrapped) {
        super();
        this.wrapped = wrapped;
    }

    public int getLength() {
        return getStringBuffer().length();
    }

    public StringBuffer getStringBuffer() {
        return stringWriter.getBuffer();
    }

    @Override
    public String toString() {
        return stringWriter.toString();
    }

    @Override
    public void write(int b) throws IOException {
        this.stringWriter.write(b);
        if (wrapped != null) {
            wrapped.write(b);
        }
    }
}
