/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.version.Version;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.VersionManagerImpl;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.UpdatableItemStateManager;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.version.NodeStateEx;
import org.apache.jackrabbit.core.version.VersionImpl;
import org.apache.jackrabbit.core.version.VersionManagerImplBase;
import org.apache.jackrabbit.spi.commons.name.NameConstants;

public class JahiaVersionManagerImpl
extends VersionManagerImpl {
    public JahiaVersionManagerImpl(SessionContext context, UpdatableItemStateManager stateMgr, HierarchyManager hierMgr) {
        super(context, stateMgr, hierMgr);
    }

    public void addPredecessor(String absPath, Version version) throws RepositoryException {
        NodeStateEx state = this.getNodeState((NodeImpl)this.session.getNode(absPath), 194, 256);
        if (!this.checkVersionable(state)) {
            throw new UnsupportedRepositoryOperationException("Node not full versionable: " + this.safeGetJCRPath(state));
        }
        NodeId versionId = ((VersionImpl)version).getNodeId();
        try (VersionManagerImplBase.WriteOperation ops = this.startWriteOperation();){
            InternalValue[] vals = state.getPropertyValues(NameConstants.JCR_PREDECESSORS);
            InternalValue[] v = new InternalValue[vals.length + 1];
            for (int i = 0; i < vals.length; ++i) {
                v[i] = InternalValue.create((NodeId)vals[i].getNodeId());
            }
            v[vals.length] = InternalValue.create((NodeId)versionId);
            state.setPropertyValues(NameConstants.JCR_PREDECESSORS, 9, v, true);
            state.store(false);
            ops.save();
        }
    }

    private NodeStateEx getNodeState(NodeImpl node, int options, int permissions) throws RepositoryException {
        try {
            if (options > 0 || permissions > 0) {
                this.context.getItemValidator().checkModify((ItemImpl)node, options, permissions);
            }
            return new NodeStateEx(this.stateMgr, this.ntReg, (NodeState)this.stateMgr.getItemState((ItemId)node.getNodeId()), node.getQName());
        }
        catch (ItemStateException e) {
            throw new RepositoryException((Throwable)e);
        }
    }
}

