/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaPersistenceCopier {
    private static final Logger logger = LoggerFactory.getLogger(JahiaPersistenceCopier.class);
    private ChangeLog batchLog = new ChangeLog();
    private int batchSize;
    private final Set<NodeId> exclude = new HashSet<NodeId>();
    private int maxBatchSize;
    private final PersistenceManager source;
    private final DataStore store;
    private final PersistenceManager target;
    private int totalCount;

    public JahiaPersistenceCopier(PersistenceManager source, PersistenceManager target, DataStore store, int batchSize) {
        this.source = source;
        this.target = target;
        this.store = store;
        this.maxBatchSize = batchSize;
    }

    public void copy(NodeId id) throws RepositoryException {
        if (!this.exclude.contains(id)) {
            try {
                NodeState node = this.source.load(id);
                for (ChildNodeEntry entry : node.getChildNodeEntries()) {
                    this.copy(entry.getId());
                }
                this.copy(node);
                this.exclude.add(id);
            }
            catch (ItemStateException e) {
                logger.warn("Unable to copy " + String.valueOf(id), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(NodeState sourceNode) throws RepositoryException {
        try {
            ChangeLog changes = new ChangeLog();
            NodeState targetNode = this.target.createNew(sourceNode.getNodeId());
            targetNode.setParentId(sourceNode.getParentId());
            targetNode.setNodeTypeName(sourceNode.getNodeTypeName());
            targetNode.setMixinTypeNames(sourceNode.getMixinTypeNames());
            targetNode.setPropertyNames(sourceNode.getPropertyNames());
            targetNode.setChildNodeEntries(sourceNode.getChildNodeEntries());
            if (this.target.exists(targetNode.getNodeId())) {
                changes.modified((ItemState)targetNode);
            } else {
                changes.added((ItemState)targetNode);
            }
            for (Name name : sourceNode.getPropertyNames()) {
                PropertyId id = new PropertyId(sourceNode.getNodeId(), name);
                PropertyState sourceState = this.source.load(id);
                PropertyState targetState = this.target.createNew(id);
                targetState.setType(sourceState.getType());
                targetState.setMultiValued(sourceState.isMultiValued());
                InternalValue[] values = sourceState.getValues();
                if (sourceState.getType() == 2) {
                    for (int i = 0; i < values.length; ++i) {
                        try (InputStream stream = values[i].getStream();){
                            values[i] = InternalValue.create((InputStream)stream, (DataStore)this.store);
                            continue;
                        }
                    }
                }
                targetState.setValues(values);
                if (this.target.exists(targetState.getPropertyId())) {
                    changes.modified((ItemState)targetState);
                    continue;
                }
                changes.added((ItemState)targetState);
            }
            if (this.source.existsReferencesTo(sourceNode.getNodeId())) {
                changes.modified(this.source.loadReferencesTo(sourceNode.getNodeId()));
            } else if (this.target.existsReferencesTo(sourceNode.getNodeId())) {
                NodeReferences references = this.target.loadReferencesTo(sourceNode.getNodeId());
                references.clearAllReferences();
                changes.modified(references);
            }
            if (this.batchSize >= this.maxBatchSize) {
                this.flush();
            }
            ++this.batchSize;
            this.batchLog.merge(changes);
        }
        catch (IOException e) {
            throw new RepositoryException("Unable to copy binary values of " + String.valueOf(sourceNode), (Throwable)e);
        }
        catch (ItemStateException e) {
            throw new RepositoryException("Unable to copy " + String.valueOf(sourceNode), (Throwable)e);
        }
    }

    public void excludeNode(NodeId id) {
        this.exclude.add(id);
    }

    public void flush() throws RepositoryException {
        if (!this.batchLog.hasUpdates()) {
            this.batchSize = 0;
            return;
        }
        this.totalCount += this.batchSize;
        logger.info("Persisting batch of {} ({}) entries into the store", (Object)this.batchSize, (Object)this.totalCount);
        try {
            this.target.store(this.batchLog);
        }
        catch (ItemStateException e) {
            throw new RepositoryException("Unable to persist batch of changes: " + String.valueOf(this.batchLog), (Throwable)e);
        }
        finally {
            this.batchSize = 0;
            this.batchLog.reset();
        }
    }
}

