/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.jcr.RepositoryException;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.jackrabbit.core.query.lucene.join.SimpleQueryResult;

public class JahiaSimpleQueryResult
extends SimpleQueryResult {
    private final RowIterator rowIterator;
    private final List<Row> rows = new ArrayList<Row>();
    private final long approxCount;

    public JahiaSimpleQueryResult(String[] columnNames, String[] selectorNames, RowIterator rowIterator) {
        this(columnNames, selectorNames, rowIterator, 0L);
    }

    public JahiaSimpleQueryResult(String[] columnNames, String[] selectorNames, RowIterator rowIterator, long approxCount) {
        super(columnNames, selectorNames, rowIterator);
        this.rowIterator = rowIterator;
        this.approxCount = approxCount;
    }

    public RowIterator getRows() throws RepositoryException {
        return new Iterator();
    }

    public long getApproxCount() {
        return this.approxCount;
    }

    private class Iterator
    implements RowIterator {
        private int position = 0;

        private Iterator() {
        }

        public Row nextRow() {
            if (this.position < JahiaSimpleQueryResult.this.rows.size()) {
                return JahiaSimpleQueryResult.this.rows.get(this.position++);
            }
            if (JahiaSimpleQueryResult.this.rowIterator.hasNext()) {
                JahiaSimpleQueryResult.this.rows.add(JahiaSimpleQueryResult.this.rowIterator.nextRow());
                return JahiaSimpleQueryResult.this.rows.get(this.position++);
            }
            throw new NoSuchElementException();
        }

        public void skip(long skipNum) {
            int i = 0;
            while ((long)i < skipNum) {
                this.nextRow();
                ++i;
            }
        }

        public long getSize() {
            return JahiaSimpleQueryResult.this.rowIterator.getSize();
        }

        public long getPosition() {
            return this.position;
        }

        public boolean hasNext() {
            return this.position < JahiaSimpleQueryResult.this.rows.size() || JahiaSimpleQueryResult.this.rowIterator.hasNext();
        }

        public Object next() {
            return this.nextRow();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

