/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security;

import com.google.common.base.Objects;
import javax.jcr.Item;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.security.JahiaSystemSession;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.jahia.utils.security.PathWrapper;

public class JahiaJCRPathWrapperImpl
implements PathWrapper {
    private Path path;
    private String jcrPath;
    private JahiaSystemSession securitySession;
    private DefaultNamePathResolver pathResolver;

    public JahiaJCRPathWrapperImpl(Path path, DefaultNamePathResolver pathResolver, JahiaSystemSession securitySession) throws RepositoryException {
        this.path = path;
        this.jcrPath = pathResolver.getJCRPath(path);
        this.pathResolver = pathResolver;
        this.securitySession = securitySession;
    }

    @Override
    public Object getInnerObject() {
        return this.path;
    }

    @Override
    public int getLength() {
        return this.path.getLength();
    }

    @Override
    public boolean isRoot() {
        return this.path.denotesRoot();
    }

    @Override
    public String getPathStr() {
        return this.jcrPath;
    }

    @Override
    public String getNodeName() throws NamespaceException {
        return this.pathResolver.getJCRName(this.path.getName());
    }

    @Override
    public boolean itemExist() throws RepositoryException {
        return this.securitySession.itemExists(this.path);
    }

    @Override
    public Item getItem() throws RepositoryException {
        return this.securitySession.getItem(this.path);
    }

    @Override
    public PathWrapper getAncestor() throws RepositoryException {
        return new JahiaJCRPathWrapperImpl(this.path.getAncestor(1), this.pathResolver, this.securitySession);
    }

    @Override
    public PathWrapper getNewPathWrapper(String path) throws RepositoryException {
        return new JahiaJCRPathWrapperImpl(this.pathResolver.getQPath(path), this.pathResolver, this.securitySession);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JahiaJCRPathWrapperImpl that = (JahiaJCRPathWrapperImpl)o;
        return Objects.equal((Object)this.path, (Object)that.path);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.path});
    }
}

