/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.helper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.servlet.http.HttpSession;
import org.atmosphere.cpr.AtmosphereResource;
import org.jahia.ajax.gwt.commons.server.ManagedGWTResource;
import org.jahia.bin.filters.jcr.JcrSessionFilter;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.utils.LanguageCodeConverters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class LocksHelper
implements ApplicationListener<ApplicationEvent> {
    private static Logger logger = LoggerFactory.getLogger(LocksHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(ApplicationEvent applicationEvent) {
        AtmosphereResource resource;
        if (applicationEvent instanceof JahiaContextLoaderListener.HttpSessionDestroyedEvent) {
            HttpSession httpSession = ((JahiaContextLoaderListener.HttpSessionDestroyedEvent)applicationEvent).getSession();
            if (httpSession.getAttribute("org.jahia.usermanager.jahiauser") != null) {
                if (JCRSessionFactory.getInstance().getCurrentUser() != null) {
                    this.closeAllLocks(httpSession);
                } else {
                    try {
                        JCRSessionFactory.getInstance().setCurrentUser((JahiaUser)httpSession.getAttribute("org.jahia.usermanager.jahiauser"));
                        this.closeAllLocks(httpSession);
                    }
                    finally {
                        JcrSessionFilter.endRequest();
                    }
                }
            }
        } else if (applicationEvent instanceof ManagedGWTResource.AtmosphereClientDisconnectedEvent) {
            AtmosphereResource resource2 = ((ManagedGWTResource.AtmosphereClientDisconnectedEvent)applicationEvent).getResource();
            HttpSession httpSession = resource2.getRequest().getSession();
            Map locks = (Map)httpSession.getAttribute("engineLocks");
            Map atmosphereResources = (Map)resource2.getRequest().getSession().getAttribute("atmosphereResources");
            if (atmosphereResources != null && atmosphereResources.containsKey(resource2.uuid())) {
                String key = (String)atmosphereResources.remove(resource2.uuid());
                if (locks != null && locks.containsKey(key)) {
                    if (JCRSessionFactory.getInstance().getCurrentUser() != null) {
                        this.closeAllLocks((List)locks.remove(key));
                    } else {
                        try {
                            JCRSessionFactory.getInstance().setCurrentUser((JahiaUser)httpSession.getAttribute("org.jahia.usermanager.jahiauser"));
                            this.closeAllLocks((List)locks.remove(key));
                        }
                        finally {
                            JcrSessionFilter.endRequest();
                        }
                    }
                }
            }
        } else if (applicationEvent instanceof ManagedGWTResource.AtmosphereClientReadyEvent && (resource = ((ManagedGWTResource.AtmosphereClientReadyEvent)applicationEvent).getResource()).getRequest().getParameter("windowId") != null) {
            HashMap<String, String> atmosphereResouces = (HashMap<String, String>)resource.getRequest().getSession().getAttribute("atmosphereResources");
            if (atmosphereResouces == null) {
                atmosphereResouces = new HashMap<String, String>();
            }
            atmosphereResouces.put(resource.uuid(), resource.getRequest().getParameter("windowId"));
            resource.getRequest().getSession().setAttribute("atmosphereResources", atmosphereResouces);
        }
    }

    private void closeAllLocks(HttpSession httpSession) {
        Map locks = (Map)httpSession.getAttribute("engineLocks");
        if (locks != null) {
            for (List list : locks.values()) {
                this.closeAllLocks(list);
            }
        }
    }

    private void closeAllLocks(List<String> locks) {
        try {
            for (String lock : locks) {
                String[] vals = lock.split("/");
                String localeForLock = vals[0];
                String lockedNodeId = vals[1];
                JCRSessionWrapper jcrsession = JCRSessionFactory.getInstance().getCurrentUserSession(null, LanguageCodeConverters.languageCodeToLocale(localeForLock));
                try {
                    jcrsession.getNodeByUUID(lockedNodeId).unlock("engine");
                }
                catch (LockException e) {
                    logger.warn("Problem while trying to unlock node: " + lockedNodeId + " - " + String.valueOf((Object)e));
                }
                catch (Exception e) {
                    logger.error("Unexpected problem while trying to unlock node - node may remain locked: " + lockedNodeId, (Throwable)e);
                }
            }
            locks.clear();
        }
        catch (RepositoryException e) {
            logger.error("Cannot release locks", (Throwable)e);
        }
    }
}

