/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.helper;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.value.StringValue;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodePropertyValue;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.service.GWTCompositeConstraintViolationException;
import org.jahia.ajax.gwt.client.service.GWTJahiaServiceException;
import org.jahia.ajax.gwt.content.server.UploadedPendingFile;
import org.jahia.ajax.gwt.helper.ContentDefinitionHelper;
import org.jahia.ajax.gwt.helper.NavigationHelper;
import org.jahia.api.Constants;
import org.jahia.bin.SessionNamedDataStorage;
import org.jahia.exceptions.JahiaException;
import org.jahia.services.categories.Category;
import org.jahia.services.content.CompositeConstraintViolationException;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.NodeConstraintViolationException;
import org.jahia.services.content.PropertyConstraintViolationException;
import org.jahia.services.content.nodetypes.ExtendedItemDefinition;
import org.jahia.services.content.nodetypes.ExtendedNodeDefinition;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.utils.EncryptionUtils;
import org.jahia.utils.i18n.JahiaLocaleContextHolder;
import org.jahia.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesHelper {
    private static final Logger logger = LoggerFactory.getLogger(PropertiesHelper.class);
    private ContentDefinitionHelper contentDefinition;
    private NavigationHelper navigation;
    private SessionNamedDataStorage<UploadedPendingFile> fileStorage;
    private Set<String> ignoredProperties = Collections.emptySet();

    public void setContentDefinition(ContentDefinitionHelper contentDefinition) {
        this.contentDefinition = contentDefinition;
    }

    public void setNavigation(NavigationHelper navigation) {
        this.navigation = navigation;
    }

    public void setFileStorage(SessionNamedDataStorage<UploadedPendingFile> fileStorage) {
        this.fileStorage = fileStorage;
    }

    public Map<String, GWTJahiaNodeProperty> getProperties(String path, JCRSessionWrapper currentUserSession, Locale uiLocale) throws GWTJahiaServiceException {
        JCRNodeWrapper objectNode;
        try {
            objectNode = currentUserSession.getNode(path);
        }
        catch (RepositoryException e) {
            logger.error(e.toString(), (Throwable)e);
            throw new GWTJahiaServiceException(path + Messages.getInternal("label.gwt.error.could.not.be.accessed", uiLocale) + e.toString());
        }
        HashMap<String, GWTJahiaNodeProperty> props = new HashMap<String, GWTJahiaNodeProperty>();
        String propName = "null";
        try {
            PropertyIterator it = objectNode.getProperties();
            while (it.hasNext()) {
                Property prop = it.nextProperty();
                PropertyDefinition def = prop.getDefinition();
                Property translationProp = null;
                if (def != null && !this.ignoredProperties.contains(def.getName()) && ((ExtendedPropertyDefinition)def).getSelectorOptions().get("password") == null) {
                    Value[] values;
                    propName = def.getName();
                    Locale locale = currentUserSession.getLocale();
                    if (Constants.nonI18nPropertiesCopiedToTranslationNodes.contains(propName) && objectNode.hasI18N(locale, false)) {
                        Node i18N = objectNode.getI18N(locale, false);
                        if (!i18N.hasProperty(propName)) continue;
                        translationProp = i18N.getProperty(propName);
                    }
                    GWTJahiaNodeProperty nodeProp = new GWTJahiaNodeProperty();
                    nodeProp.setName(propName);
                    nodeProp.setMultiple(def.isMultiple());
                    if (!def.isMultiple()) {
                        Value oneValue = translationProp == null ? prop.getValue() : translationProp.getValue();
                        values = new Value[]{oneValue};
                    } else {
                        values = translationProp == null ? prop.getValues() : translationProp.getValues();
                    }
                    ArrayList<GWTJahiaNodePropertyValue> gwtValues = new ArrayList<GWTJahiaNodePropertyValue>(values.length);
                    for (Value val : values) {
                        GWTJahiaNodePropertyValue convertedValue = this.contentDefinition.convertValue(val, (ExtendedPropertyDefinition)def);
                        if (convertedValue == null) continue;
                        gwtValues.add(convertedValue);
                    }
                    nodeProp.setValues(gwtValues);
                    props.put(nodeProp.getName(), nodeProp);
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("The following property has been ignored " + prop.getName() + "," + prop.getPath());
            }
            JCRNodeIteratorWrapper ni = objectNode.getNodes();
            while (ni.hasNext()) {
                ArrayList<GWTJahiaNodePropertyValue> gwtValues;
                GWTJahiaNodeProperty nodeProp;
                NodeDefinition def;
                Node node = ni.nextNode();
                if (node.isNodeType("nt:resource")) {
                    def = node.getDefinition();
                    propName = def.getName();
                    nodeProp = new GWTJahiaNodeProperty();
                    nodeProp.setName(propName);
                    gwtValues = new ArrayList<GWTJahiaNodePropertyValue>();
                    gwtValues.add(new GWTJahiaNodePropertyValue(node.getProperty("jcr:mimeType").getString(), 20));
                    nodeProp.setValues(gwtValues);
                    props.put(nodeProp.getName(), nodeProp);
                    continue;
                }
                if (!node.isNodeType("jmix:link")) continue;
                def = node.getDefinition();
                propName = def.getName();
                nodeProp = new GWTJahiaNodeProperty();
                nodeProp.setName(propName);
                gwtValues = new ArrayList();
                GWTJahiaNode linkNode = this.navigation.getGWTJahiaNode((JCRNodeWrapper)node);
                if (node.isNodeType("jnt:nodeLink")) {
                    linkNode.set("linkType", (Object)"internal");
                } else if (node.isNodeType("jnt:externalLink")) {
                    linkNode.set("linkType", (Object)"external");
                }
                if (node.hasProperty("j:url")) {
                    String linkUrl = node.getProperty("j:url").getValue().getString();
                    linkNode.set("j:url", (Object)linkUrl);
                }
                if (node.hasProperty("jcr:title")) {
                    String linkTitle = node.getProperty("jcr:title").getValue().getString();
                    linkNode.set("jcr:title", (Object)linkTitle);
                }
                if (node.hasProperty("j:alt")) {
                    String alt = node.getProperty("j:alt").getValue().getString();
                    linkNode.set("j:alt", (Object)alt);
                }
                if (node.hasProperty("j:node")) {
                    JCRValueWrapper weekReference = (JCRValueWrapper)node.getProperty("j:node").getValue();
                    JCRNodeWrapper pageNode = weekReference.getNode();
                    if (pageNode != null) {
                        linkNode.set("j:node", (Object)this.navigation.getGWTJahiaNode(pageNode));
                        linkNode.set("j:alt", (Object)pageNode.getName());
                        linkNode.set("j:url", (Object)pageNode.getUrl());
                        linkNode.set("jcr:title", (Object)pageNode.getUrl());
                    } else {
                        String resource = Messages.getInternal("label.error.invalidlink", uiLocale);
                        linkNode.set("jcr:title", (Object)resource);
                        linkNode.set("j:alt", (Object)resource);
                    }
                }
                GWTJahiaNodePropertyValue proper = new GWTJahiaNodePropertyValue(linkNode, 21);
                gwtValues.add(proper);
                nodeProp.setValues(gwtValues);
                props.put(nodeProp.getName(), nodeProp);
            }
        }
        catch (RepositoryException e) {
            logger.error("Cannot access property " + propName + " of node " + objectNode.getName(), (Throwable)e);
        }
        return props;
    }

    public void saveProperties(List<GWTJahiaNode> nodes, List<GWTJahiaNodeProperty> newProps, Set<String> removedTypes, JCRSessionWrapper currentUserSession, Locale uiLocale, String httpSessionID) throws RepositoryException {
        for (GWTJahiaNode aNode : nodes) {
            JCRNodeWrapper objectNode = currentUserSession.getNode(aNode.getPath());
            List types = aNode.getNodeTypes();
            if (removedTypes != null && !removedTypes.isEmpty()) {
                List<ExtendedItemDefinition> items;
                for (ExtendedNodeType mixin : objectNode.getMixinNodeTypes()) {
                    if (!removedTypes.contains(mixin.getName())) continue;
                    items = mixin.getItems();
                    for (ExtendedItemDefinition item : items) {
                        this.removeItemFromNode(item, objectNode, currentUserSession);
                    }
                    objectNode.removeMixin(mixin.getName());
                }
                for (ExtendedNodeType mixin : objectNode.getPrimaryNodeType().getDeclaredSupertypes()) {
                    if (!removedTypes.contains(mixin.getName())) continue;
                    items = mixin.getItems();
                    for (ExtendedItemDefinition item : items) {
                        this.removeItemFromNode(item, objectNode, currentUserSession);
                    }
                }
            }
            for (String type : types) {
                if (objectNode.isNodeType(type)) continue;
                currentUserSession.checkout(objectNode);
                objectNode.addMixin(type);
            }
            this.setProperties(objectNode, newProps, httpSessionID);
        }
    }

    private void removeItemFromNode(ExtendedItemDefinition item, JCRNodeWrapper objectNode, JCRSessionWrapper currentUserSession) throws RepositoryException {
        if (!item.isUnstructured()) {
            if (item.isNode()) {
                if (objectNode.hasNode(item.getName())) {
                    currentUserSession.checkout(objectNode);
                    objectNode.getNode(item.getName()).remove();
                }
            } else if (item instanceof ExtendedPropertyDefinition) {
                ExtendedPropertyDefinition itemProperty = (ExtendedPropertyDefinition)item;
                if (itemProperty.isInternationalized()) {
                    NodeIterator nodeIterator = objectNode.getI18Ns();
                    while (nodeIterator.hasNext()) {
                        Node i18nNode = nodeIterator.nextNode();
                        if (!i18nNode.hasProperty(item.getName())) continue;
                        currentUserSession.checkout(i18nNode);
                        objectNode.getProvider().getPropertyWrapper(i18nNode.getProperty(item.getName()), objectNode.getSession()).remove();
                    }
                } else if (objectNode.hasProperty(item.getName())) {
                    currentUserSession.checkout(objectNode);
                    objectNode.getProperty(item.getName()).remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(JCRNodeWrapper objectNode, List<GWTJahiaNodeProperty> newProps, String httpSessionID) throws RepositoryException {
        if (objectNode == null || newProps == null || newProps.isEmpty()) {
            logger.debug("node or properties are null or empty");
            return;
        }
        if (!objectNode.isCheckedOut()) {
            objectNode.checkout();
        }
        for (GWTJahiaNodeProperty prop : newProps) {
            try {
                if (prop == null || prop.getName().equals("*") || Constants.forbiddenPropertiesToCopy.contains(prop.getName())) continue;
                if (prop.isMultiple()) {
                    ArrayList<Value> values = new ArrayList<Value>();
                    for (GWTJahiaNodePropertyValue val : prop.getValues()) {
                        if (val.getString() == null) continue;
                        values.add(this.contentDefinition.convertValue(val, objectNode.getApplicablePropertyDefinition(prop.getName(), 0, true)));
                    }
                    Value[] finalValues = new Value[values.size()];
                    values.toArray(finalValues);
                    objectNode.setProperty(prop.getName(), finalValues);
                    continue;
                }
                if (prop.getValues().size() > 0) {
                    GWTJahiaNodePropertyValue propValue = (GWTJahiaNodePropertyValue)prop.getValues().get(0);
                    if (httpSessionID != null && propValue.getType() == 20) {
                        UploadedPendingFile fileItem = this.fileStorage.get(httpSessionID, propValue.getString());
                        try {
                            ExtendedNodeDefinition end;
                            boolean clear = propValue.getString().equals("clear");
                            if (!clear && fileItem == null || (end = objectNode.getPrimaryNodeType().getChildNodeDefinitionsAsMap().get(prop.getName())) == null) continue;
                            try {
                                if (!clear) {
                                    String s = end.getRequiredPrimaryTypeNames()[0];
                                    JCRNodeWrapper content = objectNode.hasNode(prop.getName()) ? objectNode.getNode(prop.getName()) : objectNode.addNode(prop.getName(), s.equals("nt:base") ? "jnt:resource" : s);
                                    content.setProperty("jcr:mimeType", fileItem.getContentType());
                                    InputStream is = fileItem.getContentStream();
                                    try {
                                        content.setProperty("jcr:data", is);
                                    }
                                    finally {
                                        IOUtils.closeQuietly((InputStream)is);
                                    }
                                    content.setProperty("jcr:lastModified", new GregorianCalendar());
                                    continue;
                                }
                                if (!objectNode.hasNode(prop.getName())) continue;
                                objectNode.getNode(prop.getName()).remove();
                            }
                            catch (Exception e) {
                                logger.error(e.getMessage(), (Throwable)e);
                            }
                            continue;
                        }
                        finally {
                            if (fileItem == null) continue;
                            fileItem.close();
                            this.fileStorage.remove(httpSessionID, propValue.getString());
                            continue;
                        }
                    }
                    if (propValue.getType() == 21) {
                        JCRNodeWrapper content;
                        if (objectNode.hasNode(prop.getName())) {
                            Node content2 = objectNode.getNodes(prop.getName()).nextNode();
                            content2.remove();
                        }
                        GWTJahiaNode gwtJahiaNode = propValue.getLinkNode();
                        String linkUrl = (String)gwtJahiaNode.get("j:url");
                        String linkTitle = (String)gwtJahiaNode.get("jcr:title");
                        String alt = (String)gwtJahiaNode.get("j:alt");
                        String linkType = (String)gwtJahiaNode.get("linkType");
                        GWTJahiaNode nodeReference = (GWTJahiaNode)gwtJahiaNode.get("j:node");
                        if (linkType.equalsIgnoreCase("external") && linkUrl != null) {
                            content = objectNode.addNode(prop.getName(), "jnt:externalLink");
                            content.setProperty("jcr:title", linkTitle);
                            content.setProperty("j:url", linkUrl);
                            content.setProperty("j:alt", alt);
                            content.setProperty("jcr:lastModified", new GregorianCalendar());
                            continue;
                        }
                        if (!linkType.equalsIgnoreCase("internal") || nodeReference == null) continue;
                        content = objectNode.addNode(prop.getName(), "jnt:nodeLink");
                        content.setProperty("jcr:title", linkTitle);
                        content.setProperty("j:node", nodeReference.getUUID());
                        content.setProperty("jcr:lastModified", new GregorianCalendar());
                        continue;
                    }
                    ExtendedPropertyDefinition epd = objectNode.getApplicablePropertyDefinition(prop.getName());
                    if (epd != null && epd.getSelectorOptions().containsKey("password")) {
                        if (propValue == null || propValue.getString() == null) continue;
                        String enc = this.encryptPassword(propValue.getString());
                        StringValue value = new StringValue(enc);
                        objectNode.setProperty(prop.getName(), (Value)value);
                        continue;
                    }
                    if (propValue != null && propValue.getString() != null) {
                        Value value = this.contentDefinition.convertValue(propValue, epd);
                        objectNode.setProperty(prop.getName(), value);
                        continue;
                    }
                    if (!objectNode.hasProperty(prop.getName())) continue;
                    objectNode.getProperty(prop.getName()).remove();
                    continue;
                }
                if (!objectNode.hasProperty(prop.getName())) continue;
                objectNode.getProperty(prop.getName()).remove();
            }
            catch (PathNotFoundException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Property with the name '" + prop.getName() + "' not found on the node " + objectNode.getPath() + ". Skipping.", (Throwable)e);
                    continue;
                }
                logger.info("Property with the name '" + prop.getName() + "' not found on the node " + objectNode.getPath() + ". Skipping.");
            }
        }
    }

    public List<Value> getCategoryPathValues(String value) {
        String[] categories;
        if (value == null || value.length() == 0) {
            return Collections.emptyList();
        }
        LinkedList<Value> values = new LinkedList<Value>();
        for (String categoryKey : categories = StringUtils.split((String)value, (String)",")) {
            try {
                values.add((Value)new StringValue(Category.getCategoryPath(categoryKey.trim())));
            }
            catch (JahiaException e) {
                logger.warn("Unable to retrieve category path for category key '" + categoryKey + "'. Cause: " + e.getMessage(), (Throwable)e);
            }
        }
        return values;
    }

    public void setIgnoredProperties(Set<String> ignoredProperties) {
        this.ignoredProperties = ignoredProperties != null ? ignoredProperties : Collections.emptySet();
    }

    public String encryptPassword(String pwd) {
        return StringUtils.isNotEmpty((String)pwd) ? EncryptionUtils.passwordBaseEncrypt(pwd) : "";
    }

    public void convertException(NodeConstraintViolationException violationException) throws GWTJahiaServiceException {
        GWTCompositeConstraintViolationException gwt = new GWTCompositeConstraintViolationException(violationException.getMessage());
        this.addConvertedException(violationException, gwt);
        throw gwt;
    }

    public void convertException(CompositeConstraintViolationException e) throws GWTJahiaServiceException {
        GWTCompositeConstraintViolationException gwt = new GWTCompositeConstraintViolationException(e.getMessage());
        for (ConstraintViolationException violationException : e.getErrors()) {
            if (!(violationException instanceof NodeConstraintViolationException)) continue;
            this.addConvertedException((NodeConstraintViolationException)violationException, gwt);
        }
        throw gwt;
    }

    private void addConvertedException(NodeConstraintViolationException violationException, GWTCompositeConstraintViolationException gwt) throws GWTJahiaServiceException {
        if (violationException instanceof PropertyConstraintViolationException) {
            PropertyConstraintViolationException v = (PropertyConstraintViolationException)violationException;
            gwt.addError(v.getPath(), v.getConstraintMessage(), v.getLocale() != null ? v.getLocale().toString() : null, v.getDefinition().getName(), v.getDefinition().getLabel(JahiaLocaleContextHolder.getLocale(), v.getDefinition().getDeclaringNodeType()));
        } else {
            NodeConstraintViolationException v = violationException;
            gwt.addError(v.getPath(), v.getConstraintMessage(), v.getLocale() != null ? v.getLocale().toString() : null, null, null);
        }
    }
}

