/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jahia.bin.Jahia;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.data.templates.ModuleState;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.settings.SettingsBean;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndInit
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(EndInit.class);
    private static final String LINE = "--------------------------------------------------------------------------------------------------";
    private static final long serialVersionUID = -2221764992780224013L;
    private boolean initialized = false;

    private void appendModulesInfo() {
        JahiaTemplateManagerService templateService = ServicesRegistry.getInstance().getJahiaTemplateManagerService();
        logger.info("  Modules:");
        for (ModuleState.State state : ModuleState.State.values()) {
            List<Bundle> modules = templateService.getModulesByState(state);
            if (modules.isEmpty()) continue;
            logger.info("      {}: {}", (Object)state, (Object)modules.size());
        }
    }

    public void destroy() {
        super.destroy();
        logger.info("Jahia is shutting down, please wait...");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.initialized) {
            resp.sendError(503);
        }
    }

    public void init() throws ServletException {
        super.init();
        logger.info("Got into EndInit");
        JahiaContextLoaderListener.endContextInitialized();
        this.printEndMessage();
        this.initialized = true;
    }

    private void printEndMessage() {
        long initializationTime = System.currentTimeMillis() - JahiaContextLoaderListener.getStartupTime();
        logger.info(LINE);
        if (SettingsBean.getInstance().isDevelopmentMode()) {
            logger.info("  D E V E L O P M E N T   M O D E   A C T I V E");
            logger.info("  In development mode, Jahia will allow JSPs to be modified, modules to be");
            logger.info("  re-deployed and other modifications to happen immediately, but these DO have a performance impact.");
            logger.info("  It is strongly recommended to switch to production mode when running performance tests or going live.");
            logger.info("  The setting to change modes is called operatingMode in the jahia.properties configuration file.");
        } else if (SettingsBean.getInstance().isDistantPublicationServerMode()) {
            logger.info("  D I S T A N T  P U B L I C A T I O N  S E R V E R  M O D E   A C T I V E");
        } else {
            logger.info("  P R O D U C T I O N   M O D E   A C T I V E");
        }
        logger.info(LINE);
        this.appendModulesInfo();
        logger.info(LINE);
        logger.info("  {} is now ready. Initialization completed in {} seconds", (Object)Jahia.getFullProductVersion(), (Object)(initializationTime / 1000L));
        logger.info(LINE);
    }
}

