/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.BaseFindController;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.render.RenderException;
import org.jahia.services.render.URLResolver;
import org.jahia.services.render.URLResolverFactory;
import org.jahia.services.render.filter.HistoryTrackerBean;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(since="8.2.1.0", forRemoval=true)
public class FindHistory
extends BaseFindController {
    private static Logger logger = LoggerFactory.getLogger(FindHistory.class);
    private int defaultDepthLimit = 1;
    private boolean defaultEscapeColon = false;
    private boolean defaultRemoveDuplicatePropertyValues = false;
    private URLResolverFactory urlResolverFactory;

    public void setUrlResolverFactory(URLResolverFactory urlResolverFactory) {
        this.urlResolverFactory = urlResolverFactory;
    }

    private int getInt(String paramName, int defaultValue, HttpServletRequest req) throws IllegalArgumentException {
        int param = defaultValue;
        String valueStr = req.getParameter(paramName);
        if (StringUtils.isNotEmpty((String)valueStr)) {
            try {
                param = Integer.parseInt(valueStr);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Invalid integer value '" + valueStr + "' for request parameter '" + paramName + "'", nfe);
            }
        }
        return param;
    }

    @Override
    protected void handle(HttpServletRequest request, HttpServletResponse response) throws RenderException, IOException, RepositoryException {
        URLResolver urlResolver = this.urlResolverFactory.createURLResolver(request.getPathInfo(), request.getServerName(), request);
        try {
            List l;
            if (request.getSession() == null) {
                return;
            }
            String name = request.getParameter("trackerName");
            if (name == null) {
                name = "historyTracker";
            }
            if ((l = (List)request.getSession().getAttribute(HistoryTrackerBean.class.getName() + "." + name)) == null) {
                return;
            }
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession(urlResolver.getWorkspace(), urlResolver.getLocale()).disableSessionCache();
            this.writeResults(l, session, request, response);
        }
        catch (IllegalArgumentException e) {
            logger.error("Invalid argument", (Throwable)e);
            response.sendError(400, e.getMessage());
        }
        catch (InvalidQueryException e) {
            logger.error("Invalid query", (Throwable)e);
            response.sendError(400, e.getMessage());
        }
    }

    private JSONObject serializeNode(Node currentNode, int depthLimit, boolean escapeColon, Pattern propertyMatchRegexp, Map<String, String> alreadyIncludedPropertyValues) throws RepositoryException, JSONException {
        PropertyIterator stringMap = currentNode.getProperties();
        JSONObject jsonObject = new JSONObject();
        HashSet<String> matchingProperties = new HashSet<String>();
        while (stringMap.hasNext()) {
            JCRValueWrapper[] propValues;
            String name;
            JCRPropertyWrapper propertyWrapper = (JCRPropertyWrapper)stringMap.next();
            int type = propertyWrapper.getType();
            String string = name = escapeColon ? JCRContentUtils.replaceColon(propertyWrapper.getName()) : propertyWrapper.getName();
            if (type == 2) continue;
            if (type == 10 || type == 9) {
                if (propertyWrapper.isMultiple()) continue;
                jsonObject.put(name, (Object)((JCRNodeWrapper)propertyWrapper.getNode()).getUrl());
                continue;
            }
            if (!propertyWrapper.isMultiple()) {
                jsonObject.put(name, (Object)propertyWrapper.getValue().getString());
                if (propertyMatchRegexp == null || !propertyMatchRegexp.matcher(propertyWrapper.getValue().getString()).matches()) continue;
                if (alreadyIncludedPropertyValues != null) {
                    String nodeIdentifier = alreadyIncludedPropertyValues.get(propertyWrapper.getValue().getString());
                    if (nodeIdentifier != null) {
                        if (!nodeIdentifier.equals(currentNode.getIdentifier())) {
                            return null;
                        }
                    } else {
                        alreadyIncludedPropertyValues.put(propertyWrapper.getValue().getString(), currentNode.getIdentifier());
                    }
                }
                matchingProperties.add(name);
                continue;
            }
            JSONArray jsonArray = new JSONArray();
            for (JCRValueWrapper propValue : propValues = propertyWrapper.getValues()) {
                jsonArray.put((Object)propValue.getString());
                if (propertyMatchRegexp == null || !propertyMatchRegexp.matcher(propValue.getString()).matches()) continue;
                if (alreadyIncludedPropertyValues != null) {
                    String nodeIdentifier = alreadyIncludedPropertyValues.get(propValue.getString());
                    if (nodeIdentifier != null) {
                        if (!nodeIdentifier.equals(currentNode.getIdentifier())) {
                            return null;
                        }
                    } else {
                        alreadyIncludedPropertyValues.put(propValue.getString(), currentNode.getIdentifier());
                    }
                }
                matchingProperties.add(name);
            }
            jsonObject.put(name, (Object)jsonArray);
        }
        jsonObject.put("path", (Object)currentNode.getPath());
        jsonObject.put("identifier", (Object)currentNode.getIdentifier());
        jsonObject.put("index", currentNode.getIndex());
        jsonObject.put("depth", currentNode.getDepth());
        jsonObject.put("nodename", (Object)currentNode.getName());
        jsonObject.put("primaryNodeType", (Object)currentNode.getPrimaryNodeType().getName());
        if (propertyMatchRegexp != null) {
            jsonObject.put("matchingProperties", (Object)new JSONArray(matchingProperties));
        }
        if (depthLimit - 1 > 0) {
            NodeIterator childNodeIterator = currentNode.getNodes();
            JSONArray childMapList = new JSONArray();
            while (childNodeIterator.hasNext()) {
                Node currentChildNode = childNodeIterator.nextNode();
                JSONObject childSerializedMap = this.serializeNode(currentChildNode, depthLimit - 1, escapeColon, propertyMatchRegexp, alreadyIncludedPropertyValues);
                childMapList.put((Object)childSerializedMap);
            }
            jsonObject.put("childNodes", (Object)childMapList);
        }
        return jsonObject;
    }

    public void setDefaultDepthLimit(int defaultDepthLimit) {
        this.defaultDepthLimit = defaultDepthLimit;
    }

    public void setDefaultEscapeColon(boolean defaultEscapeColon) {
        this.defaultEscapeColon = defaultEscapeColon;
    }

    public boolean isDefaultRemoveDuplicatePropertyValues() {
        return this.defaultRemoveDuplicatePropertyValues;
    }

    public void setDefaultRemoveDuplicatePropertyValues(boolean defaultRemoveDuplicatePropertyValues) {
        this.defaultRemoveDuplicatePropertyValues = defaultRemoveDuplicatePropertyValues;
    }

    private void writeResults(List<String> result, JCRSessionWrapper session, HttpServletRequest request, HttpServletResponse response) throws RepositoryException, IllegalArgumentException, IOException, RenderException {
        response.setContentType("application/json; charset=UTF-8");
        int depth = this.getInt("depthLimit", this.defaultDepthLimit, request);
        boolean escape = Boolean.valueOf(StringUtils.defaultIfEmpty((String)request.getParameter("escapeColon"), (String)String.valueOf(this.defaultEscapeColon)));
        boolean removeDuplicatePropertyValues = Boolean.valueOf(StringUtils.defaultIfEmpty((String)request.getParameter("removeDuplicatePropValues"), (String)String.valueOf(this.defaultRemoveDuplicatePropertyValues)));
        JSONArray results = new JSONArray();
        try {
            HashMap<String, String> alreadyIncludedPropertyValues = null;
            if (removeDuplicatePropertyValues) {
                alreadyIncludedPropertyValues = new HashMap<String, String>();
            }
            logger.debug("Serializing nodes into JSON result structure...");
            int resultCount = 0;
            for (String uuid : result) {
                try {
                    JCRNodeWrapper w = session.getNodeByIdentifier(uuid);
                    JSONObject serializedNode = this.serializeNode(w, depth, escape, null, alreadyIncludedPropertyValues);
                    if (serializedNode == null) continue;
                    results.put((Object)serializedNode);
                    ++resultCount;
                }
                catch (ItemNotFoundException itemNotFoundException) {}
            }
            logger.debug("Found " + resultCount + " results.");
            results.write((Writer)response.getWriter());
        }
        catch (JSONException e) {
            throw new RenderException(e);
        }
    }

    public static String getFindServletPath() {
        return "/cms/findHistory";
    }
}

