/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jahia.bin.JahiaMultiActionController;
import org.jahia.services.mail.MailService;
import org.jahia.services.mail.MailServiceImpl;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Notifications
extends JahiaMultiActionController {
    private static Logger logger = LoggerFactory.getLogger(Notifications.class);
    private MailServiceImpl mailService;

    private void sendEmail(String host, String from, String to, String subject, String text) {
        this.mailService.sendMessage((!host.startsWith("smtp://") && !host.startsWith("smtps://") ? "smtp://" : "") + host, from, to, null, null, subject, text, null);
    }

    public void setMailService(MailServiceImpl mailService) {
        this.mailService = mailService;
    }

    public void testEmail(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block6: {
            try {
                this.checkUserAuthorized();
                String host = Notifications.getParameter(request, "host");
                String from = Notifications.getParameter(request, "from");
                String to = Notifications.getParameter(request, "to");
                response.setCharacterEncoding(SettingsBean.getInstance().getCharacterEncoding());
                Locale locale = (Locale)request.getSession(true).getAttribute("org.jahia.services.multilang.uilocale");
                Locale locale2 = locale = locale != null ? locale : request.getLocale();
                if (logger.isDebugEnabled()) {
                    logger.debug("Request received for sending test e-mail from '{}' to '{}' using configuration '{}'", (Object[])new String[]{from, to, host});
                }
                if (!MailService.isValidEmailAddress(to, true)) {
                    response.setStatus(400);
                    response.getWriter().append(Messages.get("resources.JahiaServerSettings", "serverSettings.mailServerSettings.errors.email.to", locale, "Please provide a valid administrator e-mail address"));
                    return;
                }
                if (!MailService.isValidEmailAddress(from, false)) {
                    response.setStatus(400);
                    response.getWriter().append(Messages.get("resources.JahiaServerSettings", "serverSettings.mailServerSettings.errors.email.from", locale, "Please provide a valid sender e-mail address"));
                    return;
                }
                String subject = Messages.get("resources.JahiaServerSettings", "serverSettings.mailServerSettings.testSettings.mailSubject", locale, "[Jahia] Test message");
                String text = Messages.get("resources.JahiaServerSettings", "serverSettings.mailServerSettings.testSettings.mailText", locale, "Test message");
                this.sendEmail(host, from, to, subject, text);
                response.setStatus(200);
            }
            catch (Exception e) {
                logger.warn("Error sending test e-mail message. Cause: " + e.getMessage(), (Throwable)e);
                response.setStatus(500);
                if (response.getWriter() == null) break block6;
                if (e.getCause() != null) {
                    response.getWriter().append(e.getCause().getMessage());
                }
                response.getWriter().append(e.getMessage());
            }
        }
    }
}

