/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin.listeners;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.WriterAppender;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.builder.impl.DefaultConfigurationBuilder;
import org.apache.logging.log4j.web.Log4jServletContextListener;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.osgi.FrameworkService;

public class LoggingConfigListener
extends Log4jServletContextListener {
    static final Logger logger = Logger.getLogger(LoggingConfigListener.class.getName());
    public static final String EVENT_TOPIC_LOGGING = "org/jahia/dx/logging";
    public static final String EVENT_TYPE_LOGGING_CONFIG_CHANGED = "loggingConfigurationChanged";
    private static final String JAHIA_LOG_DIR = "jahia.log.dir";
    private static final String JAHIA_LOG4J_CONFIG = "jahia.log4j.config";
    private static final String JAHIA_LOG4J_XML = "jahia/log4j2.xml";

    public static Map<String, Object> getConfig() {
        HashMap<String, Object> p = new HashMap<String, Object>();
        LoggerContext logContext = (LoggerContext)LogManager.getContext((boolean)false);
        for (LoggerConfig logger : logContext.getConfiguration().getLoggers().values()) {
            if (logger.getLevel() == null) continue;
            if (StringUtils.isEmpty((CharSequence)logger.getName())) {
                p.put("log4j2.rootLogger.level", logger.getLevel().toString());
                continue;
            }
            String loggerIdentifier = StringUtils.replace((String)logger.getName(), (String)".", (String)"_");
            p.put("log4j2.logger." + loggerIdentifier + ".name", logger.getName());
            p.put("log4j2.logger." + loggerIdentifier + ".level", logger.getLevel().toString());
        }
        return p;
    }

    public static String getRootLoggerLevel() {
        return LogManager.getRootLogger().getLevel().toString();
    }

    private static LoggerConfig getTargetLoggerConfig(Configuration config, String logger) {
        return StringUtils.isEmpty((CharSequence)logger) || StringUtils.equalsIgnoreCase((CharSequence)logger, (CharSequence)"root") ? config.getRootLogger() : config.getLoggerConfig(logger);
    }

    public static void setLoggerLevel(String logger, String level) {
        LoggerContext logContext = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = logContext.getConfiguration();
        if (StringUtils.isEmpty((CharSequence)logger) || "root".equals(logger) || LoggingConfigListener.getTargetLoggerConfig(config, logger).getName().equals(logger)) {
            LoggingConfigListener.getTargetLoggerConfig(config, logger).setLevel(Level.toLevel((String)level));
        } else {
            config.addLogger(logger, LoggerConfig.createLogger((boolean)true, (Level)Level.getLevel((String)level), (String)logger, null, (AppenderRef[])new AppenderRef[0], null, (Configuration)new DefaultConfigurationBuilder().build(), null));
        }
        logContext.updateLoggers();
        logContext.getLogger(logger);
        FrameworkService.sendEvent(EVENT_TOPIC_LOGGING, Collections.singletonMap("type", EVENT_TYPE_LOGGING_CONFIG_CHANGED), false);
    }

    public static Writer createLogAwareWriter(String logger) {
        StringWriter stringWriter = new StringWriter();
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        WriterAppender writerAppender = ((WriterAppender.Builder)WriterAppender.newBuilder().setName(logger + "writeLogger")).setTarget((Writer)stringWriter).build();
        writerAppender.start();
        config.addAppender((Appender)writerAppender);
        LoggerConfig loggerConfig = config.getLoggerConfig(logger);
        if (!loggerConfig.getName().equals(logger)) {
            config.addLogger(logger, LoggerConfig.createLogger((boolean)true, (Level)Level.INFO, (String)logger, null, (AppenderRef[])new AppenderRef[0], null, (Configuration)new DefaultConfigurationBuilder().build(), null));
            loggerConfig = config.getLoggerConfig(logger);
        }
        loggerConfig.addAppender((Appender)writerAppender, null, null);
        ctx.updateLoggers();
        return stringWriter;
    }

    public static void removeLogAwareWriter(String logger) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig(logger);
        loggerConfig.removeAppender(logger + "writeLogger");
        ctx.updateLoggers();
    }

    public void contextInitialized(ServletContextEvent event) {
        this.initLogDir(event.getServletContext());
        this.initLog4jLocation();
        JahiaContextLoaderListener.setSystemProperty("java.util.logging.manager", "org.apache.logging.log4j.jul.LogManager");
        super.contextInitialized(event);
    }

    private void initLog4jLocation() {
        String lookup = null;
        if (System.getProperty(JAHIA_LOG4J_CONFIG) == null) {
            lookup = ((Object)((Object)this)).getClass().getResource("/jahia/log4j2.xml") != null ? "classpath:jahia/log4j2.xml" : "/WEB-INF/etc/config/log4j2.xml";
            JahiaContextLoaderListener.setSystemProperty(JAHIA_LOG4J_CONFIG, lookup);
        } else {
            lookup = System.getProperty(JAHIA_LOG4J_CONFIG, lookup);
        }
        logger.log(java.util.logging.Level.INFO, "Set log4j2.xml configuration location to: {0}", lookup);
    }

    protected void initLogDir(ServletContext servletContext) {
        Object logDir = System.getProperty(JAHIA_LOG_DIR);
        if (logDir == null && StringUtils.containsIgnoreCase((CharSequence)servletContext.getServerInfo(), (CharSequence)"tomcat")) {
            logDir = this.resolveLogDir(servletContext.getRealPath("/"));
        }
        if (logDir != null) {
            if (!((String)logDir).endsWith("/") || !((String)logDir).endsWith("\\")) {
                logDir = (String)logDir + File.separator;
            }
            JahiaContextLoaderListener.setSystemProperty(JAHIA_LOG_DIR, (String)logDir);
        }
        logger.log(java.util.logging.Level.INFO, "Logging directory set to: {0}", logDir != null ? logDir : "<current>");
    }

    private String resolveLogDir(String path) {
        try {
            File logs;
            File tomcatHome;
            File war;
            if (path != null && (war = new File(path)).getParentFile() != null && "webapps".equals(war.getParentFile().getName()) && (tomcatHome = war.getParentFile().getParentFile()).exists() && (logs = new File(tomcatHome, "logs")).isDirectory() && logs.canWrite()) {
                return logs.getAbsolutePath();
            }
        }
        catch (Exception e) {
            logger.log(java.util.logging.Level.WARNING, "Cannot resolve logging directory", e);
        }
        return null;
    }
}

