/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.params.valves;

import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import org.jahia.params.valves.AuthValveContext;
import org.jahia.params.valves.BaseAuthValve;
import org.jahia.pipelines.PipelineException;
import org.jahia.pipelines.valves.ValveContext;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerAuthValveImpl
extends BaseAuthValve {
    private static final Logger logger = LoggerFactory.getLogger(ContainerAuthValveImpl.class);

    @Override
    public void invoke(Object context, ValveContext valveContext) throws PipelineException {
        if (!this.isEnabled()) {
            valveContext.invokeNext(context);
            return;
        }
        AuthValveContext authContext = (AuthValveContext)context;
        HttpServletRequest request = authContext.getRequest();
        Principal principal = request.getUserPrincipal();
        if (principal != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Found user " + principal.getName() + "  already in HttpServletRequest, using it to try to login...(Principal.toString=" + String.valueOf(principal));
            }
            try {
                JCRUserNode userNode = JahiaUserManagerService.getInstance().lookupUser(principal.getName());
                if (userNode != null) {
                    if (userNode.isAccountLocked()) {
                        logger.debug("Login failed. Account is locked for user " + principal.getName());
                        return;
                    }
                    authContext.getSessionFactory().setCurrentUser(userNode.getJahiaUser());
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        valveContext.invokeNext(context);
    }
}

