/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.atmosphere.service;

import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.util.Text;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.jahia.bin.Jahia;
import org.jahia.services.atmosphere.AtmosphereServlet;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.utils.i18n.Messages;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublisherSubscriberService {
    private static transient Logger logger = LoggerFactory.getLogger(PublisherSubscriberService.class);

    public void publishToSite(JCRNodeWrapper node, String message) {
        try {
            JCRSiteNode resolveSite = node.getResolveSite();
            List<Locale> activeLanguagesAsLocales = resolveSite.getActiveLiveLanguagesAsLocales();
            JCRNodeWrapper parentOfType = JCRContentUtils.getParentOfType(node, "jnt:page");
            String pagePath = Text.escapePath((String)(parentOfType != null ? parentOfType.getPath() : node.getPath())) + ".html";
            for (Locale activeLanguagesAsLocale : activeLanguagesAsLocales) {
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.put("body", (Object)Messages.get(resolveSite.getTemplatePackage(), message, activeLanguagesAsLocale));
                }
                catch (MissingResourceException e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                    jsonObject.put("body", (Object)(message + " is missing or cannot be resolved"));
                }
                String path = "/cms/render";
                String url = Jahia.getContextPath() + path + "/" + resolveSite.getSession().getWorkspace().getName() + "/" + String.valueOf(activeLanguagesAsLocale) + pagePath;
                jsonObject.put("url", (Object)url);
                jsonObject.put("name", (Object)node.getDisplayableName());
                this.broadcast(resolveSite.getSiteKey() + "-" + String.valueOf(activeLanguagesAsLocale), jsonObject.toString(), false);
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (JSONException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void publishToNodeChannel(JCRNodeWrapper node, String message) {
        try {
            JCRSiteNode resolveSite = node.getResolveSite();
            List<Locale> activeLanguagesAsLocales = resolveSite.getActiveLiveLanguagesAsLocales();
            JCRNodeWrapper parentOfType = JCRContentUtils.getParentOfType(node, "jnt:page");
            String pagePath = Text.escapePath((String)(parentOfType != null ? parentOfType.getPath() : node.getPath())) + ".html";
            for (Locale activeLanguagesAsLocale : activeLanguagesAsLocales) {
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.put("body", (Object)Messages.get(resolveSite.getTemplatePackage(), message, activeLanguagesAsLocale));
                }
                catch (MissingResourceException e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                    jsonObject.put("body", (Object)(message + " is missing or cannot be resolved"));
                }
                String path = "/cms/render";
                String url = Jahia.getContextPath() + path + "/" + resolveSite.getSession().getWorkspace().getName() + "/" + String.valueOf(activeLanguagesAsLocale) + pagePath;
                jsonObject.put("url", (Object)url);
                jsonObject.put("name", (Object)node.getDisplayableName());
                this.broadcast(node.getIdentifier() + "-" + String.valueOf(activeLanguagesAsLocale), jsonObject.toString(), false);
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (JSONException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void publishToAbsoluteChannel(String absoluteChannelName, String message) {
        this.broadcast(absoluteChannelName, message, false);
    }

    private void broadcast(String broadcasterID, String message, boolean createIfNull) {
        Broadcaster broadcaster;
        BroadcasterFactory broadcasterFactory = AtmosphereServlet.getBroadcasterFactory();
        if (broadcasterFactory != null && (broadcaster = broadcasterFactory.lookup((Object)broadcasterID, createIfNull)) != null) {
            broadcaster.broadcast((Object)message);
        }
    }
}

