/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.cache.ehcache;

import java.util.Properties;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingCacheEventListener
implements CacheEventListener {
    private static Logger logger = LoggerFactory.getLogger(LoggingCacheEventListener.class);
    private final Properties properties;

    public LoggingCacheEventListener(Properties properties) {
        this.properties = properties;
    }

    public void notifyElementRemoved(Ehcache ehcache, Element element) throws CacheException {
        if (this.testLogging("removed")) {
            logger.debug(ehcache.getName() + ": Element " + String.valueOf(element.getObjectKey()) + " removed.");
        }
    }

    private boolean testLogging(String type) {
        return logger.isDebugEnabled() && (this.properties == null || this.properties.size() == 0 || this.properties.containsKey(type));
    }

    public void notifyElementPut(Ehcache ehcache, Element element) throws CacheException {
        if (this.testLogging("put")) {
            logger.debug(ehcache.getName() + ": Element " + String.valueOf(element.getObjectKey()) + " put.");
        }
    }

    public void notifyElementUpdated(Ehcache ehcache, Element element) throws CacheException {
        if (this.testLogging("updated")) {
            logger.debug(ehcache.getName() + ": Element " + String.valueOf(element.getObjectKey()) + " updated.");
        }
    }

    public void notifyElementExpired(Ehcache ehcache, Element element) {
        if (this.testLogging("expired")) {
            logger.info(ehcache.getName() + ": Element " + String.valueOf(element.getObjectKey()) + " expired.");
        }
    }

    public void notifyElementEvicted(Ehcache ehcache, Element element) {
        if (this.testLogging("evicted")) {
            logger.debug(ehcache.getName() + ": Element " + String.valueOf(element.getObjectKey()) + " evicted.");
        }
    }

    public void notifyRemoveAll(Ehcache ehcache) {
        if (this.testLogging("removeAll")) {
            logger.debug(ehcache.getName() + ": All elements removed!");
        }
    }

    public void dispose() {
        if (logger.isDebugEnabled()) {
            logger.debug(" Event listener disposed of.");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        if (logger.isDebugEnabled()) {
            logger.debug("Event listener cloned.");
        }
        throw new CloneNotSupportedException();
    }
}

