/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.channels;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jahia.services.channels.Channel;
import org.jahia.services.channels.ChannelService;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.initializers.ChoiceListInitializer;
import org.jahia.services.content.nodetypes.initializers.ChoiceListValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelChoiceListInitializer
implements ChoiceListInitializer {
    private static final Logger logger = LoggerFactory.getLogger(ChannelChoiceListInitializer.class);
    private ChannelService channelService;

    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    @Override
    public List<ChoiceListValue> getChoiceListValues(ExtendedPropertyDefinition epd, String param, List<ChoiceListValue> values, Locale locale, Map<String, Object> context) {
        ArrayList<ChoiceListValue> choiceListValues = new ArrayList<ChoiceListValue>();
        List<String> channels = this.channelService.getAllChannels();
        for (String channelName : channels) {
            Channel channel = this.channelService.getChannel(channelName);
            choiceListValues.add(new ChoiceListValue(channel.getCapability("display-name"), channel.getIdentifier()));
        }
        return choiceListValues;
    }
}

