/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRNodeLockType;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JCRLockUtils {
    private static final Logger logger = LoggerFactory.getLogger(JCRLockUtils.class);

    JCRLockUtils() {
    }

    static void checkLock(JCRNodeWrapper node, boolean unlockSharedLock, boolean forAdd) throws RepositoryException {
        JCRSessionWrapper session = node.getSession();
        if (!session.isSystem() && node.isLocked()) {
            Node realNode = node.getRealNode();
            List<String> owners = JCRLockUtils.getLockOwners(realNode);
            if (realNode.hasProperty("j:locktoken") && (unlockSharedLock || owners.size() == 1 && owners.contains(session.getUserID()) || forAdd && JCRLockUtils.getLockInfos(realNode).stream().allMatch(s -> s.endsWith(JCRNodeLockType.ALLOWS_ADD_SUFFIX)))) {
                realNode.getSession().addLockToken(realNode.getProperty("j:locktoken").getString());
            } else {
                boolean lockOwningSession = false;
                if (owners.size() == 0) {
                    Lock lock = realNode.getLock();
                    boolean bl = lockOwningSession = lock != null && lock.isLockOwningSession();
                }
                if (!lockOwningSession) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Node " + realNode.getPath() + " locked. Locks info:" + String.valueOf(JCRLockUtils.getLockInfos(realNode)));
                    }
                    throw new LockException("Node locked.");
                }
            }
            if (session.getLocale() != null && !forAdd) {
                try {
                    Node i18n = node.getI18N(session.getLocale());
                    if (i18n.isLocked()) {
                        owners = JCRLockUtils.getLockOwners(i18n);
                        if (owners.size() == 1 && owners.contains(session.getUserID())) {
                            i18n.getSession().addLockToken(i18n.getProperty("j:locktoken").getString());
                        } else {
                            boolean lockOwningSession = false;
                            if (owners.size() == 0) {
                                Lock lock = i18n.getLock();
                                boolean bl = lockOwningSession = lock != null && lock.isLockOwningSession();
                            }
                            if (!lockOwningSession) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug("Node i18n " + i18n.getPath() + " locked. Locks info:" + String.valueOf(JCRLockUtils.getLockInfos(i18n)));
                                }
                                throw new LockException("Node locked.");
                            }
                        }
                    }
                }
                catch (ItemNotFoundException e) {
                    logger.debug("checkLock : no i18n node for node {}", (Object)node.getCanonicalPath());
                }
            }
        }
    }

    static List<String> getLockOwners(Node node) throws RepositoryException {
        List<String> types = JCRLockUtils.getLockInfos(node);
        ArrayList<String> r = new ArrayList<String>();
        for (String type : types) {
            String owner = StringUtils.substringBefore((String)type, (String)":");
            if (r.contains(owner)) continue;
            r.add(owner);
        }
        return r;
    }

    static List<String> getLockInfos(Node node) throws RepositoryException {
        ArrayList<String> r = new ArrayList<String>();
        Value[] values = null;
        try {
            values = node.getProperty("j:lockTypes").getValues();
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        if (values != null) {
            for (Value value : values) {
                if (r.contains(value.getString())) continue;
                r.add(value.getString());
            }
        }
        return r;
    }
}

