/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRNodeWrapperImpl;
import org.jahia.services.content.decorator.JCRNodeDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRNodeWrapperCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(JCRNodeWrapperCache.class);
    private final Map<String, JCRNodeWrapper> wrappersPerPath;
    private final Map<String, JCRNodeWrapper> changedWrappersPerPath = new HashMap<String, JCRNodeWrapper>();
    private final Map<String, String> uuidPath;
    private boolean disableCache = false;
    private int maxWrappedNodes;

    protected JCRNodeWrapperCache(int maxWrappedNodes) {
        this.maxWrappedNodes = maxWrappedNodes;
        this.wrappersPerPath = this.maxWrappedNodes > 0 ? new InternalLRUMap() : new HashMap<String, JCRNodeWrapper>();
        this.uuidPath = new HashMap<String, String>();
    }

    protected int getCacheSize(boolean includeChangedNodes) {
        return includeChangedNodes ? this.wrappersPerPath.size() + this.changedWrappersPerPath.size() : this.wrappersPerPath.size();
    }

    protected void putNode(String path, JCRNodeWrapper node) {
        this.putNode(path, node, false);
    }

    protected void putNode(String path, JCRNodeWrapper node, boolean changed) {
        if (changed) {
            this.changedWrappersPerPath.put(path, node);
            try {
                this.uuidPath.put(node.getIdentifier(), path);
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
            this.wrappersPerPath.remove(path);
        } else if (!this.disableCache && !this.changedWrappersPerPath.containsKey(path)) {
            this.wrappersPerPath.put(path, node);
            try {
                this.uuidPath.put(node.getIdentifier(), path);
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
    }

    protected void removeNode(String path) throws RepositoryException {
        this.removePathInCache(path, this.wrappersPerPath);
        this.removePathInCache(path, this.changedWrappersPerPath);
    }

    protected void moveNode(String source, String dest) throws RepositoryException {
        this.updatePathInCache(source, dest, this.wrappersPerPath);
        this.updatePathInCache(source, dest, this.changedWrappersPerPath);
    }

    protected JCRNodeWrapper getByPath(String path) {
        return this.changedWrappersPerPath.getOrDefault(path, this.wrappersPerPath.get(path));
    }

    protected JCRNodeWrapper getByUUID(String uuid) {
        String cachedPath = this.uuidPath.get(uuid);
        if (cachedPath != null) {
            JCRNodeWrapper cached = this.getByPath(cachedPath);
            if (cached != null) {
                return cached;
            }
            this.uuidPath.remove(uuid);
        }
        return null;
    }

    protected Collection<JCRNodeWrapper> getAllChangedNodes() {
        return new ArrayList<JCRNodeWrapper>(this.changedWrappersPerPath.values());
    }

    protected void flush(boolean keepChanges) {
        if (!keepChanges) {
            this.clearAllCaches();
        } else {
            this.clearSingleCache(this.wrappersPerPath);
        }
    }

    protected void resetChanges() {
        this.clearSingleCache(this.changedWrappersPerPath);
    }

    protected void disable() {
        if (!this.disableCache) {
            this.disableCache = true;
            this.flush(true);
        }
    }

    protected void enable() {
        if (this.disableCache) {
            this.disableCache = false;
        }
    }

    protected boolean isEnabled() {
        return !this.disableCache;
    }

    private void updatePathInCache(String source, String dest, Map<String, JCRNodeWrapper> cacheByPath) throws RepositoryException {
        String sourcePrefix = source + "/";
        HashSet<String> paths = new HashSet<String>(cacheByPath.keySet());
        for (String s : paths) {
            if (!s.equals(source) && !s.startsWith(sourcePrefix)) continue;
            JCRNodeWrapper n = cacheByPath.remove(s);
            if (n instanceof JCRNodeDecorator) {
                n = ((JCRNodeDecorator)n).getDecoratedNode();
            }
            Object newPath = dest;
            if (source.length() < n.getPath().length()) {
                newPath = (String)newPath + n.getPath().substring(source.length());
            }
            String localPath = newPath;
            if (n.getProvider().getMountPoint().length() > 1) {
                localPath = ((String)newPath).substring(n.getProvider().getMountPoint().length());
            }
            ((JCRNodeWrapperImpl)n).localPath = localPath;
            ((JCRNodeWrapperImpl)n).localPathInProvider = localPath;
            cacheByPath.put((String)newPath, n);
            this.uuidPath.put(n.getIdentifier(), (String)newPath);
        }
    }

    private void removePathInCache(String path, Map<String, JCRNodeWrapper> cacheByPath) throws RepositoryException {
        String pathPrefix = path + "/";
        HashSet<String> paths = new HashSet<String>(cacheByPath.keySet());
        for (String s : paths) {
            if (!s.equals(path) && !s.startsWith(pathPrefix)) continue;
            JCRNodeWrapper n = cacheByPath.remove(s);
            this.uuidPath.remove(n.getIdentifier());
        }
    }

    private void clearSingleCache(Map<String, JCRNodeWrapper> cacheByPath) {
        for (JCRNodeWrapper value : cacheByPath.values()) {
            try {
                this.uuidPath.remove(value.getIdentifier());
            }
            catch (RepositoryException repositoryException) {}
        }
        cacheByPath.clear();
    }

    private void clearAllCaches() {
        this.wrappersPerPath.clear();
        this.changedWrappersPerPath.clear();
        this.uuidPath.clear();
    }

    class InternalLRUMap
    extends LinkedHashMap<String, JCRNodeWrapper> {
        InternalLRUMap() {
            super(16, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, JCRNodeWrapper> eldest) {
            boolean remove;
            boolean bl = remove = this.size() > JCRNodeWrapperCache.this.maxWrappedNodes;
            if (remove) {
                try {
                    JCRNodeWrapperCache.this.uuidPath.remove(eldest.getValue().getIdentifier());
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
            }
            return remove;
        }
    }
}

