/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import javax.jcr.AccessDeniedException;
import javax.jcr.Binary;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.value.ValueHelper;
import org.jahia.services.content.JCRItemWrapper;
import org.jahia.services.content.JCRItemWrapperImpl;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRNodeWrapperImpl;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.content.JCRStoreService;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.JCRValueWrapperImpl;
import org.jahia.services.content.decorator.JCRNodeDecorator;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRPropertyWrapperImpl
extends JCRItemWrapperImpl
implements JCRPropertyWrapper {
    private static final Logger logger = LoggerFactory.getLogger(JCRPropertyWrapperImpl.class);
    private JCRNodeWrapper node;
    private Property property;
    private String name;
    private ExtendedPropertyDefinition def;

    public JCRPropertyWrapperImpl(JCRNodeWrapper objectNode, Property property, JCRSessionWrapper session, JCRStoreProvider provider, ExtendedPropertyDefinition def) throws RepositoryException {
        super(session, provider);
        this.node = objectNode;
        this.property = property;
        this.item = property;
        if (property != null) {
            this.localPathInProvider = this.localPath = property.getPath();
            this.name = property.getName();
            this.setPropertyDefinition(def);
        }
    }

    public JCRPropertyWrapperImpl(JCRNodeWrapper objectNode, Property property, JCRSessionWrapper session, JCRStoreProvider provider, ExtendedPropertyDefinition def, String name) throws RepositoryException {
        super(session, provider);
        this.node = objectNode;
        this.property = property;
        this.item = property;
        this.name = name;
        this.localPath = this.node.getPath() + "/" + name;
        this.localPathInProvider = this.localPath;
        this.setPropertyDefinition(def);
    }

    private void setPropertyDefinition(ExtendedPropertyDefinition definition) throws RepositoryException {
        this.def = this.property != null && definition != null && this.isMultiple() && !definition.isMultiple() ? this.node.getApplicablePropertyDefinition(this.name, definition.getRequiredType(), true) : definition;
    }

    public void setValue(Value value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.node.checkLock();
        Value modifiedValue = JCRStoreService.getInstance().getInterceptorChain().beforeSetValue(this.node, this.name, this.def, value);
        this.property.setValue(modifiedValue);
    }

    public void setValue(Value[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.node.checkLock();
        Value[] modifiedValues = JCRStoreService.getInstance().getInterceptorChain().beforeSetValues(this.node, this.name, this.def, values);
        this.property.setValue(modifiedValues);
    }

    public void setValue(String value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (value != null) {
            this.setValue(this.getSession().getValueFactory().createValue(value));
        } else {
            this.remove();
        }
    }

    public void setValue(String[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (values != null) {
            Value[] v = new Value[values.length];
            for (int i = 0; i < values.length; ++i) {
                v[i] = values[i] != null ? this.getSession().getValueFactory().createValue(values[i]) : null;
            }
            this.setValue(v);
        } else {
            this.remove();
        }
    }

    public void setValue(InputStream value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (value != null) {
            this.setValue(this.getSession().getValueFactory().createValue(value));
        } else {
            this.remove();
        }
    }

    public void setValue(long value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.setValue(this.getSession().getValueFactory().createValue(value));
    }

    public void setValue(double value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.setValue(this.getSession().getValueFactory().createValue(value));
    }

    public void setValue(Calendar value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (value != null) {
            this.setValue(this.getSession().getValueFactory().createValue(value));
        } else {
            this.remove();
        }
    }

    public void setValue(boolean value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.setValue(this.getSession().getValueFactory().createValue(value));
    }

    public void setValue(Node value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (value != null) {
            this.setValue(this.getSession().getValueFactory().createValue(value instanceof JCRNodeWrapper ? ((JCRNodeWrapper)value).getRealNode() : value, this.def.getRequiredType() == 10));
        } else {
            this.remove();
        }
    }

    public void setValue(Binary value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (value != null) {
            this.setValue(this.getSession().getValueFactory().createValue(value));
        } else {
            this.remove();
        }
    }

    public void setValue(BigDecimal value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (value != null) {
            this.setValue(this.getSession().getValueFactory().createValue(value));
        } else {
            this.remove();
        }
    }

    @Override
    public void addValue(String value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.addValue(this.getSession().getValueFactory().createValue(value));
    }

    @Override
    public void addValue(InputStream value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.addValue(this.getSession().getValueFactory().createValue(value));
    }

    @Override
    public void addValue(long value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.addValue(this.getSession().getValueFactory().createValue(value));
    }

    @Override
    public void addValue(double value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.addValue(this.getSession().getValueFactory().createValue(value));
    }

    @Override
    public void addValue(Calendar value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.addValue(this.getSession().getValueFactory().createValue(value));
    }

    @Override
    public void addValue(boolean value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.addValue(this.getSession().getValueFactory().createValue(value));
    }

    @Override
    public void addValue(Node value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.addValue(value, true);
    }

    @Override
    public void addValue(Node value, boolean weak) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.addValue(this.getSession().getValueFactory().createValue(value, weak));
    }

    @Override
    public void addValue(Binary value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.addValue(this.getSession().getValueFactory().createValue(value));
    }

    @Override
    public void addValue(BigDecimal value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.addValue(this.getSession().getValueFactory().createValue(value));
    }

    @Override
    public void addValue(Value value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.addValues(new Value[]{value});
    }

    @Override
    public void addValues(Value[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        ArrayList<JCRValueWrapper> newValues = new ArrayList<JCRValueWrapper>(Arrays.asList(this.getValues()));
        boolean updated = false;
        for (Value value : values) {
            if (newValues.contains(value)) continue;
            newValues.add((JCRValueWrapper)value);
            updated = true;
        }
        if (updated) {
            this.setValue(newValues.toArray(new Value[newValues.size()]));
        }
    }

    public String getString() throws ValueFormatException, RepositoryException {
        return this.getValue().getString();
    }

    public InputStream getStream() throws ValueFormatException, RepositoryException {
        return this.getValue().getStream();
    }

    public long getLong() throws ValueFormatException, RepositoryException {
        return this.getValue().getLong();
    }

    public double getDouble() throws ValueFormatException, RepositoryException {
        return this.getValue().getDouble();
    }

    public Calendar getDate() throws ValueFormatException, RepositoryException {
        return this.getValue().getDate();
    }

    public boolean getBoolean() throws ValueFormatException, RepositoryException {
        return this.getValue().getBoolean();
    }

    public JCRNodeWrapper getNode() throws ValueFormatException, RepositoryException {
        JCRValueWrapper value = this.getValue();
        int type = value.getType();
        switch (type) {
            case 9: 
            case 10: {
                return this.session.getNodeByUUID(value.getString());
            }
            case 7: 
            case 8: {
                String path = value.getString();
                boolean absolute = StringUtils.startsWith((String)path, (String)"/");
                try {
                    return absolute ? this.session.getNode(path) : this.getParent().getNode(path);
                }
                catch (PathNotFoundException e) {
                    throw new ItemNotFoundException(path);
                }
            }
            case 1: {
                try {
                    Value refValue = ValueHelper.convert((Value)value, (int)9, (ValueFactory)this.session.getValueFactory());
                    return this.session.getNodeByUUID(refValue.getString());
                }
                catch (RepositoryException e) {
                    Value pathValue = ValueHelper.convert((Value)value, (int)8, (ValueFactory)this.session.getValueFactory());
                    boolean absolute = StringUtils.startsWith((String)pathValue.getString(), (String)"/");
                    try {
                        return absolute ? this.session.getNode(pathValue.getString()) : this.getParent().getNode(pathValue.getString());
                    }
                    catch (PathNotFoundException e1) {
                        throw new ItemNotFoundException(pathValue.getString());
                    }
                }
            }
        }
        throw new ValueFormatException("Property value cannot be converted to a PATH, REFERENCE or WEAKREFERENCE");
    }

    @Override
    public JCRNodeWrapper getContextualizedNode() throws ValueFormatException, RepositoryException {
        JCRNodeWrapper ref = this.getNode();
        try {
            return this.session.getNode(this.getParent().getPath() + "@/" + ref.getRealNode().getName());
        }
        catch (PathNotFoundException e) {
            throw new ItemNotFoundException(e.getMessage(), (Throwable)e);
        }
    }

    public JCRNodeWrapper getReferencedNode() throws ValueFormatException, RepositoryException {
        return this.getNode();
    }

    public Binary getBinary() throws ValueFormatException, RepositoryException {
        return this.getValue().getBinary();
    }

    public BigDecimal getDecimal() throws ValueFormatException, RepositoryException {
        return this.getValue().getDecimal();
    }

    public Property getProperty() throws ItemNotFoundException, ValueFormatException, RepositoryException {
        JCRValueWrapper value = this.getValue();
        Value pathValue = ValueHelper.convert((Value)value, (int)8, (ValueFactory)this.session.getValueFactory());
        String path = pathValue.getString();
        boolean absolute = StringUtils.startsWith((String)path, (String)"/");
        try {
            return absolute ? this.session.getProperty(path) : this.getParent().getProperty(path);
        }
        catch (PathNotFoundException e) {
            throw new ItemNotFoundException(path);
        }
    }

    public long getLength() throws ValueFormatException, RepositoryException {
        return this.property.getLength();
    }

    public long[] getLengths() throws ValueFormatException, RepositoryException {
        return this.property.getLengths();
    }

    public ExtendedPropertyDefinition getDefinition() throws RepositoryException {
        return this.def;
    }

    public int getType() throws RepositoryException {
        return this.property.getType();
    }

    @Override
    public String getName() throws RepositoryException {
        return this.name;
    }

    @Override
    public JCRItemWrapper getAncestor(int i) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        return this.provider.getItemWrapper(this.property.getAncestor(i), this.session);
    }

    @Override
    public JCRNodeWrapper getParent() throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        return this.node;
    }

    @Override
    public int getDepth() throws RepositoryException {
        return this.property.getDepth();
    }

    @Override
    public boolean isNode() {
        return this.property.isNode();
    }

    @Override
    public boolean isNew() {
        return this.property.isNew();
    }

    @Override
    public boolean isModified() {
        return this.property.isModified();
    }

    @Override
    public boolean isSame(Item item) throws RepositoryException {
        return this.property.isSame(item) || item instanceof JCRItemWrapperImpl && item.isSame((Item)this.property);
    }

    @Override
    public void accept(ItemVisitor itemVisitor) throws RepositoryException {
        this.property.accept(itemVisitor);
    }

    @Override
    public void save() throws AccessDeniedException, ItemExistsException, ConstraintViolationException, InvalidItemStateException, ReferentialIntegrityException, VersionException, LockException, NoSuchNodeTypeException, RepositoryException {
        this.property.save();
    }

    @Override
    public void refresh(boolean b) throws InvalidItemStateException, RepositoryException {
        this.property.refresh(b);
    }

    @Override
    public void remove() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.node.checkLock();
        JCRStoreService.getInstance().getInterceptorChain().beforeRemove(this.node, this.name, this.def);
        this.property.remove();
        JCRNodeWrapper n = this.node;
        if (n instanceof JCRNodeDecorator) {
            n = ((JCRNodeDecorator)n).getDecoratedNode();
        }
        if (n instanceof JCRNodeWrapperImpl) {
            ((JCRNodeWrapperImpl)n).flushLocalCaches();
        }
    }

    public boolean isMultiple() throws RepositoryException {
        return this.property.isMultiple();
    }

    @Override
    public JCRValueWrapper getValue() throws ValueFormatException, RepositoryException {
        Value value = JCRStoreService.getInstance().getInterceptorChain().afterGetValue(this, this.property.getValue());
        return this.wrap(value);
    }

    @Override
    public JCRValueWrapper getRealValue() throws ValueFormatException, RepositoryException {
        return this.wrap(this.property.getValue());
    }

    private JCRValueWrapper wrap(Value value) throws RepositoryException {
        return new JCRValueWrapperImpl(value, this.getDefinition(), this.getSession());
    }

    @Override
    public JCRValueWrapper[] getValues() throws ValueFormatException, RepositoryException {
        Value[] values = JCRStoreService.getInstance().getInterceptorChain().afterGetValues(this, this.property.getValues());
        return this.wrap(values);
    }

    @Override
    public JCRValueWrapper[] getRealValues() throws ValueFormatException, RepositoryException {
        return this.wrap(this.property.getValues());
    }

    private JCRValueWrapper[] wrap(Value[] values) throws RepositoryException {
        JCRValueWrapper[] wrappedValues = new JCRValueWrapper[values.length];
        for (int i = 0; i < values.length; ++i) {
            Value value = values[i];
            wrappedValues[i] = new JCRValueWrapperImpl(value, this.getDefinition(), this.getSession());
        }
        return wrappedValues;
    }

    @Override
    public String getLocale() throws RepositoryException {
        if (this.def.isInternationalized()) {
            Node parent = this.property.getParent();
            String parentName = parent.getName();
            if ("jcr:frozenNode".equals(parentName)) {
                try {
                    return parent.getProperty("jcr:language").getString();
                }
                catch (PathNotFoundException e) {
                    return null;
                }
            }
            return StringUtils.substringAfter((String)parentName, (String)"j:translation_");
        }
        return null;
    }

    @Override
    public boolean removeValue(Value value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.removeValues(new Value[]{value});
    }

    @Override
    public boolean removeValues(Value[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        JCRValueWrapper[] valueArray = this.getValues();
        if (valueArray == null || valueArray.length == 0) {
            return false;
        }
        ArrayList<JCRValueWrapper> newValues = new ArrayList<JCRValueWrapper>(Arrays.asList(valueArray));
        boolean updated = false;
        for (Value value : values) {
            if (!newValues.contains(value)) continue;
            newValues.remove(value);
            updated = true;
        }
        if (updated) {
            this.setValue(newValues.toArray(new Value[newValues.size()]));
        }
        return updated;
    }

    @Override
    public Property getRealProperty() {
        return this.property;
    }
}

