/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionManager;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.security.JahiaAccessManager;
import org.jahia.exceptions.JahiaException;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.osgi.BundleUtils;
import org.jahia.osgi.FrameworkService;
import org.jahia.services.JahiaService;
import org.jahia.services.content.ConflictResolver;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRObservationManager;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.JCRVersionService;
import org.jahia.services.content.JCRWorkspaceWrapper;
import org.jahia.services.content.PublicationEvent;
import org.jahia.services.content.PublicationEventListener;
import org.jahia.services.content.PublicationInfo;
import org.jahia.services.content.PublicationInfoNode;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.events.JournalEventReader;
import org.jahia.services.logging.MetricsLoggingService;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.utils.LanguageCodeConverters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.touk.throwing.ThrowingFunction;

public class JCRPublicationService
extends JahiaService {
    private static final Logger logger = LoggerFactory.getLogger(JCRPublicationService.class);
    private int batchSize;
    private JCRSessionFactory sessionFactory;
    private MetricsLoggingService loggingService;
    private Set<String> propertiesToSkipForReferences = Collections.emptySet();
    private Set<String> referencedNodeTypesToSkip = Collections.emptySet();
    private boolean skipAllReferenceProperties;
    private Set<String> versionedTypes;
    private Set<String> excludedVersionedTypes;
    private Set<PublicationEventListener> listeners = Collections.newSetFromMap(new ConcurrentHashMap());

    private JCRPublicationService() {
    }

    public JCRSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(JCRSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setLoggingService(MetricsLoggingService loggingService) {
        this.loggingService = loggingService;
    }

    public static JCRPublicationService getInstance() {
        return Holder.INSTANCE;
    }

    public boolean hasIndependantPublication(JCRNodeWrapper node) throws RepositoryException {
        return node.isNodeType("jmix:publication");
    }

    public void lockForPublication(final List<String> publicationInfo, String workspace, final String key) throws RepositoryException {
        JCRTemplate.getInstance().doExecuteWithLongSystemSessionAsUser(this.getSessionFactory().getCurrentUserSession(workspace).getUser(), workspace, null, new JCRCallback<Object>(){

            @Override
            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                for (String id : publicationInfo) {
                    JCRPublicationService.this.doLock(id, session, key);
                }
                return null;
            }
        });
    }

    private void doLock(String id, JCRSessionWrapper session, String key) throws RepositoryException {
        try {
            JCRNodeWrapper node = session.getNodeByUUID(id);
            if (node.isLockable()) {
                node.lockAndStoreToken("validation", " " + key + " ");
            }
        }
        catch (ItemNotFoundException e) {
            logger.debug("Item does not exist anymore : " + id);
        }
    }

    public void unlockForPublication(final List<String> publicationInfo, String workspace, final String key) throws RepositoryException {
        JCRTemplate.getInstance().doExecuteWithLongSystemSessionAsUser(this.getSessionFactory().getCurrentUserSession(workspace).getUser(), workspace, null, new JCRCallback<Object>(){

            @Override
            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                for (String id : publicationInfo) {
                    JCRPublicationService.this.doUnlock(id, session, key);
                }
                return null;
            }
        });
    }

    private void doUnlock(String id, JCRSessionWrapper session, String key) throws RepositoryException {
        try {
            JCRNodeWrapper node = session.getNodeByUUID(id);
            if (node.isLocked()) {
                try {
                    node.unlock("validation", " " + key + " ");
                }
                catch (LockException lockException) {}
            }
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
    }

    public void publishByMainId(String uuid) throws RepositoryException {
        this.publishByMainId(uuid, "default", "live", null, true, null);
    }

    public void publishByMainId(String uuid, String sourceWorkspace, String destinationWorkspace, Set<String> languages, boolean allSubTree, List<String> comments) throws RepositoryException {
        List<PublicationInfo> tree = this.getPublicationInfo(uuid, languages, true, true, allSubTree, sourceWorkspace, destinationWorkspace);
        this.publishByInfoList(tree, sourceWorkspace, destinationWorkspace, comments);
    }

    public void publishByInfoList(List<PublicationInfo> publicationInfos, String sourceWorkspace, String destinationWorkspace, List<String> comments) throws RepositoryException {
        this.publishByInfoList(publicationInfos, sourceWorkspace, destinationWorkspace, true, comments);
    }

    public void publishByInfoList(List<PublicationInfo> publicationInfos, String sourceWorkspace, String destinationWorkspace, boolean checkPermissions, List<String> comments) throws RepositoryException {
        LinkedHashSet<String> allIds = new LinkedHashSet<String>();
        for (PublicationInfo publicationInfo : publicationInfos) {
            allIds.addAll(publicationInfo.getAllUuids(false, false, false));
            for (PublicationInfo subtree : publicationInfo.getAllReferences()) {
                allIds.addAll(subtree.getAllUuids(false, false, false));
            }
        }
        this.publish(new ArrayList<String>(allIds), sourceWorkspace, destinationWorkspace, checkPermissions, comments);
    }

    public void publish(List<String> uuids, String sourceWorkspace, String destinationWorkspace, List<String> comments) throws RepositoryException {
        this.publish(uuids, sourceWorkspace, destinationWorkspace, true, comments);
    }

    public void publish(List<String> uuids, String sourceWorkspace, String destinationWorkspace, boolean checkPermissions, List<String> comments) throws RepositoryException {
        this.publish(uuids, sourceWorkspace, destinationWorkspace, checkPermissions, true, comments);
    }

    public void publish(List<String> uuids, String sourceWorkspace, final String destinationWorkspace, boolean checkPermissions, final boolean updateMetadata, final List<String> comments) throws RepositoryException {
        if (uuids.isEmpty()) {
            return;
        }
        final JahiaUser user = JCRSessionFactory.getInstance().getCurrentUser();
        final LinkedHashSet<String> checkedUuids = new LinkedHashSet<String>();
        if (checkPermissions) {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
            for (String uuid : uuids) {
                try {
                    if (!session.getNodeByIdentifier(uuid).hasPermission("publish")) continue;
                    checkedUuids.add(uuid);
                }
                catch (ItemNotFoundException e) {
                    logger.debug("Impossible to publish missing node", (Throwable)e);
                }
            }
        } else {
            checkedUuids.addAll(uuids);
        }
        if (!checkedUuids.isEmpty()) {
            JCRTemplate.getInstance().doExecuteWithLongSystemSessionAsUser(user, sourceWorkspace, null, new JCRCallback<Object>(){

                @Override
                public Object doInJCR(final JCRSessionWrapper sourceSession) throws RepositoryException {
                    JCRTemplate.getInstance().doExecuteWithLongSystemSessionAsUser(user, destinationWorkspace, null, new JCRCallback<Object>(){

                        @Override
                        public Object doInJCR(JCRSessionWrapper destinationSession) throws RepositoryException {
                            sourceSession.setSkipValidation(true);
                            destinationSession.setSkipValidation(true);
                            JCRPublicationService.this.publish(checkedUuids, sourceSession, destinationSession, updateMetadata, (List<String>)comments);
                            return null;
                        }
                    });
                    return null;
                }
            });
            if (this.sessionFactory.getCurrentUser() != null) {
                this.sessionFactory.getCurrentUserSession(sourceWorkspace).refresh(false);
                this.sessionFactory.getCurrentUserSession(destinationWorkspace).refresh(false);
            }
        }
    }

    private void publish(Set<String> uuidsToPublish, JCRSessionWrapper sourceSession, JCRSessionWrapper destinationSession, boolean updateMetadata, List<String> comments) throws RepositoryException {
        int totalCount = uuidsToPublish.size();
        if (this.batchSize < 0 || totalCount <= this.batchSize) {
            long startTime = System.currentTimeMillis();
            this.doPublish(uuidsToPublish, sourceSession, destinationSession, updateMetadata, comments);
            logger.info("Published {} nodes in {} ms", (Object)totalCount, (Object)(System.currentTimeMillis() - startTime));
        } else {
            logger.info("Publishing {} nodes in batches of {}", (Object)totalCount, (Object)this.batchSize);
            long startTime = System.currentTimeMillis();
            LinkedHashSet<String> batch = new LinkedHashSet<String>(this.batchSize);
            int batchIndex = 1;
            int batchTotalCount = (int)Math.ceil((double)totalCount / (double)this.batchSize);
            while (uuidsToPublish.size() > this.batchSize) {
                int batchCount = 0;
                Iterator<String> iterator = uuidsToPublish.iterator();
                while (iterator.hasNext()) {
                    batch.add(iterator.next());
                    iterator.remove();
                    if (++batchCount < this.batchSize) continue;
                }
                logger.info("Processing batch {}/{}", (Object)batchIndex++, (Object)batchTotalCount);
                this.doPublish(batch, sourceSession, destinationSession, updateMetadata, comments);
                batch.clear();
            }
            if (!uuidsToPublish.isEmpty()) {
                this.doPublish(uuidsToPublish, sourceSession, destinationSession, updateMetadata, comments);
            }
            logger.info("Batch-published {} nodes in {} ms", (Object)totalCount, (Object)(System.currentTimeMillis() - startTime));
        }
    }

    private boolean isNodeWorkinInProgress(JCRNodeWrapper node) throws RepositoryException {
        JCRNodeWrapper actualNode;
        boolean isTranslation = "jnt:translation".equals(node.getPrimaryNodeTypeName());
        JCRNodeWrapper jCRNodeWrapper = actualNode = isTranslation ? node.getParent() : node;
        if (actualNode.hasProperty("j:workInProgressStatus")) {
            String wipStatus = actualNode.getProperty("j:workInProgressStatus").getString();
            if (wipStatus.equals("ALL_CONTENT")) {
                return true;
            }
            if (wipStatus.equals("LANGUAGES") && isTranslation && node.getLanguage() != null) {
                return Arrays.stream(actualNode.getProperty("j:workInProgressLanguages").getValues()).map(ThrowingFunction.unchecked(Value::getString)).anyMatch(value -> node.getLanguage().equals(value));
            }
        }
        return false;
    }

    private void doPublish(Set<String> uuidsToPublish, JCRSessionWrapper sourceSession, JCRSessionWrapper destinationSession, boolean updateMetadata, List<String> comments) throws RepositoryException {
        Integer operationType;
        String userID;
        GregorianCalendar calendar = new GregorianCalendar();
        String destinationWorkspace = destinationSession.getWorkspace().getName();
        LinkedHashSet<JCRNodeWrapper> toPublish = new LinkedHashSet<JCRNodeWrapper>();
        for (String uuid : uuidsToPublish) {
            try {
                JCRNodeWrapper node = sourceSession.getNodeByUUID(uuid);
                if (node.isNodeType("jmix:nolive") || toPublish.contains(node) || !JCRPublicationService.supportsPublication(sourceSession, node) || this.isNodeWorkinInProgress(node) && !node.isMarkedForDeletion()) continue;
                toPublish.add(node);
            }
            catch (ItemNotFoundException e) {
                logger.debug("Impossible to publish missing node", (Throwable)e);
            }
        }
        Collection<PublicationEvent.ContentPublicationInfo> nodePublicationInfos = null;
        if (!this.listeners.isEmpty()) {
            nodePublicationInfos = JCRPublicationService.collectNodePublicationInfos(toPublish);
        }
        if ((userID = destinationSession.getUserID()) != null && userID.startsWith(" system ")) {
            userID = userID.substring(" system ".length());
        }
        VersionManager destinationVersionManager = destinationSession.getWorkspace().getVersionManager();
        LinkedHashMap<String, Map<String, Value>> previousPropertyByNodeUuidByName = new LinkedHashMap<String, Map<String, Value>>();
        if (updateMetadata && destinationSession.getWorkspace().getName().equals("live")) {
            for (JCRNodeWrapper node : toPublish) {
                logger.debug("Publishing node {}", (Object)node.getPath());
                boolean hasLastPublishedMixin = node.isNodeType("jmix:lastPublished");
                if (!hasLastPublishedMixin) continue;
                LinkedHashMap<String, JCRValueWrapper> previousPropertyByName = new LinkedHashMap<String, JCRValueWrapper>();
                previousPropertyByName.put("j:published", node.hasProperty("j:published") ? node.getProperty("j:published").getValue() : null);
                previousPropertyByName.put("j:lastPublished", node.hasProperty("j:lastPublished") ? node.getProperty("j:lastPublished").getValue() : null);
                previousPropertyByName.put("j:lastPublishedBy", node.hasProperty("j:lastPublishedBy") ? node.getProperty("j:lastPublishedBy").getValue() : null);
                previousPropertyByNodeUuidByName.put(node.getIdentifier(), previousPropertyByName);
                node.setProperty("j:published", Boolean.TRUE);
                node.setProperty("j:lastPublished", calendar);
                node.setProperty("j:lastPublishedBy", userID);
            }
            if (sourceSession.hasPendingChanges()) {
                sourceSession.save();
            }
            if (destinationSession.hasPendingChanges()) {
                destinationSession.save();
            }
        }
        HashSet<JCRNodeWrapper> toCheckpoint = new HashSet<JCRNodeWrapper>();
        JCRObservationManager.pushEventListenersAvailableDuringPublishOnly();
        try {
            ArrayList<String> toDelete = new ArrayList<String>();
            ArrayList<Object> toDeleteOnSource = new ArrayList<Object>();
            Iterator nodeIterator = toPublish.iterator();
            block21: while (nodeIterator.hasNext()) {
                Object nodeWrapper = (JCRNodeWrapper)nodeIterator.next();
                if (nodeWrapper.hasProperty("j:deletedChildren")) {
                    JCRValueWrapper[] jCRValueWrapperArray;
                    JCRPropertyWrapper jCRPropertyWrapper = nodeWrapper.getProperty("j:deletedChildren");
                    for (JCRValueWrapper value : jCRValueWrapperArray = jCRPropertyWrapper.getValues()) {
                        toDelete.add(value.getString());
                    }
                    jCRPropertyWrapper.remove();
                    nodeWrapper.removeMixin("jmix:deletedChildren");
                }
                if (nodeWrapper.isNodeType("jmix:markedForDeletionRoot")) {
                    nodeWrapper.unmarkForDeletion();
                    toDeleteOnSource.add(nodeWrapper);
                    toDelete.add(nodeWrapper.getIdentifier());
                    nodeIterator.remove();
                    continue;
                }
                for (JCRNodeWrapper jCRNodeWrapper : toDeleteOnSource) {
                    if (!nodeWrapper.getPath().startsWith(jCRNodeWrapper.getPath())) continue;
                    nodeIterator.remove();
                    continue block21;
                }
            }
            for (Object nodeWrapper : toDeleteOnSource) {
                try {
                    this.addRemovedLabel((JCRNodeWrapper)nodeWrapper, nodeWrapper.getSession().getWorkspace().getName() + "_removed_at_" + JCRVersionService.DATE_FORMAT.print(calendar.getTime().getTime()));
                    nodeWrapper.remove();
                }
                catch (InvalidItemStateException invalidItemStateException) {
                    logger.warn("Already deleted : " + nodeWrapper.getPath());
                }
            }
            JCRNodeWrapper trash = toDelete.isEmpty() ? null : destinationSession.getNode("/").addNode("trash-" + UUID.randomUUID().toString(), "nt:unstructured");
            for (String string : toDelete) {
                try {
                    JCRNodeWrapper jCRNodeWrapper = destinationSession.getNodeByIdentifier(string);
                    this.addRemovedLabel(jCRNodeWrapper, jCRNodeWrapper.getSession().getWorkspace().getName() + "_removed_at_" + JCRVersionService.DATE_FORMAT.print(calendar.getTime().getTime()));
                    destinationSession.move(jCRNodeWrapper.getPath(), trash.getPath() + "/" + jCRNodeWrapper.getIdentifier());
                }
                catch (InvalidItemStateException | ItemNotFoundException throwable) {
                    logger.warn("Already deleted : " + string);
                }
            }
            sourceSession.save();
            destinationSession.save();
            HashSet<String> allCloned = new HashSet<String>();
            for (JCRNodeWrapper jCRNodeWrapper : toPublish) {
                try {
                    try {
                        jCRNodeWrapper.getCorrespondingNodePath(destinationWorkspace);
                    }
                    catch (ItemNotFoundException e) {
                        CloneResult cloneResult = this.ensureNodeInDestinationWorkspace(jCRNodeWrapper, destinationSession, toCheckpoint);
                        allCloned.addAll(cloneResult.includedUuids);
                    }
                }
                catch (RepositoryException e) {
                    logger.error("Error when fetching node from or cloning node in the destination workspace", (Throwable)e);
                    JCRPublicationService.restorePublicationStatus(sourceSession, jCRNodeWrapper.getIdentifier(), previousPropertyByNodeUuidByName);
                }
            }
            uuidsToPublish.removeAll(allCloned);
            for (String string : allCloned) {
                toPublish.remove(sourceSession.getNodeByIdentifier(string));
            }
            for (JCRNodeWrapper jCRNodeWrapper : toPublish) {
                try {
                    this.mergeToDestinationWorkspace(jCRNodeWrapper, sourceSession, destinationSession, calendar, toCheckpoint);
                }
                catch (RepositoryException e) {
                    logger.error("Error when merging differences", (Throwable)e);
                    JCRPublicationService.restorePublicationStatus(sourceSession, jCRNodeWrapper.getIdentifier(), previousPropertyByNodeUuidByName);
                }
            }
            if (trash != null) {
                try {
                    trash.remove();
                    destinationSession.save();
                }
                catch (InvalidItemStateException | ItemNotFoundException throwable) {
                    logger.warn("Already deleted");
                }
            }
            for (JCRNodeWrapper jCRNodeWrapper : toCheckpoint) {
                if (!JCRContentUtils.needVersion(jCRNodeWrapper, this.versionedTypes, this.excludedVersionedTypes)) continue;
                this.checkpoint(destinationSession, jCRNodeWrapper, destinationVersionManager);
            }
        }
        catch (RepositoryException e) {
            for (Map.Entry nodeEntry : previousPropertyByNodeUuidByName.entrySet()) {
                String nodeUuid = (String)nodeEntry.getKey();
                Map map = (Map)nodeEntry.getValue();
                JCRPublicationService.doRestorePublicationStatus(sourceSession, nodeUuid, map);
            }
            if (sourceSession.hasPendingChanges()) {
                sourceSession.save();
            }
            throw e;
        }
        finally {
            JCRObservationManager.popEventListenersAvailableDuringPublishOnly();
        }
        if (this.loggingService.isEnabled() && ((operationType = JCRObservationManager.getCurrentOperationType()) == null || operationType != 13)) {
            for (JCRNodeWrapper publishedNode : toPublish) {
                StringBuilder commentBuf = null;
                if (comments != null && comments.size() > 0) {
                    commentBuf = new StringBuilder();
                    for (String string : comments) {
                        commentBuf.append(string);
                    }
                }
                this.loggingService.logContentEvent(userID, "", "", publishedNode.getIdentifier(), publishedNode.getPath(), publishedNode.getPrimaryNodeTypeName(), "publishedNode", sourceSession.getWorkspace().getName(), destinationSession.getWorkspace().getName(), commentBuf != null ? commentBuf.toString() : "");
            }
        }
        if (nodePublicationInfos != null) {
            this.notifyListeners(sourceSession, destinationSession, nodePublicationInfos);
        }
        sourceSession.refresh(false);
        destinationSession.refresh(false);
    }

    private static void restorePublicationStatus(JCRSessionWrapper sourceSession, String nodeUuid, Map<String, Map<String, Value>> previousPropertyByNodeUuidByName) throws RepositoryException {
        Map<String, Value> previousPropertyByName = previousPropertyByNodeUuidByName.get(nodeUuid);
        if (previousPropertyByName == null) {
            return;
        }
        JCRPublicationService.doRestorePublicationStatus(sourceSession, nodeUuid, previousPropertyByName);
        if (sourceSession.hasPendingChanges()) {
            sourceSession.save();
        }
    }

    private static void doRestorePublicationStatus(JCRSessionWrapper sourceSession, String nodeUuid, Map<String, Value> previousPropertyByName) throws RepositoryException {
        JCRNodeWrapper node;
        try {
            node = sourceSession.getNodeByIdentifier(nodeUuid);
        }
        catch (ItemNotFoundException infe) {
            return;
        }
        for (Map.Entry<String, Value> propertyEntry : previousPropertyByName.entrySet()) {
            String propertyName = propertyEntry.getKey();
            Value propertyValue = propertyEntry.getValue();
            node.setProperty(propertyName, propertyValue);
        }
    }

    private static Collection<PublicationEvent.ContentPublicationInfo> collectNodePublicationInfos(Collection<JCRNodeWrapper> toPublish) throws RepositoryException {
        HashMultimap publicationLanguagesByNodeUuid = HashMultimap.create();
        for (JCRNodeWrapper node : toPublish) {
            if (!node.getPrimaryNodeTypeName().equals("jnt:translation")) continue;
            JCRNodeWrapper contentNode = node.getParent();
            String language = node.getPropertyAsString("jcr:language");
            publicationLanguagesByNodeUuid.put((Object)contentNode.getIdentifier(), (Object)language);
        }
        LinkedHashSet<PublicationEvent.ContentPublicationInfo> nodePublicationInfos = new LinkedHashSet<PublicationEvent.ContentPublicationInfo>();
        for (JCRNodeWrapper node : toPublish) {
            String uuid;
            Set publicationLanguages;
            if (node.getPrimaryNodeTypeName().equals("jnt:translation")) {
                node = node.getParent();
            }
            if ((publicationLanguages = publicationLanguagesByNodeUuid.get((Object)(uuid = node.getIdentifier()))).isEmpty()) {
                publicationLanguages = null;
            }
            nodePublicationInfos.add(new PublicationEvent.ContentPublicationInfo(uuid, node.getPath(), node.getPrimaryNodeTypeName(), publicationLanguages));
        }
        return nodePublicationInfos;
    }

    private void notifyListeners(final JCRSessionWrapper sourceSession, final JCRSessionWrapper destinationSession, final Collection<PublicationEvent.ContentPublicationInfo> nodePublicationInfos) {
        final long timestamp = System.currentTimeMillis();
        for (PublicationEventListener listener : this.listeners) {
            listener.onPublicationCompleted(new PublicationEvent(){

                @Override
                public long getTimestamp() {
                    return timestamp;
                }

                @Override
                public JCRSessionWrapper getSourceSession() {
                    return sourceSession;
                }

                @Override
                public JCRSessionWrapper getDestinationSession() {
                    return destinationSession;
                }

                @Override
                public Collection<PublicationEvent.ContentPublicationInfo> getContentPublicationInfos() {
                    return Collections.unmodifiableCollection(nodePublicationInfos);
                }
            });
        }
    }

    private CloneResult ensureNodeInDestinationWorkspace(final JCRNodeWrapper node, JCRSessionWrapper destinationSession, final Set<JCRNodeWrapper> toCheckpoint) throws AccessDeniedException, NoSuchWorkspaceException, RepositoryException {
        if (!destinationSession.isSystem()) {
            final String nodePath = node.getPath();
            final String destinationWorkspace = destinationSession.getWorkspace().getName();
            return JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(node.getUser().getJahiaUser(), node.getSession().getWorkspace().getName(), null, new JCRCallback<CloneResult>(){

                @Override
                public CloneResult doInJCR(final JCRSessionWrapper sourceSession) throws RepositoryException {
                    return JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(node.getUser().getJahiaUser(), destinationWorkspace, null, new JCRCallback<CloneResult>(){

                        @Override
                        public CloneResult doInJCR(JCRSessionWrapper destinationSession) throws RepositoryException {
                            CloneResult cloneResult = JCRPublicationService.this.cloneParents(sourceSession.getNode(nodePath), sourceSession, destinationSession, toCheckpoint);
                            sourceSession.save();
                            destinationSession.save();
                            return cloneResult;
                        }
                    });
                }
            });
        }
        return this.cloneParents(node, node.getSession(), destinationSession, toCheckpoint);
    }

    private CloneResult cloneParents(JCRNodeWrapper node, JCRSessionWrapper sourceSession, JCRSessionWrapper destinationSession, Set<JCRNodeWrapper> toCheckpoint) throws RepositoryException {
        CloneResult cloneResult = null;
        JCRNodeWrapper parent = node.getParent();
        try {
            parent.getCorrespondingNodePath(destinationSession.getWorkspace().getName());
        }
        catch (ItemNotFoundException e) {
            cloneResult = this.cloneParents(parent, sourceSession, destinationSession, toCheckpoint);
            try {
                node.getCorrespondingNodePath(destinationSession.getWorkspace().getName());
                return cloneResult;
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
        }
        CloneResult subCloneResult = this.doClone(node, sourceSession, destinationSession, toCheckpoint);
        if (cloneResult != null) {
            subCloneResult.includedUuids.addAll(cloneResult.includedUuids);
        }
        return subCloneResult;
    }

    private void mergeToDestinationWorkspace(JCRNodeWrapper node, JCRSessionWrapper sourceSession, JCRSessionWrapper destinationSession, Calendar calendar, Set<JCRNodeWrapper> toCheckpoint) throws RepositoryException {
        String newDestinationPath;
        String destinationPath;
        VersionManager sourceVersionManager = sourceSession.getWorkspace().getVersionManager();
        VersionManager destinationVersionManager = destinationSession.getWorkspace().getVersionManager();
        boolean versionable = JCRContentUtils.needVersion(node, this.versionedTypes, this.excludedVersionedTypes);
        String path = node.getPath();
        try {
            destinationPath = node.getCorrespondingNodePath(destinationSession.getWorkspace().getName());
        }
        catch (ItemNotFoundException e) {
            return;
        }
        JCRNodeWrapper destinationNode = destinationSession.getNode(destinationPath);
        if (versionable) {
            destinationSession.checkout(destinationNode);
            if (logger.isDebugEnabled()) {
                logger.debug("Merge node : " + path + " source v=" + node.getBaseVersion().getName() + " , dest node v=" + destinationNode.getBaseVersion().getName());
            }
        }
        if (!destinationPath.equals(newDestinationPath = this.handleMoveOrRenamedNode(node, destinationSession, destinationPath, destinationNode, toCheckpoint))) {
            destinationPath = newDestinationPath;
            destinationNode = destinationSession.getNode(destinationPath);
        }
        destinationSession.save();
        if (versionable) {
            this.checkpoint(sourceSession, node, sourceVersionManager);
        }
        ConflictResolver resolver = new ConflictResolver(node, destinationNode);
        resolver.setToCheckpoint(toCheckpoint);
        resolver.applyDifferences();
        if (!resolver.getUnresolvedDifferences().isEmpty()) {
            logger.warn("Unresolved conflicts : " + String.valueOf(resolver.getUnresolvedDifferences()));
        }
        if (versionable) {
            ((JCRWorkspaceWrapper.VersionManagerWrapper)destinationVersionManager).addPredecessor(destinationPath, sourceVersionManager.getBaseVersion(path));
            toCheckpoint.add(destinationNode);
            if (logger.isDebugEnabled()) {
                logger.debug("Merge node end : " + path + " source v=" + sourceSession.getNode(path).getBaseVersion().getName() + " , dest node v=" + destinationSession.getNode(destinationPath).getBaseVersion().getName());
            }
        }
    }

    private String handleMoveOrRenamedNode(JCRNodeWrapper node, JCRSessionWrapper destinationSession, String destinationPath, JCRNodeWrapper destinationNode, Set<JCRNodeWrapper> toCheckpoint) throws RepositoryException {
        Object expectedDestinationPath = null;
        try {
            String parentDestinationPath = node.getParent().getPath().equals("/") ? "" : node.getParent().getCorrespondingNodePath(destinationSession.getWorkspace().getName());
            expectedDestinationPath = parentDestinationPath + "/" + node.getName();
        }
        catch (ItemNotFoundException parentDestinationPath) {
            // empty catch block
        }
        if (expectedDestinationPath == null || !((String)expectedDestinationPath).equals(destinationPath)) {
            String newParentPath;
            destinationSession.checkout(destinationNode.getParent());
            JCRNodeWrapper nodeParent = node.getParent();
            try {
                newParentPath = nodeParent.getCorrespondingNodePath(destinationSession.getWorkspace().getName());
            }
            catch (ItemNotFoundException e) {
                this.ensureNodeInDestinationWorkspace(nodeParent, destinationSession, toCheckpoint);
                newParentPath = nodeParent.getCorrespondingNodePath(destinationSession.getWorkspace().getName());
            }
            JCRNodeWrapper destinationNewParent = destinationSession.getNode(newParentPath);
            destinationSession.checkout(destinationNewParent);
            this.recurseCheckout(destinationNode, null, destinationSession);
            String newDestinationPath = newParentPath + "/" + node.getName();
            destinationSession.move((String)destinationPath, newDestinationPath);
            destinationSession.save();
            destinationPath = newDestinationPath;
            if (destinationNewParent.getPrimaryNodeType().hasOrderableChildNodes()) {
                JCRNodeIteratorWrapper ni = node.getParent().getNodes();
                boolean found = false;
                while (ni.hasNext()) {
                    JCRNodeWrapper currentNode = (JCRNodeWrapper)ni.next();
                    if (!found && currentNode.getIdentifier().equals(node.getIdentifier())) {
                        found = true;
                        continue;
                    }
                    if (!found) continue;
                    try {
                        destinationSession.getNode(newParentPath + "/" + currentNode.getName());
                        destinationNewParent.orderBefore(node.getName(), currentNode.getName());
                        destinationNewParent.getSession().save();
                        break;
                    }
                    catch (PathNotFoundException pathNotFoundException) {
                    }
                }
            }
        }
        return destinationPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CloneResult doClone(JCRNodeWrapper sourceNode, JCRSessionWrapper sourceSession, JCRSessionWrapper destinationSession, Set<JCRNodeWrapper> toCheckpoint) throws RepositoryException {
        CloneResult cloneResult;
        block20: {
            String sourceNodePath;
            cloneResult = new CloneResult();
            cloneResult.includedUuids = new HashSet<String>();
            JCRNodeWrapper parent = sourceNode.getParent();
            String string = sourceNodePath = sourceNode.getIndex() > 1 ? sourceNode.getPath() + "[" + sourceNode.getIndex() + "]" : sourceNode.getPath();
            if (logger.isDebugEnabled()) {
                logger.debug("Cloning node : " + sourceNodePath + " parent path " + parent.getPath());
            }
            String destinationWorkspaceName = destinationSession.getWorkspace().getName();
            String destinationParentPath = null;
            try {
                destinationParentPath = parent.getCorrespondingNodePath(destinationWorkspaceName);
            }
            catch (ItemNotFoundException e) {
                CloneResult parentCloneResult = this.cloneParents(sourceNode.getParent(), sourceSession, destinationSession, toCheckpoint);
                if (!parentCloneResult.includedUuids.contains(sourceNode.getParent().getIdentifier())) {
                    return cloneResult;
                }
                cloneResult.includedUuids.addAll(parentCloneResult.includedUuids);
                destinationParentPath = parent.getCorrespondingNodePath(destinationWorkspaceName);
            }
            JCRNodeWrapper destinationParent = destinationSession.getNode(destinationParentPath);
            if (destinationParent.hasNode(sourceNode.getName())) {
                logger.error("Node " + sourceNode.getName() + " is in conflict, already exist under " + destinationParent.getPath() + " - cannot publish !");
                return cloneResult;
            }
            try {
                HashSet<String> deniedPaths = new HashSet<String>();
                HashSet<String> included = new HashSet<String>();
                this.getDeniedPath(sourceNode, deniedPaths, included);
                cloneResult.includedUuids.addAll(included);
                JahiaAccessManager.setDeniedPaths(deniedPaths);
                destinationSession.checkout(destinationParent);
                String destinationPath = destinationParentPath.equals("/") ? "/" + sourceNode.getName() : destinationParentPath + "/" + sourceNode.getName();
                try {
                    String correspondingNodePath = sourceNode.getCorrespondingNodePath(destinationWorkspaceName);
                    logger.warn("Cloning existing node " + sourceNode.getPath());
                    destinationSession.checkout(destinationSession.getNodeByIdentifier(sourceNode.getIdentifier()));
                    destinationSession.checkout(destinationParent);
                    this.recurseCheckout(destinationSession.getNode(correspondingNodePath), null, destinationSession);
                    destinationSession.move(correspondingNodePath, destinationPath);
                    destinationSession.save();
                }
                catch (ItemNotFoundException e) {
                    JCRNodeWrapper n;
                    for (String s : included) {
                        n = sourceSession.getNodeByIdentifier(s);
                        if (!JCRContentUtils.needVersion(n, this.versionedTypes, this.excludedVersionedTypes)) continue;
                        this.checkpoint(sourceSession, n, sourceSession.getWorkspace().getVersionManager());
                    }
                    if (sourceNode.getDefinition().getDeclaringNodeType().isMixin() && !destinationParent.isNodeType(sourceNode.getDefinition().getDeclaringNodeType().getName())) {
                        destinationParent.addMixin(sourceNode.getDefinition().getDeclaringNodeType().getName());
                        destinationSession.save();
                    }
                    destinationSession.getWorkspace().clone(sourceSession.getWorkspace().getName(), sourceNodePath, destinationPath, false);
                    for (String s : included) {
                        n = destinationSession.getNodeByIdentifier(s);
                        if (!JCRContentUtils.needVersion(n, this.versionedTypes, this.excludedVersionedTypes)) continue;
                        toCheckpoint.add(n);
                    }
                    JCRNodeWrapper n2 = destinationSession.getNode(sourceNode.getCorrespondingNodePath(destinationWorkspaceName));
                    try {
                        if (JCRContentUtils.needVersion(n2.getParent(), this.versionedTypes, this.excludedVersionedTypes)) {
                            toCheckpoint.add(n2.getParent());
                        }
                    }
                    catch (ItemNotFoundException s) {
                        // empty catch block
                    }
                }
                if (!destinationParent.getPrimaryNodeType().hasOrderableChildNodes()) break block20;
                JCRNodeIteratorWrapper ni = sourceNode.getParent().getNodes();
                boolean found = false;
                while (ni.hasNext()) {
                    JCRNodeWrapper currentNode = (JCRNodeWrapper)ni.next();
                    if (!found && currentNode.getIdentifier().equals(sourceNode.getIdentifier())) {
                        found = true;
                        continue;
                    }
                    if (!found) continue;
                    try {
                        destinationSession.getNode((destinationParentPath.equals("/") ? "" : destinationParentPath) + "/" + currentNode.getName());
                        destinationParent.orderBefore(sourceNode.getName(), currentNode.getName());
                        destinationParent.getSession().save();
                        break;
                    }
                    catch (PathNotFoundException pathNotFoundException) {
                    }
                }
            }
            finally {
                JahiaAccessManager.setDeniedPaths(null);
            }
        }
        return cloneResult;
    }

    private void getDeniedPath(JCRNodeWrapper sourceNode, Set<String> deniedPaths, Set<String> includedUuids) throws RepositoryException {
        includedUuids.add(sourceNode.getIdentifier());
        JCRNodeIteratorWrapper it = sourceNode.getNodes();
        while (it.hasNext()) {
            JCRNodeWrapper nodeWrapper = (JCRNodeWrapper)it.next();
            if (nodeWrapper.isVersioned() || nodeWrapper.isNodeType("jmix:nolive") || sourceNode.getProvider() != nodeWrapper.getProvider()) {
                deniedPaths.add(nodeWrapper.getPath());
                continue;
            }
            this.getDeniedPath(nodeWrapper, deniedPaths, includedUuids);
        }
    }

    private void checkpoint(Session session, JCRNodeWrapper node, VersionManager versionManager) throws RepositoryException {
        if (logger.isDebugEnabled()) {
            logger.debug("Checkin node " + node.getPath() + " in workspace " + session.getWorkspace().getName() + " with current version " + versionManager.getBaseVersion(node.getPath()).getName());
        }
        if (node.isNodeType("jmix:nodenameInfo")) {
            boolean doUpdate = true;
            String nodePath = node.getPath();
            if (node.hasProperty("j:fullpath")) {
                JCRValueWrapper fp = node.getProperty("j:fullpath").getValue();
                boolean bl = doUpdate = fp == null || !StringUtils.equals((String)fp.getString(), (String)nodePath);
            }
            if (doUpdate) {
                node.setProperty("j:fullpath", node.getPath());
            }
        }
        session.save();
        Version version = versionManager.checkpoint(node.getPath());
        if (logger.isDebugEnabled()) {
            logger.debug("Checkin node " + node.getPath() + " in workspace " + session.getWorkspace().getName() + " with new version " + version.getName() + " base version is " + versionManager.getBaseVersion(node.getPath()).getName());
        }
    }

    private void recurseCheckout(Node node, List<String> prune, JCRSessionWrapper session) throws RepositoryException {
        session.checkout(node);
        NodeIterator ni = node.getNodes();
        while (ni.hasNext()) {
            Node sub = ni.nextNode();
            if (prune != null && prune.contains(sub.getIdentifier())) continue;
            this.recurseCheckout(sub, prune, session);
        }
    }

    public List<String> unpublish(List<String> uuids) throws RepositoryException {
        return this.unpublish(uuids, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> unpublish(List<String> uuids, boolean checkPermissions) throws RepositoryException {
        JahiaUser user = JCRSessionFactory.getInstance().getCurrentUser();
        final ArrayList<String> checkedUuids = new ArrayList<String>();
        if (checkPermissions) {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
            for (String uuid : uuids) {
                if (uuid == null || !session.getNodeByIdentifier(uuid).hasPermission("publish")) continue;
                checkedUuids.add(uuid);
            }
        } else {
            checkedUuids.addAll(uuids);
        }
        if (checkedUuids.isEmpty()) {
            return checkedUuids;
        }
        JCRCallback<Object> callback = new JCRCallback<Object>(){

            @Override
            public Object doInJCR(JCRSessionWrapper sourceSession) throws RepositoryException {
                ListIterator it = checkedUuids.listIterator(checkedUuids.size());
                while (it.hasPrevious()) {
                    Integer operationType;
                    boolean doLogging;
                    String uuid = (String)it.previous();
                    if (uuid == null) continue;
                    JCRNodeWrapper destNode = sourceSession.getNodeByIdentifier(uuid);
                    destNode.setProperty("j:published", false);
                    if (destNode.isNodeType("jnt:translation") && !JCRPublicationService.hasI18nPublished(destNode.getParent())) {
                        destNode.getParent().setProperty("j:published", false);
                    }
                    if ((doLogging = JCRPublicationService.this.loggingService.isEnabled()) && (operationType = JCRObservationManager.getCurrentOperationType()) != null && operationType == 13) {
                        doLogging = false;
                    }
                    if (!doLogging) continue;
                    String userID = destNode.getSession().getUserID();
                    if (userID != null && userID.startsWith(" system ")) {
                        userID = userID.substring(" system ".length());
                    }
                    JCRPublicationService.this.loggingService.logContentEvent(userID, "", "", destNode.getIdentifier(), destNode.getPath(), destNode.getPrimaryNodeTypeName(), "unpublishedNode", destNode.getSession().getWorkspace().getName());
                }
                sourceSession.save();
                return null;
            }
        };
        JCRTemplate.getInstance().doExecuteWithLongSystemSessionAsUser(user, "default", null, callback);
        JCRObservationManager.pushEventListenersAvailableDuringPublishOnly();
        try {
            JCRTemplate.getInstance().doExecuteWithLongSystemSessionAsUser(user, "live", null, callback);
        }
        finally {
            JCRObservationManager.popEventListenersAvailableDuringPublishOnly();
        }
        JCRPublicationService.broadcastUnpublishEventOnCluster(checkedUuids);
        return checkedUuids;
    }

    private static void broadcastUnpublishEventOnCluster(List<String> checkedUuids) {
        String topic = "org/jahia/cluster/broadcast/publication/unpublished";
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("uuids", checkedUuids);
        JournalEventReader reader = BundleUtils.getOsgiService(JournalEventReader.class, null);
        if (reader != null) {
            map.put("revision", Collections.singletonList(String.valueOf(reader.getGlobalRevision())));
        }
        FrameworkService.sendEvent(topic, map, true);
    }

    private static boolean hasI18nPublished(JCRNodeWrapper node) throws RepositoryException {
        NodeIterator ni = node.getI18Ns();
        while (ni.hasNext()) {
            Node n = ni.nextNode();
            if (!n.hasProperty("j:published") || !n.getProperty("j:published").getBoolean()) continue;
            return true;
        }
        return false;
    }

    public List<PublicationInfo> getPublicationInfos(List<String> uuids, Set<String> languages, boolean includesReferences, boolean includesSubnodes, boolean allsubtree, String sourceWorkspace, String destinationWorkspace) throws RepositoryException {
        ArrayList<PublicationInfo> infos = new ArrayList<PublicationInfo>();
        LinkedHashSet<String> allUuids = new LinkedHashSet<String>();
        for (String uuid : uuids) {
            if (allUuids.contains(uuid)) continue;
            List<PublicationInfo> publicationInfos = this.getPublicationInfo(uuid, languages, includesReferences, includesSubnodes, allsubtree, sourceWorkspace, destinationWorkspace);
            for (PublicationInfo publicationInfo : publicationInfos) {
                infos.add(publicationInfo);
                allUuids.addAll(publicationInfo.getAllUuids());
            }
        }
        return infos;
    }

    public List<PublicationInfo> getPublicationInfo(String uuid, Set<String> languages, boolean includesReferences, boolean includesSubnodes, boolean allsubtree, String sourceWorkspace, String destinationWorkspace) throws RepositoryException {
        JCRSessionWrapper sourceSession = this.sessionFactory.getCurrentUserSession(sourceWorkspace);
        sourceSession.disableSessionCache();
        JCRSessionWrapper destinationSession = this.sessionFactory.getCurrentUserSession(destinationWorkspace);
        destinationSession.disableSessionCache();
        return this.getPublicationInfo(uuid, languages, includesReferences, includesSubnodes, allsubtree, sourceSession, destinationSession);
    }

    public List<PublicationInfo> getPublicationInfo(String uuid, Set<String> languages, boolean includesReferences, boolean includesSubnodes, boolean allsubtree, JCRSessionWrapper sourceSession, JCRSessionWrapper destinationSession) throws RepositoryException {
        JCRNodeWrapper stageNode;
        try {
            stageNode = sourceSession.getNodeByUUID(uuid);
        }
        catch (ItemNotFoundException e) {
            logger.warn("ItemNotFoundException for {} in workspace {}", (Object)uuid, (Object)sourceSession.getWorkspace().getName());
            throw e;
        }
        ArrayList<PublicationInfo> infos = new ArrayList<PublicationInfo>();
        PublicationInfo tree = new PublicationInfo();
        infos.add(tree);
        tree.setRoot(this.getPublicationInfo(stageNode, languages, includesReferences, includesSubnodes, allsubtree, sourceSession, destinationSession, new HashMap<String, PublicationInfoNode>(), infos, tree));
        return infos;
    }

    private PublicationInfoNode getPublicationInfo(JCRNodeWrapper node, Set<String> languages, boolean includesReferences, boolean includesSubnodes, boolean allsubtree, JCRSessionWrapper sourceSession, JCRSessionWrapper destinationSession, Map<String, PublicationInfoNode> infosMap, List<PublicationInfo> infos, PublicationInfo currentPublicationInfo) throws RepositoryException {
        HashSet<String> wipLanguages = new HashSet<String>();
        boolean wipAllContent = false;
        PublicationInfoNode info = null;
        String uuid = node.getIdentifier();
        info = infosMap.get(uuid);
        if (info != null && (!allsubtree || info.isSubtreeProcessed())) {
            return info;
        }
        if (info != null && uuid == null) {
            info.setStatus(1);
            return info;
        }
        if (info == null) {
            info = new PublicationInfoNode(node.getIdentifier(), node.getPath());
            if (node.isNodeType("jmix:nolive")) {
                info.setStatus(1);
                return info;
            }
            info.setSubtreeProcessed(allsubtree);
            infosMap.put(uuid, info);
            if (node.hasProperty("j:deletedChildren")) {
                try {
                    JCRValueWrapper[] values;
                    JCRPropertyWrapper p = node.getProperty("j:deletedChildren");
                    JCRValueWrapper[] jCRValueWrapperArray = values = p.getValues();
                    int n = jCRValueWrapperArray.length;
                    for (int i = 0; i < n; ++i) {
                        JCRValueWrapper value = jCRValueWrapperArray[i];
                        try {
                            JCRNodeWrapper deletedNode = destinationSession.getNodeByUUID(value.getString());
                            PublicationInfoNode deletedInfo = new PublicationInfoNode(deletedNode.getIdentifier(), deletedNode.getPath());
                            deletedInfo.setStatus(11);
                            info.addChild(deletedInfo);
                            continue;
                        }
                        catch (ItemNotFoundException e) {
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("Cannot find deleted subnode of " + node.getPath() + " : " + value.getString() + ", we keep the reference until next publication to be sure to erase it from the live workspace.");
                        }
                    }
                }
                catch (PathNotFoundException e) {
                    logger.warn("property j:deletedChildren has been found on node " + node.getPath() + " but was not here");
                }
            }
            if (!node.isMarkedForDeletion() && node.hasProperty("j:workInProgressStatus")) {
                String wipStatus = node.getProperty("j:workInProgressStatus").getString();
                if (wipStatus.equals("ALL_CONTENT")) {
                    info.setWorkInProgress(true);
                    wipAllContent = true;
                } else if (wipStatus.equals("LANGUAGES")) {
                    for (JCRValueWrapper value : node.getProperty("j:workInProgressLanguages").getValues()) {
                        String wipLang = value.getString();
                        wipLanguages.add(wipLang);
                        if (info.isWorkInProgress() || languages == null || !languages.contains(wipLang)) continue;
                        info.setWorkInProgress(true);
                    }
                }
            }
            info.setStatus(this.getStatus(node, destinationSession, languages, infosMap.keySet()));
            if (allsubtree) {
                if (currentPublicationInfo.hasLiveNode() == null) {
                    try {
                        node.getCorrespondingNodePath(destinationSession.getWorkspace().getName());
                        currentPublicationInfo.setHasLiveNode(true);
                    }
                    catch (ItemNotFoundException e) {
                        currentPublicationInfo.setHasLiveNode(false);
                    }
                }
                if (info.getStatus() == 1 && !currentPublicationInfo.hasLiveNode().booleanValue()) {
                    info.setStatus(4);
                }
            }
            if (info.getStatus() == 9) {
                return info;
            }
            if (node.hasProperty("j:lockTypes")) {
                try {
                    JCRValueWrapper[] lockTypes;
                    for (JCRValueWrapper lockType : lockTypes = node.getProperty("j:lockTypes").getValues()) {
                        if (!lockType.getString().endsWith(":validation")) continue;
                        info.setLocked(true);
                    }
                }
                catch (PathNotFoundException lockTypes) {
                    // empty catch block
                }
            }
        }
        if (info.getStatus() == 9) {
            return info;
        }
        if (includesReferences || includesSubnodes) {
            if (includesReferences) {
                this.getReferences(node, languages, includesReferences, includesSubnodes, sourceSession, destinationSession, infosMap, infos, info);
            }
            JCRNodeIteratorWrapper ni = node.getNodes();
            while (ni.hasNext()) {
                JCRNodeWrapper n = (JCRNodeWrapper)ni.nextNode();
                if (!JCRPublicationService.supportsPublication(sourceSession, n)) continue;
                if (info.getStatus() == 12 || info.getStatus() == 11) {
                    info.addChild(this.getPublicationInfo(n, languages, includesReferences, true, true, sourceSession, destinationSession, infosMap, infos, currentPublicationInfo));
                    continue;
                }
                if (languages != null && n.isNodeType("jnt:translation")) {
                    String translationLanguage = n.getProperty("jcr:language").getString();
                    if (!languages.contains(translationLanguage)) continue;
                    PublicationInfoNode child = this.getPublicationInfo(n, languages, includesReferences, includesSubnodes, allsubtree, sourceSession, destinationSession, infosMap, infos, currentPublicationInfo);
                    info.addChild(child);
                    if (!wipAllContent && (wipLanguages == null || !wipLanguages.contains(translationLanguage))) continue;
                    info.getChildren().clear();
                    info.getReferences().clear();
                    info.addChild(child);
                    child.setWorkInProgress(true);
                    info.setWorkInProgress(true);
                    break;
                }
                boolean hasIndependantPublication = this.hasIndependantPublication(n);
                if (allsubtree && hasIndependantPublication) {
                    PublicationInfo newinfo = new PublicationInfo();
                    infos.add(newinfo);
                    newinfo.setRoot(this.getPublicationInfo(n, languages, includesReferences, includesSubnodes, allsubtree, sourceSession, destinationSession, infosMap, infos, newinfo));
                }
                if (hasIndependantPublication) continue;
                if (n.isNodeType("jmix:lastPublished")) {
                    info.addChild(this.getPublicationInfo(n, languages, includesReferences, includesSubnodes, allsubtree, sourceSession, destinationSession, infosMap, infos, currentPublicationInfo));
                    continue;
                }
                if (!includesReferences) continue;
                this.getReferences(n, languages, includesReferences, includesSubnodes, sourceSession, destinationSession, infosMap, infos, info);
            }
        }
        return info;
    }

    public int getStatus(JCRNodeWrapper node, JCRSessionWrapper destinationSession, Set<String> languages) throws RepositoryException {
        return this.getStatus(node, destinationSession, languages, Collections.emptySet());
    }

    public int getStatus(JCRNodeWrapper node, JCRSessionWrapper destinationSession, Set<String> languages, Set<String> includedUuids) throws RepositoryException {
        int status;
        if (!node.checkLanguageValidity(languages) && !node.isMarkedForDeletion()) {
            status = 6;
            for (String language : languages) {
                Locale locale = LanguageCodeConverters.getLocaleFromCode(language);
                if (!node.checkI18nAndMandatoryPropertiesForLocale(locale)) continue;
                status = 10;
            }
        } else if (!node.hasProperty("j:published")) {
            if (this.checkConflict(node, destinationSession, includedUuids) == 9) {
                return 9;
            }
            status = 4;
            if (node.isNodeType("jnt:translation")) {
                boolean hasProperty = false;
                PropertyIterator iterator = node.getProperties();
                while (iterator.hasNext() && !hasProperty) {
                    Property property = (Property)iterator.next();
                    hasProperty = ((ExtendedPropertyDefinition)property.getDefinition()).isInternationalized();
                }
                if (!hasProperty) {
                    status = 1;
                }
            }
        } else if (node.hasProperty("j:published") && !node.getProperty("j:published").getBoolean()) {
            status = 5;
        } else if (node.hasProperty("jcr:mergeFailed")) {
            status = 9;
        } else if (node.getLastModifiedAsDate() == null) {
            status = 1;
        } else if (node.isMarkedForDeletion()) {
            status = 12;
        } else {
            Date modProp;
            Date pubProp = node.getLastPublishedAsDate();
            if (pubProp == null) {
                destinationSession.getNodeByUUID(node.getIdentifier()).getLastModifiedAsDate();
            }
            Date date = modProp = pubProp != null ? node.getLastModifiedAsDate() : null;
            if (modProp == null) {
                logger.debug("Unable to check publication status for node {}. One of properties [last published or last modified (live) / last modified] is null. Considering node as modified.", (Object)node.getPath());
                status = 4;
            } else if (modProp.after(pubProp) || node.getSession().getChangedNodes().contains(node)) {
                if (node.hasProperty("j:fullpath") && !node.getCanonicalPath().equals(node.getProperty("j:fullpath").getString()) && this.checkConflict(node, destinationSession, includedUuids) == 9) {
                    return 9;
                }
                status = 3;
            } else {
                status = 1;
            }
        }
        return status;
    }

    private int checkConflict(JCRNodeWrapper node, JCRSessionWrapper destinationSession, Set<String> includedUuids) throws RepositoryException {
        try {
            try {
                JCRNodeWrapper parent = node.getParent();
                JCRNodeWrapper n = destinationSession.getNodeByIdentifier(parent.getIdentifier()).getNode(node.getName());
                if (n.getIdentifier().equals(node.getIdentifier())) {
                    return 0;
                }
                if (includedUuids.contains(parent.getIdentifier()) && parent.hasProperty("j:deletedChildren")) {
                    JCRValueWrapper[] values;
                    JCRPropertyWrapper p = parent.getProperty("j:deletedChildren");
                    for (JCRValueWrapper value : values = p.getValues()) {
                        if (!n.getIdentifier().equals(value.getString())) continue;
                        return 0;
                    }
                }
            }
            catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
                // empty catch block
            }
            return 9;
        }
        catch (ItemNotFoundException itemNotFoundException) {
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        return 0;
    }

    private void getReferences(JCRNodeWrapper node, Set<String> languages, boolean includesReferences, boolean includesSubnodes, JCRSessionWrapper sourceSession, JCRSessionWrapper destinationSession, Map<String, PublicationInfoNode> infosMap, List<PublicationInfo> infos, PublicationInfoNode info) throws RepositoryException {
        if (this.skipAllReferenceProperties) {
            return;
        }
        List<ExtendedPropertyDefinition> defs = node.getReferenceProperties();
        for (ExtendedPropertyDefinition def : defs) {
            String propName = def.getName();
            if (this.propertiesToSkipForReferences.contains(propName) || propName.startsWith("jcr:") || !node.hasProperty(propName)) continue;
            JCRPropertyWrapper p = node.getProperty(def.getName());
            if (def.isMultiple()) {
                Value[] vs;
                for (Value v : vs = p.getValues()) {
                    try {
                        JCRNodeWrapper ref = node.getSession().getNodeByUUID(v.getString());
                        if (this.skipReferencedNodeType(ref) || !JCRPublicationService.supportsPublication(sourceSession, ref)) continue;
                        logger.debug("Calculating publication status for the reference property {}", (Object)propName);
                        PublicationInfo refInfo = new PublicationInfo();
                        info.addReference(refInfo);
                        refInfo.setRoot(this.getPublicationInfo(ref, languages, includesReferences, includesSubnodes, false, sourceSession, destinationSession, infosMap, infos, refInfo));
                    }
                    catch (ItemNotFoundException e) {
                        if (def.getRequiredType() == 9) {
                            logger.warn("Cannot get reference " + p.getName() + " = " + v.getString() + " from node " + node.getPath());
                            continue;
                        }
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Cannot get reference " + p.getName() + " = " + v.getString() + " from node " + node.getPath());
                    }
                }
                continue;
            }
            try {
                JCRNodeWrapper ref = (JCRNodeWrapper)p.getNode();
                if (!JCRPublicationService.supportsPublication(sourceSession, ref) || this.skipReferencedNodeType(ref)) continue;
                logger.debug("Calculating publication status for the reference property {}", (Object)propName);
                PublicationInfo refInfo = new PublicationInfo();
                info.addReference(refInfo);
                refInfo.setRoot(this.getPublicationInfo(ref, languages, includesReferences, includesSubnodes, false, sourceSession, destinationSession, infosMap, infos, refInfo));
            }
            catch (ItemNotFoundException e) {
                if (def.getRequiredType() == 9) {
                    logger.warn("Cannot get reference " + p.getName() + " = " + p.getString() + " from node " + node.getPath());
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Cannot get reference " + p.getName() + " = " + p.getString() + " from node " + node.getPath());
            }
        }
    }

    public static boolean supportsPublication(JCRSessionWrapper sourceSession, JCRNodeWrapper node) throws RepositoryException {
        JCRStoreProvider provider = node.getProvider();
        if (provider.isDefault()) {
            return true;
        }
        Value workspaceManagement = sourceSession.getProviderSession(node.getProvider()).getRepository().getDescriptorValue("option.workspace.management.supported");
        if (workspaceManagement == null) {
            return false;
        }
        Value writeSupported = node.getSession().getProviderSession(node.getProvider()).getRepository().getDescriptorValue("write.supported");
        if (writeSupported == null) {
            return false;
        }
        return workspaceManagement.getBoolean() && writeSupported.getBoolean();
    }

    private boolean skipReferencedNodeType(JCRNodeWrapper ref) throws RepositoryException {
        for (String ntName : this.referencedNodeTypesToSkip) {
            if (!ref.isNodeType(ntName)) continue;
            return true;
        }
        return false;
    }

    protected void addRemovedLabel(JCRNodeWrapper node, String label) throws RepositoryException {
        if (JCRContentUtils.needVersion(node, this.versionedTypes, this.excludedVersionedTypes)) {
            VersionManager versionManager = node.getSession().getWorkspace().getVersionManager();
            versionManager.getVersionHistory(node.getPath()).addVersionLabel(versionManager.getBaseVersion(node.getPath()).getName(), label, false);
        }
        JCRNodeIteratorWrapper ni = node.getNodes();
        while (ni.hasNext()) {
            JCRNodeWrapper child = (JCRNodeWrapper)ni.next();
            this.addRemovedLabel(child, label);
        }
    }

    @Override
    public void start() throws JahiaInitializationException {
    }

    @Override
    public void stop() throws JahiaException {
    }

    public void print(VersionHistory vh) throws RepositoryException {
        Version root = vh.getRootVersion();
        this.print(root, 0);
    }

    public void print(Version v, int indent) throws RepositoryException {
        Version[] succ;
        System.out.print(StringUtils.leftPad((String)"", (int)indent) + "---- " + v.getName());
        Version[] preds = v.getPredecessors();
        System.out.print("(");
        for (Version pred : preds) {
            System.out.print(" " + pred.getName());
        }
        System.out.print(")");
        System.out.println("");
        for (Version version : succ = v.getSuccessors()) {
            this.print(version, indent + 2);
        }
    }

    public void setPropertiesToSkipForReferences(String propertiesToSkipForReferences) {
        this.propertiesToSkipForReferences = JCRContentUtils.splitAndUnify(propertiesToSkipForReferences, " ,");
        this.skipAllReferenceProperties = propertiesToSkipForReferences.contains(".*");
    }

    public void setReferencedNodeTypesToSkip(String referencedNodeTypesToSkip) {
        this.referencedNodeTypesToSkip = JCRContentUtils.splitAndUnify(referencedNodeTypesToSkip, " ,");
    }

    public void setVersionedTypes(String versionedTypes) {
        this.versionedTypes = JCRContentUtils.splitAndUnify(versionedTypes, " ,");
    }

    public void setExcludedVersionedTypes(String excludedVersionedTypes) {
        this.excludedVersionedTypes = JCRContentUtils.splitAndUnify(excludedVersionedTypes, " ,");
    }

    public void addReferencedNodeTypesToSkip(String referencedNodeTypesToSkip) {
        this.referencedNodeTypesToSkip.addAll(JCRContentUtils.splitAndUnify(referencedNodeTypesToSkip, " ,"));
    }

    public void addPropertiesToSkipForReferences(String propertiesToSkipForReferences) {
        this.propertiesToSkipForReferences.addAll(JCRContentUtils.splitAndUnify(propertiesToSkipForReferences, " ,"));
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void registerListener(PublicationEventListener listener) {
        this.listeners.add(listener);
    }

    public void unregisterListener(PublicationEventListener listener) {
        this.listeners.remove(listener);
    }

    class CloneResult {
        Set<String> includedUuids;

        CloneResult() {
        }
    }

    private static class Holder {
        static final JCRPublicationService INSTANCE = new JCRPublicationService();

        private Holder() {
        }
    }
}

