/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.util.Locale;
import javax.jcr.RepositoryException;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.usermanager.JahiaUser;

public class JCRTemplate
implements org.jahia.api.content.JCRTemplate {
    private JCRSessionFactory sessionFactory;
    private static volatile JCRTemplate instance;

    private JCRTemplate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JCRTemplate getInstance() {
        if (instance != null) return instance;
        Class<JCRTemplate> clazz = JCRTemplate.class;
        synchronized (JCRTemplate.class) {
            if (instance != null) return instance;
            instance = new JCRTemplate();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void setSessionFactory(JCRSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public JCRSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public <X> X doExecuteWithSystemSessionInSameWorkspaceAndLocale(JCRCallback<X> callback) throws RepositoryException {
        JCRSessionWrapper session = this.getSessionFactory().getCurrentUserSession();
        if (session == null) {
            throw new RepositoryException("Trying to execute as a system session using current workspace and locale when no current user session exists !");
        }
        return this.doExecuteWithSystemSessionAsUser(null, session.getWorkspace().getName(), session.getLocale(), callback);
    }

    @Override
    public <X> X doExecuteWithSystemSession(JCRCallback<X> callback) throws RepositoryException {
        return this.doExecuteWithSystemSessionAsUser(null, null, null, callback);
    }

    @Deprecated(since="7.2.0.0", forRemoval=true)
    public <X> X doExecuteWithSystemSession(String username, JCRCallback<X> callback) throws RepositoryException {
        return this.doExecuteWithSystemSession(username, null, null, callback);
    }

    @Deprecated(since="7.2.0.0", forRemoval=true)
    public <X> X doExecuteWithSystemSession(String username, String workspace, JCRCallback<X> callback) throws RepositoryException {
        return this.doExecuteWithSystemSession(username, workspace, null, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(since="7.2.0.0", forRemoval=true)
    public <X> X doExecuteWithSystemSession(String username, String workspace, Locale locale, JCRCallback<X> callback) throws RepositoryException {
        JCRSessionWrapper session = null;
        try {
            if (username != null && username.startsWith(" system ")) {
                throw new IllegalArgumentException("the username cannot start by \" system \"");
            }
            session = this.sessionFactory.getSystemSession(username, null, workspace, locale);
            X x = callback.doInJCR(session);
            return x;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    @Override
    public <X> X doExecuteWithLongSystemSession(JCRCallback<X> callback) throws RepositoryException {
        return this.doExecuteWithLongSystemSessionAsUser(null, null, null, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <X> X doExecuteWithSystemSessionAsUser(JahiaUser user, String workspace, Locale locale, JCRCallback<X> callback) throws RepositoryException {
        JCRSessionWrapper session = null;
        try {
            session = this.sessionFactory.getSystemSession(user != null ? user.getUsername() : null, user != null ? user.getRealm() : null, workspace, locale);
            X x = callback.doInJCR(session);
            return x;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <X> X doExecuteWithLongSystemSessionAsUser(JahiaUser user, String workspace, Locale locale, JCRCallback<X> callback) throws RepositoryException {
        JCRSessionWrapper session = null;
        try {
            session = this.sessionFactory.getSystemSession(user != null ? user.getUsername() : null, user != null ? user.getRealm() : null, workspace, locale).disableSessionCache();
            X x = callback.doInJCR(session);
            return x;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(since="7.2.0.0", forRemoval=true)
    public <X> X doExecuteWithUserSession(String username, String workspace, JCRCallback<X> callback) throws RepositoryException {
        JCRSessionWrapper session = null;
        try {
            session = this.sessionFactory.getUserSession(username, null, workspace, null);
            X x = callback.doInJCR(session);
            return x;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(since="7.2.0.0", forRemoval=true)
    public <X> X doExecuteWithUserSession(String username, String workspace, Locale locale, JCRCallback<X> callback) throws RepositoryException {
        JCRSessionWrapper session = null;
        try {
            session = this.sessionFactory.getUserSession(username, null, workspace, locale);
            X x = callback.doInJCR(session);
            return x;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <X> X doExecute(String username, String realm, String workspace, Locale locale, JCRCallback<X> callback) throws RepositoryException {
        JCRSessionWrapper session = null;
        try {
            session = this.sessionFactory.getUserSession(username, realm, workspace, locale);
            X x = callback.doInJCR(session);
            return x;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <X> X doExecute(JahiaUser user, String workspace, Locale locale, JCRCallback<X> callback) throws RepositoryException {
        JCRSessionWrapper session = null;
        try {
            session = this.sessionFactory.getUserSession(user != null ? user.getUsername() : null, user != null ? user.getRealm() : null, workspace, locale);
            X x = callback.doInJCR(session);
            return x;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    @Deprecated(since="7.2.0.0", forRemoval=true)
    public <X> X doExecute(boolean useSystemSession, String username, String workspace, Locale locale, JCRCallback<X> callback) throws RepositoryException {
        if (useSystemSession) {
            return this.doExecuteWithSystemSession(username, workspace, locale, callback);
        }
        return this.doExecuteWithUserSession(username, workspace, locale, callback);
    }

    @Deprecated(since="7.2.0.0", forRemoval=true)
    public <X> X doExecute(boolean useSystemSession, String username, String workspace, JCRCallback<X> callback) throws RepositoryException {
        if (useSystemSession) {
            return this.doExecuteWithSystemSession(username, workspace, callback);
        }
        return this.doExecuteWithUserSession(username, workspace, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <X> X doExecuteWithLongSession(JahiaUser user, String workspace, Locale locale, JCRCallback<X> callback) throws RepositoryException {
        JCRSessionWrapper session = null;
        try {
            session = this.sessionFactory.getUserSession(user != null ? user.getUsername() : null, user != null ? user.getRealm() : null, workspace, locale).disableSessionCache();
            X x = callback.doInJCR(session);
            return x;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public JCRStoreProvider getProvider(String path) {
        return this.sessionFactory.getProvider(path);
    }
}

