/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import org.apache.commons.lang.mutable.MutableInt;
import org.jahia.api.Constants;
import org.jahia.services.content.DefaultEventListener;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCREventIterator;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.importexport.ReferencesHelper;
import org.jahia.settings.SettingsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageModelListener
extends DefaultEventListener {
    private static final Logger logger = LoggerFactory.getLogger(PageModelListener.class);

    @Override
    public int getEventTypes() {
        return 1;
    }

    public void onEvent(final EventIterator events) {
        JCRSessionWrapper eventSession = ((JCREventIterator)events).getSession();
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(eventSession.getUser(), this.workspace, null, new JCRCallback<Object>(){

                @Override
                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    while (events.hasNext()) {
                        JCRNodeWrapper newPage;
                        Event event = events.nextEvent();
                        if (!session.nodeExists(event.getPath()) || !(newPage = session.getNode(event.getPath())).isNodeType("jmix:createdFromPageModel")) continue;
                        JCRNodeWrapper pageModel = session.getNode(newPage.getPropertyAsString("j:templateName"));
                        session.getUuidMapping().put(pageModel.getIdentifier(), newPage.getIdentifier());
                        List<String> childNodeTypesToSkip = pageModel.hasProperty("j:copySubPages") && pageModel.getProperty("j:copySubPages").getBoolean() ? null : Collections.singletonList("jnt:page");
                        PageModelListener.copySkippingTypes(newPage, pageModel, childNodeTypesToSkip, Collections.singletonList("j:templateName"));
                        for (String mixinToRemove : Arrays.asList("jmix:vanityUrlMapped", "jmix:canBeUseAsTemplateModel", "jmix:createdFromPageModel")) {
                            if (!newPage.isNodeType(mixinToRemove)) continue;
                            newPage.removeMixin(mixinToRemove);
                        }
                        newPage.revokeAllRoles();
                        session.save();
                    }
                    return null;
                }
            });
        }
        catch (RepositoryException e) {
            logger.error("Error while creating page model", (Throwable)e);
        }
    }

    private static void copySkippingTypes(JCRNodeWrapper newPage, JCRNodeWrapper pageModel, List<String> childNodeTypesToSkip, List<String> propertiesToOverride) throws RepositoryException {
        for (ExtendedNodeType mixin : pageModel.getMixinNodeTypes()) {
            if (Constants.forbiddenMixinToCopy.contains(mixin.getName())) continue;
            newPage.addMixin(mixin.getName());
        }
        HashMap<String, List<String>> references = new HashMap<String, List<String>>();
        PageModelListener.copyProperties(newPage, pageModel, references, propertiesToOverride);
        for (JCRNodeWrapper childNode : pageModel.getNodes()) {
            if (newPage.hasNode(childNode.getName()) && childNode.isNodeType("jnt:translation")) {
                JCRNodeWrapper i18nNode = newPage.getNode(childNode.getName());
                for (ExtendedNodeType mixin : childNode.getMixinNodeTypes()) {
                    if (Constants.forbiddenMixinToCopy.contains(mixin.getName())) continue;
                    i18nNode.addMixin(mixin.getName());
                }
                PageModelListener.copyProperties(i18nNode, childNode, references, propertiesToOverride);
                continue;
            }
            childNode.copy(newPage, childNode.getName(), true, references, childNodeTypesToSkip, SettingsBean.getInstance().getImportMaxBatch(), new MutableInt(0));
        }
        ReferencesHelper.resolveCrossReferences(newPage.getSession(), references, false);
    }

    private static void copyProperties(JCRNodeWrapper targetNode, JCRNodeWrapper sourceNode, Map<String, List<String>> references, List<String> propertiesToOverride) throws RepositoryException {
        PropertyIterator props = sourceNode.getProperties();
        while (props.hasNext()) {
            Property property = props.nextProperty();
            boolean b = !property.getDefinition().getDeclaringNodeType().isMixin() || targetNode.getProvider().isUpdateMixinAvailable();
            b = b && (propertiesToOverride.contains(property.getName()) || !targetNode.hasProperty(property.getName()));
            try {
                if (Constants.forbiddenPropertiesToCopy.contains(property.getName()) || !b) continue;
                if (property.getType() == 9 || property.getType() == 10) {
                    if (property.getDefinition().isMultiple() && property.isMultiple()) {
                        for (Value value : property.getValues()) {
                            PageModelListener.keepReference(targetNode, references, property, value.getString());
                        }
                    } else {
                        PageModelListener.keepReference(targetNode, references, property, property.getValue().getString());
                    }
                }
                if (property.getDefinition().isMultiple() && property.isMultiple()) {
                    targetNode.setProperty(property.getName(), property.getValues());
                    continue;
                }
                targetNode.setProperty(property.getName(), property.getValue());
            }
            catch (RepositoryException e) {
                logger.debug("Unable to copy property '" + property.getName() + "'. Skipping.", (Throwable)e);
            }
        }
    }

    private static void keepReference(JCRNodeWrapper destinationNode, Map<String, List<String>> references, Property property, String value) throws RepositoryException {
        if (!references.containsKey(value)) {
            references.put(value, new ArrayList());
        }
        references.get(value).add(destinationNode.getIdentifier() + "/" + property.getName());
    }
}

