/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import org.jahia.services.content.DefaultEventListener;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCREventIterator;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRObservationManager;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.usermanager.JahiaUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnpublishOnLiveDeletionListener
extends DefaultEventListener {
    private static Logger logger = LoggerFactory.getLogger(UnpublishOnLiveDeletionListener.class);

    @Override
    public int getEventTypes() {
        return 2;
    }

    public void onEvent(final EventIterator eventIterator) {
        try {
            JahiaUser user = ((JCREventIterator)eventIterator).getSession().getUser();
            JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(user, "default", null, new JCRCallback<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    try {
                        JCRObservationManager.setAllEventListenersDisabled(true);
                        while (eventIterator.hasNext()) {
                            Event event = eventIterator.nextEvent();
                            if (event.getType() != 2 || !UnpublishOnLiveDeletionListener.this.workspace.equals("live")) continue;
                            if (logger.isDebugEnabled()) {
                                logger.debug("Node in live removed, check if exists in default (" + event.getPath() + ")");
                            }
                            try {
                                JCRNodeWrapper node = session.getNodeByUUID(event.getIdentifier());
                                if (node == null || !node.hasProperty("j:published") || !node.getProperty("j:published").getBoolean()) continue;
                                try {
                                    node.getProperty("j:published").remove();
                                }
                                catch (RepositoryException ex) {
                                    logger.error("cannot remove Property j:published", (Throwable)ex);
                                }
                            }
                            catch (ItemNotFoundException itemNotFoundException) {}
                        }
                    }
                    catch (Exception ex) {
                        logger.error(ex.getMessage(), (Throwable)ex);
                    }
                    finally {
                        session.save();
                        JCRObservationManager.setAllEventListenersDisabled(false);
                    }
                    return null;
                }
            });
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

