/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.decorator;

import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.decorator.GroupNodeMembers;
import org.jahia.services.content.decorator.JCRNodeDecorator;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.query.QueryWrapper;
import org.jahia.services.usermanager.JahiaGroup;
import org.jahia.services.usermanager.JahiaGroupImpl;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaPrincipal;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRGroupNode
extends JCRNodeDecorator {
    protected static Logger logger = LoggerFactory.getLogger(JCRGroupNode.class);
    public static final String J_HIDDEN = "j:hidden";

    public JCRGroupNode(JCRNodeWrapper node) {
        super(node);
    }

    public JahiaGroup getJahiaGroup() {
        try {
            Properties properties = new Properties();
            try {
                properties.putAll(this.getPropertiesAsString());
            }
            catch (RepositoryException e) {
                logger.error("Cannot read group properties", (Throwable)e);
            }
            return new JahiaGroupImpl(this.getName(), this.getPath(), this.getResolveSite().getName(), properties);
        }
        catch (RepositoryException e) {
            logger.error("Cannot get group", (Throwable)e);
            return null;
        }
    }

    public String getGroupname() {
        return this.getName();
    }

    public String getGroupKey() {
        return this.getPath();
    }

    public String getProviderName() {
        return this.getProvider().getKey();
    }

    public List<JCRNodeWrapper> getMembers() {
        try {
            return new GroupNodeMembers(this);
        }
        catch (RepositoryException e) {
            if (!(e instanceof PathNotFoundException) || !this.isNew()) {
                logger.error("Cannot get member nodes");
            }
            return Collections.emptyList();
        }
    }

    public Set<JCRUserNode> getRecursiveUserMembers() {
        HashSet<JCRUserNode> result = new HashSet<JCRUserNode>();
        List<JCRNodeWrapper> members = this.getMembers();
        for (JCRNodeWrapper member : members) {
            if (member instanceof JCRUserNode) {
                result.add((JCRUserNode)member);
                continue;
            }
            if (!(member instanceof JCRGroupNode)) continue;
            result.addAll(((JCRGroupNode)member).getRecursiveUserMembers());
        }
        return result;
    }

    public boolean isMember(String userPath) {
        if ("/groups/guest".equals(this.getPath()) || "/groups/users".equals(this.getPath()) && !"/users/guest".equals(userPath) || "site-users".equals(this.getName()) && (!userPath.startsWith("/sites/") || userPath.startsWith("/sites/" + StringUtils.substringBetween((String)this.getPath(), (String)"/sites/", (String)"/")))) {
            return true;
        }
        List<String> membershipByPath = JahiaGroupManagerService.getInstance().getMembershipByPath(userPath);
        return membershipByPath != null && membershipByPath.contains(this.getPath());
    }

    public boolean isMember(JCRNodeWrapper principal) {
        return this.isMember(principal.getPath());
    }

    public void addMember(Principal principal) {
        if (principal instanceof JahiaPrincipal) {
            try {
                this.addMember(this.getSession().getNode(((JahiaPrincipal)principal).getLocalPath()));
            }
            catch (RepositoryException e) {
                logger.error("Cannot find principal", (Throwable)e);
            }
        }
    }

    public void addMembers(Collection<JCRNodeWrapper> members) {
        for (JCRNodeWrapper candidate : members) {
            this.addMember(candidate);
        }
    }

    public JCRNodeWrapper addMember(JCRNodeWrapper principal) {
        try {
            if (principal.isNodeType("jnt:user") || principal.isNodeType("jnt:group")) {
                String[] parts = principal.getPath().split("/");
                JCRNodeWrapper member = this.hasNode("j:members") ? this.getNode("j:members") : this.addNode("j:members", "jnt:members");
                for (int i = 1; i < parts.length - 1; ++i) {
                    member = member.hasNode(parts[i]) ? member.getNode(parts[i]) : member.addNode(parts[i], "jnt:members");
                }
                if (member.hasNode(parts[parts.length - 1])) {
                    member = member.getNode(parts[parts.length - 1]);
                } else {
                    member = member.addNode(parts[parts.length - 1], "jnt:member");
                    member.setProperty("j:member", principal.getIdentifier());
                }
                return member;
            }
        }
        catch (RepositoryException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public void removeMember(JCRNodeWrapper principal) {
        try {
            QueryWrapper q = this.getSession().getWorkspace().getQueryManager().createQuery("select * from [jnt:member] as m where isdescendantnode(m,'" + JCRContentUtils.sqlEncode(this.getPath()) + "') and [j:member]='" + principal.getIdentifier() + "'", "JCR-SQL2");
            NodeIterator ni = q.execute().getNodes();
            while (ni.hasNext()) {
                ni.nextNode().remove();
            }
        }
        catch (RepositoryException e) {
            logger.error("Cannot read group members", (Throwable)e);
        }
    }

    public boolean isHidden() {
        try {
            return this.hasProperty(J_HIDDEN) && this.getProperty(J_HIDDEN).getBoolean();
        }
        catch (RepositoryException e) {
            logger.error("Cannot read group", (Throwable)e);
            return false;
        }
    }

    @Override
    public String getDisplayableName() {
        try {
            return this.getDisplayableName(this.getSession().getLocale());
        }
        catch (RepositoryException e) {
            logger.error("", (Throwable)e);
            return super.getDisplayableName();
        }
    }

    public String getDisplayableName(Locale locale) {
        String groupName = this.getName();
        if ("guest".equals(groupName)) {
            Locale l = locale;
            if (l == null) {
                try {
                    l = this.getSession().getLocale();
                }
                catch (RepositoryException e) {
                    logger.error("", (Throwable)e);
                }
                if (l == null) {
                    l = SettingsBean.getInstance().getDefaultLocale();
                }
                if (l == null) {
                    l = Locale.ENGLISH;
                }
            }
            return Messages.get(ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackage(SettingsBean.getInstance().getGuestGroupResourceModuleName()), SettingsBean.getInstance().getGuestGroupResourceKey(), l, groupName);
        }
        return super.getDisplayableName();
    }
}

