/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.decorator;

import java.util.Map;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.decorator.JCRNodeDecorator;
import org.jahia.services.content.decorator.JCRProtectedNodeAbstractDecorator;
import org.jahia.settings.SettingsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRMountPointNode
extends JCRProtectedNodeAbstractDecorator {
    private static final Logger logger = LoggerFactory.getLogger(JCRMountPointNode.class);
    public static final String MOUNT_POINT_PROPERTY_NAME = "mountPoint";
    public static final String MOUNT_STATUS_PROPERTY_NAME = "mountStatus";
    public static final String MOUNT_SUFFIX = "-mount";
    public static final String MOUNT_POINT_SUFFIX = "-mountPoint";
    private static final String PERMISSION_TO_READ_PROPERTIES = "adminMountPoints";
    public static final String PROTECTED_PROPERTIES_PROPERTY_NAME = "protectedProperties";
    private static Boolean restrictReadForAllProperties;

    @Override
    protected boolean canReadProperty(String propertyName) throws RepositoryException {
        JCRValueWrapper[] values;
        if (this.node.hasPermission(PERMISSION_TO_READ_PROPERTIES)) {
            return true;
        }
        if (this.isRestrictReadForAllProperties()) {
            return false;
        }
        if (PROTECTED_PROPERTIES_PROPERTY_NAME.equals(propertyName)) {
            return false;
        }
        if (this.node.hasProperty(PROTECTED_PROPERTIES_PROPERTY_NAME) && (values = this.node.getProperty(PROTECTED_PROPERTIES_PROPERTY_NAME).getValues()) != null && values.length > 0) {
            for (JCRValueWrapper value : values) {
                if (value == null || value.getString() == null || !value.getString().equals(propertyName)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isRestrictReadForAllProperties() {
        if (restrictReadForAllProperties == null) {
            restrictReadForAllProperties = Boolean.valueOf(SettingsBean.getInstance().getPropertiesFile().getProperty("jahia.jcr.mountPointNode.restrictReadForAllProperties", "true"));
        }
        return restrictReadForAllProperties;
    }

    public void setProtectedPropertyNames(String[] propertyNames) throws RepositoryException {
        super.setProperty(PROTECTED_PROPERTIES_PROPERTY_NAME, propertyNames);
    }

    public JCRMountPointNode(JCRNodeWrapper node) {
        super(node, true);
    }

    public JCRStoreProvider getMountProvider() throws RepositoryException {
        JCRSessionFactory sessionFactory = this.getProvider().getSessionFactory();
        Map<String, JCRStoreProvider> mountPoints = sessionFactory.getProviders();
        return mountPoints.get(this.getIdentifier());
    }

    public JCRNodeWrapper getVirtualMountPointNode() {
        return new JCRVirtualMountPointNode(this);
    }

    @Override
    public void remove() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        JCRStoreProvider p;
        Map<String, JCRStoreProvider> mountPoints = this.getProvider().getSessionFactory().getMountPoints();
        JCRVirtualMountPointNode mountPoint = new JCRVirtualMountPointNode(this);
        String path = mountPoint.getPath();
        JCRStoreProvider jCRStoreProvider = p = mountPoints != null ? mountPoints.get(path) : null;
        if (p != null) {
            p.stop();
        }
        super.remove();
    }

    public MountStatus getMountStatus() {
        String status = this.getPropertyAsString(MOUNT_STATUS_PROPERTY_NAME);
        return status == null ? MountStatus.mounted : MountStatus.valueOf(status);
    }

    public void setMountStatus(String status) {
        if (status != null) {
            MountStatus mountStatus = MountStatus.valueOf(status);
            this.setMountStatus(mountStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMountStatus(MountStatus mountStatus) {
        if (mountStatus != null) {
            JCRSessionWrapper session = null;
            Boolean isValidationSkipped = null;
            try {
                if (!this.hasProperty(MOUNT_STATUS_PROPERTY_NAME) || !this.getProperty(MOUNT_STATUS_PROPERTY_NAME).getValue().getString().equals(mountStatus.name())) {
                    session = this.getSession();
                    isValidationSkipped = session.isSkipValidation();
                    session.setSkipValidation(true);
                    this.setProperty(MOUNT_STATUS_PROPERTY_NAME, mountStatus.name());
                }
            }
            catch (InvalidItemStateException ise) {
                if (!SettingsBean.getInstance().isClusterActivated()) {
                    logger.error("Couldn't save mount status for node " + this.node.getName(), (Throwable)ise);
                }
            }
            catch (RepositoryException e) {
                logger.error("Couldn't save mount status for node " + this.node.getName(), (Throwable)e);
            }
            finally {
                if (session != null && isValidationSkipped != null) {
                    session.setSkipValidation(isValidationSkipped);
                }
            }
        }
    }

    public String getTargetMountPointPath() {
        Object path;
        try {
            path = this.node.hasProperty(MOUNT_POINT_PROPERTY_NAME) ? this.node.getProperty(MOUNT_POINT_PROPERTY_NAME).getNode().getPath() + "/" + StringUtils.removeEnd((String)this.node.getName(), (String)MOUNT_SUFFIX) : (this.node.getPath().endsWith(MOUNT_SUFFIX) ? StringUtils.removeEnd((String)this.node.getPath(), (String)MOUNT_SUFFIX) : this.node.getPath() + MOUNT_POINT_SUFFIX);
        }
        catch (RepositoryException e) {
            if (!(e instanceof ItemNotFoundException)) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            path = this.node.getPath() + MOUNT_POINT_SUFFIX;
        }
        return path;
    }

    private class JCRVirtualMountPointNode
    extends JCRNodeDecorator {
        private JCRVirtualMountPointNode(JCRMountPointNode jcrMountPointNode) {
            super(jcrMountPointNode.getDecoratedNode());
        }

        @Override
        public String getPath() {
            return JCRMountPointNode.this.getTargetMountPointPath();
        }
    }

    public static enum MountStatus {
        mounted,
        unmounted,
        waiting,
        error;

    }
}

