/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.decorator;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.LazyPropertyIterator;
import org.jahia.services.content.decorator.JCRNodeDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JCRProtectedNodeAbstractDecorator
extends JCRNodeDecorator {
    private boolean alwaysAllowSystem;
    private static transient Logger logger = LoggerFactory.getLogger(JCRProtectedNodeAbstractDecorator.class);

    public JCRProtectedNodeAbstractDecorator(JCRNodeWrapper node) {
        super(node);
        this.alwaysAllowSystem = false;
    }

    public JCRProtectedNodeAbstractDecorator(JCRNodeWrapper node, boolean alwaysAllowSystem) {
        super(node);
        this.alwaysAllowSystem = alwaysAllowSystem;
    }

    protected abstract boolean canReadProperty(String var1) throws RepositoryException;

    public boolean canGetProperty(String propertyName) throws RepositoryException {
        return this.alwaysAllowSystem && this.getSession().isSystem() || this.canReadProperty(propertyName);
    }

    @Override
    public PropertyIterator getProperties() throws RepositoryException {
        return this.alwaysAllowSystem && this.getSession().isSystem() ? super.getProperties() : new FilteredIterator();
    }

    @Override
    public PropertyIterator getProperties(String s) throws RepositoryException {
        return this.alwaysAllowSystem && this.getSession().isSystem() ? super.getProperties(s) : new FilteredIterator(s);
    }

    @Override
    public PropertyIterator getProperties(String[] strings) throws RepositoryException {
        return this.alwaysAllowSystem && this.getSession().isSystem() ? super.getProperties(strings) : new FilteredIterator(strings);
    }

    @Override
    public Map<String, String> getPropertiesAsString() throws RepositoryException {
        return this.alwaysAllowSystem && this.getSession().isSystem() ? super.getPropertiesAsString() : Maps.filterKeys(super.getPropertiesAsString(), (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                try {
                    return JCRProtectedNodeAbstractDecorator.this.canGetProperty(input);
                }
                catch (RepositoryException e) {
                    return false;
                }
            }
        });
    }

    @Override
    public JCRPropertyWrapper getProperty(String s) throws PathNotFoundException, RepositoryException {
        if (!this.canGetProperty(s)) {
            throw new PathNotFoundException("Property " + s + " not found on node: " + this.getPath());
        }
        return super.getProperty(s);
    }

    @Override
    public String getPropertyAsString(String name) {
        try {
            return this.canGetProperty(name) ? super.getPropertyAsString(name) : null;
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean hasProperty(String s) throws RepositoryException {
        return super.hasProperty(s) && this.canGetProperty(s);
    }

    private class FilteredIterator
    extends LazyPropertyIterator {
        public FilteredIterator() throws RepositoryException {
            super(JCRProtectedNodeAbstractDecorator.this, JCRProtectedNodeAbstractDecorator.this.getSession().getLocale());
        }

        public FilteredIterator(String singlePattern) throws RepositoryException {
            super((JCRNodeWrapper)JCRProtectedNodeAbstractDecorator.this, JCRProtectedNodeAbstractDecorator.this.getSession().getLocale(), singlePattern);
        }

        public FilteredIterator(String[] patternArray) throws RepositoryException {
            super((JCRNodeWrapper)JCRProtectedNodeAbstractDecorator.this, JCRProtectedNodeAbstractDecorator.this.getSession().getLocale(), patternArray);
        }

        @Override
        public boolean hasNext() {
            while (super.hasNext()) {
                try {
                    if (!JCRProtectedNodeAbstractDecorator.this.canGetProperty(this.tempNext.getName())) {
                        this.tempNext = null;
                        continue;
                    }
                    return true;
                }
                catch (RepositoryException e) {
                    this.tempNext = null;
                    logger.error("Cannot read property", (Throwable)e);
                }
            }
            return false;
        }
    }
}

