/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.files;

import java.util.HashSet;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import org.jahia.services.content.DefaultEventListener;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.files.FileCacheManager;
import org.jahia.services.render.filter.cache.ModuleCacheProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCacheListener
extends DefaultEventListener {
    private static Logger logger = LoggerFactory.getLogger(FileCacheListener.class);
    private FileCacheManager cacheManager;
    private ModuleCacheProvider moduleCacheProvider;

    public void setCacheManager(FileCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setModuleCacheProvider(ModuleCacheProvider moduleCacheProvider) {
        this.moduleCacheProvider = moduleCacheProvider;
    }

    @Override
    public int getEventTypes() {
        return 63;
    }

    public void onEvent(EventIterator eventIterator) {
        HashSet<String> nodes = new HashSet<String>();
        while (eventIterator.hasNext()) {
            Event event = eventIterator.nextEvent();
            try {
                Object absPath;
                Map eventInfo;
                String path = event.getPath();
                String parentPath = path.substring(0, path.lastIndexOf(47));
                String name = path.substring(path.lastIndexOf(47) + 1);
                String parentName = parentPath.substring(parentPath.lastIndexOf(47) + 1);
                if ((event.getType() == 1 || event.getType() == 2) && name.equals("j:acl")) {
                    nodes.add(parentPath);
                }
                if ((event.getType() == 4 || event.getType() == 16 || event.getType() == 1 || event.getType() == 2) && parentName.equals("j:acl")) {
                    parentPath = parentPath.substring(0, parentPath.lastIndexOf(47));
                    nodes.add(parentPath);
                }
                if ((event.getType() == 4 || event.getType() == 16) && parentName.equals("jcr:content")) {
                    parentPath = parentPath.substring(0, parentPath.lastIndexOf(47));
                    nodes.add(parentPath);
                }
                if ((event.getType() == 4 || event.getType() == 16) && parentName.equals("j:conditionalVisibility")) {
                    parentPath = parentPath.substring(0, parentPath.lastIndexOf(47));
                    nodes.add(parentPath);
                }
                if (event.getType() == 16 && name.equals("j:published")) {
                    nodes.add(parentPath);
                }
                if (event.getType() == 2 && name.indexOf(58) == -1) {
                    nodes.add(path);
                }
                if (event.getType() != 32 || (eventInfo = event.getInfo()) == null || (absPath = eventInfo.get("srcAbsPath")) == null) continue;
                String srcAbsPath = absPath.toString();
                String destAbsPath = eventInfo.get("destAbsPath").toString();
                this.flushSubNodes(destAbsPath, srcAbsPath, destAbsPath);
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (!nodes.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Flushing file caches for {} node(s) in workspace {}: {}", new Object[]{nodes.size(), this.workspace, nodes});
            }
            for (String s : nodes) {
                this.cacheManager.invalidate(this.workspace, s);
            }
        }
    }

    private void flushSubNodes(final String nodePath, final String srcAbsPath, final String destAbsPath) throws RepositoryException {
        JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, this.workspace, null, new JCRCallback<Object>(){

            @Override
            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                block4: {
                    boolean debugEnabled = logger.isDebugEnabled();
                    try {
                        JCRNodeWrapper n = (JCRNodeWrapper)session.getItem(nodePath);
                        JCRNodeIteratorWrapper nodeIterator = n.getNodes();
                        while (nodeIterator.hasNext()) {
                            JCRNodeWrapper next = (JCRNodeWrapper)nodeIterator.next();
                            String path = next.getPath();
                            FileCacheListener.this.cacheManager.invalidate(FileCacheListener.this.workspace, path);
                            FileCacheListener.this.moduleCacheProvider.invalidate(path);
                            String replace = path.replace(destAbsPath, srcAbsPath);
                            FileCacheListener.this.cacheManager.invalidate(FileCacheListener.this.workspace, replace);
                            FileCacheListener.this.moduleCacheProvider.invalidate(replace);
                            if (debugEnabled) {
                                logger.debug("Flushing file caches for nodes in workspace {}: {}, {}", new Object[]{FileCacheListener.this.workspace, path, replace});
                            }
                            FileCacheListener.this.flushSubNodes(path, srcAbsPath, destAbsPath);
                        }
                    }
                    catch (Exception e) {
                        FileCacheListener.this.cacheManager.invalidate(FileCacheListener.this.workspace, srcAbsPath);
                        FileCacheListener.this.cacheManager.invalidate(FileCacheListener.this.workspace, nodePath);
                        FileCacheListener.this.moduleCacheProvider.invalidate(nodePath);
                        FileCacheListener.this.moduleCacheProvider.invalidate(srcAbsPath);
                        if (!debugEnabled) break block4;
                        logger.debug("Flushing file caches for nodes in workspace {}: {}, {}", new Object[]{FileCacheListener.this.workspace, srcAbsPath, nodePath});
                    }
                }
                return null;
            }
        });
    }
}

