/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.files;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.Patterns;

public class StaticFileServlet
extends HttpServlet {
    private static final long serialVersionUID = 7704264638970146054L;
    private static final Pattern PATTERN_ACCEPT_HEADER_REPLACE = Pattern.compile("/.*$");
    private static final Pattern PATTERN_ACCEPT_HEADER_SPLIT = Pattern.compile("\\s*(,|;)\\s*");
    private static final Pattern PATTERN_MATCH_HEADER_SPLIT = Pattern.compile("\\s*,\\s*");
    private static final Pattern PATTERN_RANGE = Pattern.compile("^bytes=\\d*-\\d*(,\\d*-\\d*)*$");
    private static final int DEFAULT_BUFFER_SIZE = 10240;
    private static final long DEFAULT_EXPIRE_TIME = 604800000L;
    private static final String MULTIPART_BOUNDARY = "MULTIPART_BYTERANGES";
    private static final String CONTENT_RANGE = "Content-Range";
    private static final String EXPIRES = "Expires";
    private String basePath;
    private boolean enableGzip;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String basePathValue = SettingsBean.getInstance().getJahiaGeneratedResourcesDiskPath();
        try {
            this.basePath = new File(basePathValue).getCanonicalPath();
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
        this.enableGzip = Boolean.valueOf(StringUtils.defaultString((String)config.getInitParameter("enable-gzip"), (String)"true"));
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response, false);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response, true);
    }

    private void processRequest(HttpServletRequest request, HttpServletResponse response, boolean content) throws IOException {
        block56: {
            String requestedFile = request.getPathInfo();
            if (requestedFile == null) {
                response.sendError(404);
                return;
            }
            File file = new File(this.basePath, URLDecoder.decode(requestedFile, "UTF-8"));
            if (!file.exists() || !file.isFile()) {
                response.sendError(404);
                return;
            }
            if (!file.getCanonicalPath().startsWith(this.basePath)) {
                response.sendError(404);
                return;
            }
            String fileName = file.getName();
            long length = file.length();
            long lastModified = file.lastModified();
            String eTag = fileName + "_" + length + "_" + lastModified;
            long expires = System.currentTimeMillis() + 604800000L;
            String ifNoneMatch = request.getHeader("If-None-Match");
            if (ifNoneMatch != null && StaticFileServlet.matches(ifNoneMatch, eTag)) {
                response.setStatus(304);
                response.setHeader("ETag", eTag);
                response.setDateHeader(EXPIRES, expires);
                return;
            }
            long ifModifiedSince = request.getDateHeader("If-Modified-Since");
            if (ifNoneMatch == null && ifModifiedSince != -1L && ifModifiedSince + 1000L > lastModified) {
                response.setStatus(304);
                response.setHeader("ETag", eTag);
                response.setDateHeader(EXPIRES, expires);
                return;
            }
            String ifMatch = request.getHeader("If-Match");
            if (ifMatch != null && !StaticFileServlet.matches(ifMatch, eTag)) {
                response.sendError(412);
                return;
            }
            long ifUnmodifiedSince = request.getDateHeader("If-Unmodified-Since");
            if (ifUnmodifiedSince != -1L && ifUnmodifiedSince + 1000L <= lastModified) {
                response.sendError(412);
                return;
            }
            Range full = new Range(0L, length - 1L, length);
            ArrayList<Range> ranges = new ArrayList<Range>();
            String range = request.getHeader("Range");
            if (range != null) {
                if (!PATTERN_RANGE.matcher(range).matches()) {
                    response.setHeader(CONTENT_RANGE, "bytes */" + length);
                    response.sendError(416);
                    return;
                }
                String ifRange = request.getHeader("If-Range");
                if (ifRange != null && !ifRange.equals(eTag)) {
                    try {
                        long ifRangeTime = request.getDateHeader("If-Range");
                        if (ifRangeTime != -1L && ifRangeTime + 1000L < lastModified) {
                            ranges.add(full);
                        }
                    }
                    catch (IllegalArgumentException ignore) {
                        ranges.add(full);
                    }
                }
                if (ranges.isEmpty()) {
                    for (String part : Patterns.COMMA.split(range.substring(6))) {
                        long start = StaticFileServlet.sublong(part, 0, part.indexOf(45));
                        long end = StaticFileServlet.sublong(part, part.indexOf(45) + 1, part.length());
                        if (start == -1L) {
                            start = length - end;
                            end = length - 1L;
                        } else if (end == -1L || end > length - 1L) {
                            end = length - 1L;
                        }
                        if (start > end) {
                            response.setHeader(CONTENT_RANGE, "bytes */" + length);
                            response.sendError(416);
                            return;
                        }
                        ranges.add(new Range(start, end, length));
                    }
                }
            }
            Object contentType = this.getServletContext().getMimeType(fileName);
            boolean acceptsGzip = false;
            String disposition = "inline";
            if (contentType == null) {
                contentType = "application/octet-stream";
            }
            if (((String)contentType).startsWith("text")) {
                String acceptEncoding = request.getHeader("Accept-Encoding");
                acceptsGzip = this.enableGzip && acceptEncoding != null && StaticFileServlet.accepts(acceptEncoding, "gzip");
                contentType = (String)contentType + ";charset=UTF-8";
            } else if (!((String)contentType).startsWith("image")) {
                String accept = request.getHeader("Accept");
                disposition = accept != null && StaticFileServlet.accepts(accept, (String)contentType) ? "inline" : "attachment";
            }
            response.reset();
            response.setBufferSize(10240);
            response.setHeader("Content-Disposition", disposition + ";filename=\"" + fileName + "\"");
            response.setHeader("Accept-Ranges", "bytes");
            response.setHeader("ETag", eTag);
            response.setDateHeader("Last-Modified", lastModified);
            response.setDateHeader(EXPIRES, expires);
            boolean done = false;
            try (RandomAccessFile input = new RandomAccessFile(file, "r");
                 ServletOutputStream output = response.getOutputStream();){
                if (ranges.isEmpty() || ranges.get(0) == full) {
                    Range r = full;
                    response.setContentType((String)contentType);
                    response.setHeader(CONTENT_RANGE, "bytes " + r.start + "-" + r.end + "/" + r.total);
                    if (content) {
                        if (acceptsGzip) {
                            response.setHeader("Content-Encoding", "gzip");
                        } else {
                            response.setHeader("Content-Length", String.valueOf(r.length));
                        }
                        boolean copyDone = false;
                        try (GZIPOutputStream outputStream = acceptsGzip ? new GZIPOutputStream((OutputStream)output, 10240) : output;){
                            StaticFileServlet.copy(input, outputStream, r.start, r.length);
                            copyDone = true;
                        }
                        catch (IOException e) {
                            if (!copyDone) {
                                throw e;
                            }
                        }
                    }
                } else if (ranges.size() == 1) {
                    Range r = (Range)ranges.get(0);
                    response.setContentType((String)contentType);
                    response.setHeader(CONTENT_RANGE, "bytes " + r.start + "-" + r.end + "/" + r.total);
                    response.setHeader("Content-Length", String.valueOf(r.length));
                    response.setStatus(206);
                    if (content) {
                        StaticFileServlet.copy(input, (OutputStream)output, r.start, r.length);
                    }
                } else {
                    response.setContentType("multipart/byteranges; boundary=MULTIPART_BYTERANGES");
                    response.setStatus(206);
                    if (content) {
                        for (Range r : ranges) {
                            output.println();
                            output.println("--MULTIPART_BYTERANGES");
                            output.println("Content-Type: " + (String)contentType);
                            output.println("Content-Range: bytes " + r.start + "-" + r.end + "/" + r.total);
                            StaticFileServlet.copy(input, (OutputStream)output, r.start, r.length);
                        }
                        output.println();
                        output.println("--MULTIPART_BYTERANGES--");
                    }
                }
                done = true;
            }
            catch (IOException e) {
                if (done) break block56;
                throw e;
            }
        }
    }

    private static boolean accepts(String acceptHeader, String toAccept) {
        Object[] acceptValues = PATTERN_ACCEPT_HEADER_SPLIT.split(acceptHeader);
        Arrays.sort(acceptValues);
        return Arrays.binarySearch(acceptValues, toAccept) > -1 || Arrays.binarySearch(acceptValues, PATTERN_ACCEPT_HEADER_REPLACE.matcher(toAccept).replaceAll("/*")) > -1 || Arrays.binarySearch(acceptValues, "*/*") > -1;
    }

    private static boolean matches(String matchHeader, String toMatch) {
        Object[] matchValues = PATTERN_MATCH_HEADER_SPLIT.split(matchHeader);
        Arrays.sort(matchValues);
        return Arrays.binarySearch(matchValues, toMatch) > -1 || Arrays.binarySearch(matchValues, "*") > -1;
    }

    private static long sublong(String value, int beginIndex, int endIndex) {
        String substring = value.substring(beginIndex, endIndex);
        return substring.length() > 0 ? Long.parseLong(substring) : -1L;
    }

    private static void copy(RandomAccessFile input, OutputStream output, long start, long length) throws IOException {
        byte[] buffer = new byte[10240];
        if (input.length() == length) {
            int read;
            while ((read = input.read(buffer)) > 0) {
                output.write(buffer, 0, read);
            }
        } else {
            int read;
            input.seek(start);
            long toRead = length;
            while ((read = input.read(buffer)) > 0) {
                if ((toRead -= (long)read) > 0L) {
                    output.write(buffer, 0, read);
                    continue;
                }
                output.write(buffer, 0, (int)toRead + read);
                break;
            }
        }
    }

    protected class Range {
        long start;
        long end;
        long length;
        long total;

        public Range(long start, long end, long total) {
            this.start = start;
            this.end = end;
            this.length = end - start + 1L;
            this.total = total;
        }
    }
}

