/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.interceptor;

import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.services.content.JCRStoreService;
import org.jahia.services.content.interceptor.BaseInterceptor;
import org.jahia.services.content.interceptor.PropertyInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class PropertyInterceptorRegistrator
implements InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(PropertyInterceptorRegistrator.class);
    private JCRStoreService jcrStoreService;
    private int position;
    private PropertyInterceptor propertyInterceptor;

    public void afterPropertiesSet() throws Exception {
        if (this.propertyInterceptor != null) {
            logger.info("Registering property interceptor {}", (Object)this.propertyInterceptor);
            this.jcrStoreService.removeInterceptor(this.propertyInterceptor);
            if (this.position != -1) {
                this.jcrStoreService.addInterceptor(this.position, this.propertyInterceptor);
            } else {
                this.jcrStoreService.addInterceptor(this.propertyInterceptor);
            }
        }
    }

    public void destroy() throws Exception {
        if (JahiaContextLoaderListener.isRunning() && this.jcrStoreService != null && this.propertyInterceptor != null) {
            if (this.propertyInterceptor instanceof BaseInterceptor) {
                logger.info("Unregistering property interceptor " + this.propertyInterceptor.getClass().getName() + " for types " + String.valueOf(((BaseInterceptor)this.propertyInterceptor).getRequiredTypes()) + " and selectors " + String.valueOf(((BaseInterceptor)this.propertyInterceptor).getSelectors()));
            } else {
                logger.info("Unregistering property interceptor {}", (Object)this.propertyInterceptor.getClass().getName());
            }
            this.jcrStoreService.removeInterceptor(this.propertyInterceptor);
        }
    }

    public void setJcrStoreService(JCRStoreService jcrStoreService) {
        this.jcrStoreService = jcrStoreService;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setPropertyInterceptor(PropertyInterceptor propertyInterceptor) {
        this.propertyInterceptor = propertyInterceptor;
    }
}

