/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.nodetypes;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.commons.lang.StringUtils;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.initializers.I15dValueInitializer;
import org.jahia.services.content.nodetypes.initializers.ValueInitializer;
import org.jahia.services.templates.ModuleVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicValueImpl
implements Value {
    private static final transient Logger logger = LoggerFactory.getLogger(DynamicValueImpl.class);
    private List<String> params;
    protected ExtendedPropertyDefinition declaringPropertyDefinition;
    private String fn;
    protected int type;

    public DynamicValueImpl(String fn, List<String> params, int type, boolean isConstraint, ExtendedPropertyDefinition declaringPropertyDefinition) {
        this.type = type;
        this.fn = fn;
        this.params = params;
        this.declaringPropertyDefinition = declaringPropertyDefinition;
    }

    public String getString() throws ValueFormatException, IllegalStateException, RepositoryException {
        return this.getExpandedValue().getString();
    }

    public InputStream getStream() throws IllegalStateException, RepositoryException {
        return this.getExpandedValue().getBinary().getStream();
    }

    public long getLong() throws IllegalStateException, RepositoryException {
        return this.getExpandedValue().getLong();
    }

    public double getDouble() throws ValueFormatException, IllegalStateException, RepositoryException {
        return this.getExpandedValue().getDouble();
    }

    public Calendar getDate() throws ValueFormatException, IllegalStateException, RepositoryException {
        return this.getExpandedValue().getDate();
    }

    public boolean getBoolean() throws ValueFormatException, IllegalStateException, RepositoryException {
        return this.getExpandedValue().getBoolean();
    }

    public Binary getBinary() throws RepositoryException {
        return this.getExpandedValue().getBinary();
    }

    public BigDecimal getDecimal() throws ValueFormatException, RepositoryException {
        return this.getExpandedValue().getDecimal();
    }

    public int getType() {
        return this.type;
    }

    public String getFn() {
        return this.fn;
    }

    public List<String> getParams() {
        return this.params;
    }

    public Value[] expand() {
        return this.expand(null);
    }

    public Value[] expand(Locale locale) {
        Value[] v = null;
        Object classname = this.fn.equals("useClass") ? this.getParams().get(0) : "org.jahia.services.content.nodetypes.initializers." + StringUtils.capitalize((String)this.fn);
        try {
            JahiaTemplatesPackage definitionTemplatePackage = this.getDefinitionTemplatePackage();
            if (definitionTemplatePackage != null) {
                ValueInitializer init = (ValueInitializer)definitionTemplatePackage.getClassLoader().loadClass((String)classname).newInstance();
                v = init instanceof I15dValueInitializer ? ((I15dValueInitializer)init).getValues(this.declaringPropertyDefinition, this.getParams(), locale) : init.getValues(this.declaringPropertyDefinition, this.getParams());
            } else {
                logger.error("Unable to resolve {} initializer because bundle owning definition cannot be found {} ", (Object)this.fn, (Object)this.declaringPropertyDefinition.getDeclaringNodeType().getSystemId());
            }
        }
        catch (Exception e) {
            logger.error("Unable to resolve {} initializer because {} {} (set DynamicValueImpl in debug for more details)", new Object[]{this.fn, e.getClass().getName(), e.getMessage()});
            logger.debug(e.getMessage(), (Throwable)e);
        }
        ArrayList<Value> res = new ArrayList<Value>();
        if (v != null) {
            for (int i = 0; i < v.length; ++i) {
                Value value = v[i];
                if (value instanceof DynamicValueImpl) {
                    res.addAll(Arrays.asList(((DynamicValueImpl)value).expand(locale)));
                    continue;
                }
                res.add(value);
            }
        }
        return res.toArray(new Value[res.size()]);
    }

    private JahiaTemplatesPackage getDefinitionTemplatePackage() {
        JahiaTemplatesPackage definitionTemplatePackage = this.declaringPropertyDefinition.getDeclaringNodeType().getTemplatePackage();
        if (definitionTemplatePackage == null) {
            Map<String, SortedMap<ModuleVersion, JahiaTemplatesPackage>> allModuleVersions = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageRegistry().getAllModuleVersions();
            String systemId = this.declaringPropertyDefinition.getDeclaringNodeType().getSystemId();
            for (JahiaTemplatesPackage jahiaTemplatesPackage : allModuleVersions.get(systemId).values()) {
                if (jahiaTemplatesPackage.getBundle().getState() < 4) continue;
                return jahiaTemplatesPackage;
            }
        }
        return definitionTemplatePackage;
    }

    private Value getExpandedValue() throws ValueFormatException {
        Value[] v = this.expand(null);
        if (v.length == 1) {
            return v[0];
        }
        throw new ValueFormatException("Dynamic value expanded to none/multiple values : " + v.length);
    }
}

