/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.nodetypes;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.nodetype.ItemDefinition;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.Name;

public class ExtendedItemDefinition
implements ItemDefinition {
    private ExtendedNodeType declaringNodeType;
    private Name name;
    private boolean isProtected = false;
    private boolean autoCreated = false;
    private boolean mandatory = false;
    private boolean hidden;
    private String itemType;
    private int onParentVersion = 2;
    private int onConflict = 5;
    protected int selector = 0;
    private Map<String, String> selectorOptions = new ConcurrentHashMap<String, String>();
    private Map<Locale, String> labels = new ConcurrentHashMap<Locale, String>(1);
    private Map<Locale, Map<String, String>> labelsByNodeType = new ConcurrentHashMap<Locale, Map<String, String>>(1);
    private Map<Locale, Map<String, String>> tooltipsByNodeType = new ConcurrentHashMap<Locale, Map<String, String>>(1);
    private boolean override = false;

    public ExtendedNodeType getDeclaringNodeType() {
        return this.declaringNodeType;
    }

    public void setDeclaringNodeType(ExtendedNodeType declaringNodeType) {
        this.declaringNodeType = declaringNodeType;
    }

    public String getName() {
        return this.name.toString();
    }

    public void setName(Name name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name.getLocalName();
    }

    public Name getNameObject() {
        return this.name;
    }

    public String getPrefix() {
        return this.name.getPrefix();
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public void setProtected(boolean isProtected) {
        this.isProtected = isProtected;
    }

    public boolean isAutoCreated() {
        return this.autoCreated;
    }

    public void setAutoCreated(boolean autoCreated) {
        this.autoCreated = autoCreated;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public int getOnParentVersion() {
        return this.onParentVersion;
    }

    public void setOnParentVersion(int onParentVersion) {
        this.onParentVersion = onParentVersion;
    }

    public int getOnConflict() {
        return this.onConflict;
    }

    public void setOnConflict(int onConflict) {
        this.onConflict = onConflict;
    }

    public int getSelector() {
        return this.selector;
    }

    public void setSelector(int selector) {
        this.selector = selector;
    }

    public Map<String, String> getSelectorOptions() {
        return this.selectorOptions;
    }

    public void setSelectorOptions(Map<String, String> selectorOptions) {
        this.selectorOptions = Collections.unmodifiableMap(selectorOptions);
    }

    public boolean isNode() {
        return false;
    }

    public boolean isOverride() {
        return this.override;
    }

    public void setOverride(boolean override) {
        this.override = override;
    }

    public String getResourceBundleKey() {
        return this.getResourceBundleKey(this.getDeclaringNodeType());
    }

    public String getResourceBundleKey(ExtendedNodeType nodeType) {
        if (nodeType == null) {
            return JCRContentUtils.replaceColon(this.getDeclaringNodeType().getName() + "." + this.getName());
        }
        return JCRContentUtils.replaceColon(nodeType.getName() + "." + this.getName());
    }

    public String getLabel(Locale locale) {
        String label = this.labels.get(locale);
        if (label == null) {
            label = this.getDeclaringNodeType().lookupLabel(this.getResourceBundleKey(), locale, JCRContentUtils.replaceColon(this.getName()));
            this.labels.put(locale, label);
        }
        return label;
    }

    public String getLabel(Locale locale, ExtendedNodeType nodeType) {
        String label;
        if (nodeType == null) {
            return this.getLabel(locale);
        }
        Map<String, String> labelNodeType = this.labelsByNodeType.get(locale);
        if (labelNodeType == null) {
            labelNodeType = new ConcurrentHashMap<String, String>();
            this.labelsByNodeType.put(locale, labelNodeType);
        }
        if ((label = labelNodeType.get(nodeType.getName())) == null) {
            label = nodeType.lookupLabel(this.getResourceBundleKey(nodeType), locale, null);
            if (label == null) {
                label = this.getLabel(locale);
            }
            labelNodeType.put(nodeType.getName(), label);
        }
        return label;
    }

    public void addLabel(Locale locale, String label) {
        this.labels.put(locale, label);
    }

    public String getTooltip(Locale locale, ExtendedNodeType extendedNodeType) {
        String label;
        Map<String, String> labelNodeType;
        ExtendedNodeType nodeType = extendedNodeType;
        if (nodeType == null) {
            nodeType = this.getDeclaringNodeType();
        }
        if ((labelNodeType = this.tooltipsByNodeType.get(locale)) == null) {
            labelNodeType = new ConcurrentHashMap<String, String>();
            this.tooltipsByNodeType.put(locale, labelNodeType);
        }
        if ((label = labelNodeType.get(nodeType.getName())) == null) {
            label = nodeType.lookupLabel(this.getResourceBundleKey(nodeType) + ".ui.tooltip", locale, "");
            labelNodeType.put(nodeType.getName(), label);
        }
        return label;
    }

    public void addTooltip(Locale locale, ExtendedNodeType extendedNodeType, String label) {
        Map<String, String> labelByNodeType = this.tooltipsByNodeType.get(locale);
        if (labelByNodeType == null) {
            labelByNodeType = new ConcurrentHashMap<String, String>();
        }
        labelByNodeType.put(extendedNodeType.getName(), label);
        this.tooltipsByNodeType.put(locale, labelByNodeType);
    }

    public String getItemType() {
        if (this.itemType == null) {
            String inheritedItemType = this.getDeclaringNodeType().getItemsType();
            if (inheritedItemType == null) {
                inheritedItemType = "content";
            }
            return inheritedItemType;
        }
        return this.itemType;
    }

    public String getLocalItemType() {
        return this.itemType;
    }

    public boolean isUnstructured() {
        return "*".equals(this.getName());
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public boolean isContentItem() {
        return !this.isHidden() && "content".equals(this.getItemType());
    }

    public ExtendedItemDefinition getOverridenDefinition() {
        ExtendedItemDefinition overridenItemDefintion = this;
        if (this.isOverride()) {
            for (ExtendedItemDefinition itemDef : this.declaringNodeType.getItems()) {
                if (!itemDef.getName().equals(this.getName()) || itemDef.isOverride()) continue;
                overridenItemDefintion = itemDef;
                break;
            }
        }
        return overridenItemDefintion;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExtendedItemDefinition other = (ExtendedItemDefinition)obj;
        return (this.getName() != null ? this.getName().equals(other.getName()) : other.getName() == null) && (this.getDeclaringNodeType().getName() != null ? this.getDeclaringNodeType().getName().equals(other.getDeclaringNodeType().getName()) : other.getDeclaringNodeType().getName() == null);
    }

    public int hashCode() {
        int hash = 629 + (this.getName() != null ? this.getName().hashCode() : 0);
        hash = 37 * hash + (this.getDeclaringNodeType().getName() != null ? this.getDeclaringNodeType().getName().hashCode() : 0);
        return hash;
    }

    public void clearLabels() {
        this.labels.clear();
        this.tooltipsByNodeType.clear();
        this.labelsByNodeType.clear();
    }
}

