/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.nodetypes.initializers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.map.LazyMap;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.content.nodetypes.ValueImpl;
import org.jahia.services.content.nodetypes.initializers.ChoiceListInitializer;
import org.jahia.services.content.nodetypes.initializers.ChoiceListValue;
import org.jahia.services.content.nodetypes.initializers.SortableFieldnamesChoiceListInitializerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentLinkerChoiceListInitializer
implements ChoiceListInitializer {
    private static transient Logger logger = LoggerFactory.getLogger(ComponentLinkerChoiceListInitializer.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<ChoiceListValue> getChoiceListValues(ExtendedPropertyDefinition epd, String param, List<ChoiceListValue> values, Locale locale, Map<String, Object> context) {
        ExtendedPropertyDefinition[] propertyDefs;
        ArrayList<ChoiceListValue> choiceListValues = new ArrayList<ChoiceListValue>();
        JCRNodeWrapper nodeWrapper = (JCRNodeWrapper)context.get("contextNode");
        if (nodeWrapper == null) {
            return Collections.emptyList();
        }
        try {
            if (!nodeWrapper.hasProperty(param)) return Collections.emptyList();
            JCRNodeWrapper boundNode = (JCRNodeWrapper)nodeWrapper.getProperty(param).getNode();
            if (boundNode.isNodeType("jnt:contentList") || boundNode.isNodeType("jnt:absoluteArea") || boundNode.isNodeType("jnt:levelAbsoluteArea") || boundNode.isNodeType("jnt:area")) {
                if (boundNode.hasProperty("j:allowedTypes") && boundNode.isNodeType("jmix:listRestrictions")) {
                    Value[] values1 = boundNode.getProperty("j:allowedTypes").getValues();
                    propertyDefs = ComponentLinkerChoiceListInitializer.getCommonChildNodeDefinitions(values1, true, true, new LinkedHashSet<String>());
                } else {
                    if (!boundNode.hasNodes()) return Collections.emptyList();
                    propertyDefs = SortableFieldnamesChoiceListInitializerImpl.getCommonChildNodeDefinitions(boundNode, true, true, new LinkedHashSet<String>()).getPropertyDefinitions();
                }
            } else {
                propertyDefs = boundNode.getPrimaryNodeType().getPropertyDefinitions();
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
        for (ExtendedPropertyDefinition propertyDef : propertyDefs) {
            choiceListValues.add(new ChoiceListValue(propertyDef.getLabel(locale), null, new ValueImpl(propertyDef.getName(), 1, false)));
        }
        Collections.sort(choiceListValues);
        return choiceListValues;
    }

    public static ExtendedPropertyDefinition[] getCommonChildNodeDefinitions(Value[] values, boolean showHidden, boolean showProtected, Set<String> excludedNodeTypes) throws RepositoryException {
        Map defs = null;
        NodeTypeRegistry typeRegistry = NodeTypeRegistry.getInstance();
        if (values.length > 0) {
            for (Value value : values) {
                ExtendedNodeType type = typeRegistry.getNodeType(value.getString());
                if (defs == null) {
                    defs = LazyMap.decorate(new HashMap(), (Factory)new Factory(){

                        public Object create() {
                            return new HashMap();
                        }
                    });
                    for (ExtendedPropertyDefinition propertyDef : type.getPropertyDefinitions()) {
                        if (!showHidden && propertyDef.isHidden() || !showProtected && propertyDef.isProtected()) continue;
                        ExtendedNodeType nodeType = propertyDef.getDeclaringNodeType();
                        if (!excludedNodeTypes.isEmpty() && excludedNodeTypes.contains(nodeType.getName())) continue;
                        ((Map)defs.get(nodeType.getName())).put(propertyDef.getName(), propertyDef);
                    }
                } else {
                    Iterator iterator = defs.keySet().iterator();
                    while (iterator.hasNext()) {
                        String commonType = (String)iterator.next();
                        if (type.isNodeType(commonType)) continue;
                        iterator.remove();
                    }
                }
                if (defs.isEmpty()) break;
            }
            LinkedList propertyDefinitions = new LinkedList();
            if (defs != null) {
                for (Map props : defs.values()) {
                    propertyDefinitions.addAll(props.values());
                }
            }
            return propertyDefinitions.toArray(new ExtendedPropertyDefinition[propertyDefinitions.size()]);
        }
        return new ExtendedPropertyDefinition[0];
    }
}

