/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.nodetypes.initializers;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.initializers.ChoiceListInitializer;
import org.jahia.services.content.nodetypes.initializers.ChoiceListValue;
import org.jahia.services.query.QueryWrapper;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.sites.JahiaSitesService;
import org.jahia.utils.Patterns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodesChoiceListInitializerImpl
implements ChoiceListInitializer {
    private static transient Logger logger = LoggerFactory.getLogger(NodesChoiceListInitializerImpl.class);
    private JCRSessionFactory sessionFactory;

    public void setSessionFactory(JCRSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public List<ChoiceListValue> getChoiceListValues(ExtendedPropertyDefinition epd, String param, List<ChoiceListValue> values, Locale locale, Map<String, Object> context) {
        ArrayList<ChoiceListValue> listValues = new ArrayList<ChoiceListValue>();
        if (CollectionUtils.isNotEmpty(values)) {
            listValues.addAll(values);
        }
        if (param != null) {
            for (String subParam : Patterns.PIPE.split(param)) {
                String[] s = Patterns.SEMICOLON.split(subParam);
                String nodetype = null;
                if (s.length > 1) {
                    nodetype = s[1];
                }
                try {
                    JCRSiteNode site;
                    JCRNodeWrapper resolvedNode = (JCRNodeWrapper)context.get("contextParent");
                    JCRNodeWrapper ctxNode = (JCRNodeWrapper)context.get("contextNode");
                    if (resolvedNode == null) {
                        resolvedNode = ctxNode;
                    }
                    if (ctxNode != null) {
                        site = ctxNode.getResolveSite();
                    } else if (resolvedNode != null) {
                        site = resolvedNode.getResolveSite();
                    } else {
                        JahiaSite defaultSite = JahiaSitesService.getInstance().getDefaultSite();
                        site = defaultSite != null ? (JCRSiteNode)this.sessionFactory.getCurrentUserSession().getNode("/sites/" + defaultSite.getSiteKey()) : (JCRSiteNode)this.sessionFactory.getCurrentUserSession().getNode(JCRContentUtils.getSystemSitePath());
                        resolvedNode = site;
                    }
                    String path = s[0];
                    String returnType = "";
                    if (s.length > 2) {
                        returnType = s[2];
                    }
                    path = StringUtils.contains((String)(path = StringUtils.replace((String)path, (String)"$currentSiteTemplatesSet", (String)("/modules/" + site.getTemplatePackage().getIdWithVersion()))), (String)"$currentSite/templates/") ? StringUtils.replace((String)path, (String)"$currentSite", (String)("/modules/" + site.getTemplatePackage().getIdWithVersion())) : StringUtils.replace((String)path, (String)"$currentSite", (String)site.getPath());
                    boolean subTree = false;
                    if (path.endsWith("//*")) {
                        path = StringUtils.substringBeforeLast((String)path, (String)"//*");
                        subTree = true;
                    }
                    JCRSessionWrapper jcrSessionWrapper = resolvedNode.getSession();
                    JCRNodeWrapper node = path.equals(".") ? resolvedNode : (path.startsWith("./") ? resolvedNode.getNode(path.substring(2)) : jcrSessionWrapper.getNode(path));
                    this.addSubnodes(listValues, nodetype, node, subTree, returnType, jcrSessionWrapper);
                }
                catch (PathNotFoundException e) {
                    logger.debug("Cannot find node " + e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return listValues;
    }

    private void addSubnodes(ArrayList<ChoiceListValue> listValues, String nodeType, JCRNodeWrapper node, boolean subTree, String returnType, JCRSessionWrapper jcrSessionWrapper) throws RepositoryException {
        String queryStmt = subTree ? "select * from [" + JCRContentUtils.sqlEncode(nodeType) + "] as t where isdescendantnode(t, ['" + JCRContentUtils.sqlEncode(node.getPath()) + "']) ORDER BY t.[j:nodename] ASC" : "select * from [" + JCRContentUtils.sqlEncode(nodeType) + "] as t where ischildnode(t, ['" + JCRContentUtils.sqlEncode(node.getPath()) + "']) ORDER BY t.[j:nodename] ASC";
        QueryWrapper query = jcrSessionWrapper.getWorkspace().getQueryManager().createQuery(queryStmt, "JCR-SQL2");
        NodeIterator nodeIterator = query.execute().getNodes();
        while (nodeIterator.hasNext()) {
            JCRNodeWrapper nodeWrapper = (JCRNodeWrapper)nodeIterator.next();
            String displayName = nodeWrapper.getDisplayableName();
            listValues.add(new ChoiceListValue(displayName, "name".equals(returnType) ? nodeWrapper.getName() : nodeWrapper.getIdentifier()));
        }
    }
}

