/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.nodetypes.initializers;

import java.util.List;
import java.util.Locale;
import javax.jcr.Value;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.ValueImpl;
import org.jahia.services.content.nodetypes.initializers.I15dValueInitializer;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceBundle
implements I15dValueInitializer {
    private static final Logger logger = LoggerFactory.getLogger(ResourceBundle.class);

    @Override
    public Value[] getValues(ExtendedPropertyDefinition declaringPropertyDefinition, List<String> params) {
        return this.getValues(declaringPropertyDefinition, params, null);
    }

    @Override
    public Value[] getValues(ExtendedPropertyDefinition declaringPropertyDefinition, List<String> params, Locale locale) {
        if (params == null || params.isEmpty()) {
            throw new IllegalArgumentException("This value initializer expects at least the label key to be provided as a parameter");
        }
        if (locale == null) {
            locale = SettingsBean.getInstance().getDefaultLocale();
        }
        String label = null;
        String key = params.get(0);
        if (params.size() > 1) {
            label = Messages.get(params.get(1), key, locale, key);
        } else {
            JahiaTemplatesPackage pkg = declaringPropertyDefinition.getDeclaringNodeType().getTemplatePackage();
            if (pkg == null) {
                pkg = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById("default");
            }
            label = pkg == null ? "__I15D_DEFAULT_VALUE__" : Messages.get(pkg, key, locale, key);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Computed default value for property [{}].[{}] and locale {}: {}", (Object[])new String[]{declaringPropertyDefinition.getDeclaringNodeType().getName(), declaringPropertyDefinition.getName(), String.valueOf(locale), label});
        }
        return new Value[]{new ValueImpl(label)};
    }
}

