/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.nodetypes.initializers;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.commons.io.IOUtils;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.initializers.ChoiceListInitializer;
import org.jahia.services.content.nodetypes.initializers.ChoiceListValue;
import org.jahia.utils.Patterns;
import org.jahia.utils.ScriptEngineUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class ScriptChoiceListInitializerImpl
implements ChoiceListInitializer {
    private static transient Logger logger = LoggerFactory.getLogger(ScriptChoiceListInitializerImpl.class);
    private ScriptEngineUtils scriptEngineUtils;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ChoiceListValue> getChoiceListValues(ExtendedPropertyDefinition epd, String param, List<ChoiceListValue> values, Locale locale, Map<String, Object> context) {
        if (param != null) {
            ScriptEngine byName;
            String extension = Patterns.DOT.split(param)[1];
            try {
                byName = this.scriptEngineUtils.scriptEngine(extension);
            }
            catch (ScriptException e) {
                logger.error(e.getMessage(), (Throwable)e);
                byName = null;
            }
            if (byName != null) {
                Set<JahiaTemplatesPackage> forModule = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getModulesWithViewsForComponent(JCRContentUtils.replaceColon(epd.getDeclaringNodeType().getName()));
                Bindings bindings = byName.getBindings(100);
                bindings.put("values", (Object)values);
                for (JahiaTemplatesPackage template : forModule) {
                    Resource scriptPath = template.getResource(File.separator + "scripts" + File.separator + param);
                    if (scriptPath == null || !scriptPath.exists()) continue;
                    InputStreamReader scriptContent = null;
                    try {
                        scriptContent = new InputStreamReader(scriptPath.getInputStream());
                        List list = (List)byName.eval((Reader)scriptContent, bindings);
                        return list;
                    }
                    catch (ScriptException e) {
                        logger.error("Error while executing script " + String.valueOf(scriptPath), (Throwable)e);
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    finally {
                        if (scriptContent != null) {
                            IOUtils.closeQuietly((Reader)scriptContent);
                        }
                    }
                }
            }
        }
        return Collections.emptyList();
    }

    public void setScriptEngineUtils(ScriptEngineUtils scriptEngineUtils) {
        this.scriptEngineUtils = scriptEngineUtils;
    }
}

