/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.nodetypes.initializers;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.content.nodetypes.initializers.ChoiceListInitializer;
import org.jahia.services.content.nodetypes.initializers.ChoiceListValue;
import org.jahia.utils.Patterns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubNodeTypesChoiceListInitializerImpl
implements ChoiceListInitializer {
    private static transient Logger logger = LoggerFactory.getLogger(SubNodeTypesChoiceListInitializerImpl.class);

    @Override
    public List<ChoiceListValue> getChoiceListValues(ExtendedPropertyDefinition epd, String param, List<ChoiceListValue> values, Locale locale, Map<String, Object> context) {
        TreeSet<ChoiceListValue> listValues = new TreeSet<ChoiceListValue>();
        if (StringUtils.isEmpty((String)param)) {
            param = "jmix:editorialContent";
        }
        try {
            String includedTypes = StringUtils.substringBefore((String)param, (String)";");
            HashSet<String> excludedTypes = new HashSet<String>();
            String exclusion = StringUtils.substringAfter((String)param, (String)";");
            if (StringUtils.isNotBlank((String)exclusion)) {
                excludedTypes.addAll(CollectionUtils.collect(Arrays.asList(Patterns.COMMA.split(StringUtils.substringAfter((String)param, (String)";"))), (Transformer)new Transformer(){

                    public Object transform(Object input) {
                        return ((String)input).trim();
                    }
                }));
            }
            for (String nodeTypeName : Patterns.COMMA.split(includedTypes)) {
                nodeTypeName = nodeTypeName.trim();
                ExtendedNodeType nodeType = NodeTypeRegistry.getInstance().getNodeType(nodeTypeName);
                if (!this.isExcludedType(nodeType, excludedTypes)) {
                    listValues.add(new ChoiceListValue(nodeType.getLabel(locale), nodeType.getName()));
                }
                List<ExtendedNodeType> subTypes = nodeType.getSubtypesAsList();
                Set<String> duplicates = this.findDuplicateLabels(subTypes, locale);
                for (ExtendedNodeType type : subTypes) {
                    if (this.isExcludedType(type, excludedTypes)) continue;
                    Object label = type.getLabel(locale);
                    if (duplicates.contains(label)) {
                        label = (String)label + " (" + type.getAlias() + ")";
                    }
                    listValues.add(new ChoiceListValue((String)label, type.getName()));
                }
            }
        }
        catch (NoSuchNodeTypeException e) {
            logger.error("Cannot get type", (Throwable)e);
        }
        return new LinkedList<ChoiceListValue>(listValues);
    }

    private boolean isExcludedType(ExtendedNodeType nodeType, Set<String> excludedTypes) {
        if (excludedTypes.contains(nodeType.getName())) {
            return true;
        }
        boolean isExcluded = false;
        for (String excludedType : excludedTypes) {
            if (!nodeType.isNodeType(excludedType)) continue;
            isExcluded = true;
            break;
        }
        return isExcluded;
    }

    private Set<String> findDuplicateLabels(List<ExtendedNodeType> subTypes, Locale locale) {
        HashSet<String> duplicates = new HashSet<String>();
        HashSet<String> uniques = new HashSet<String>();
        for (ExtendedNodeType subType : subTypes) {
            String label = subType.getLabel(locale);
            if (uniques.add(label)) continue;
            duplicates.add(label);
        }
        return duplicates;
    }
}

