/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.nodetypes.initializers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.Jahia;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.content.nodetypes.ValueImpl;
import org.jahia.services.content.nodetypes.initializers.ChoiceListInitializer;
import org.jahia.services.content.nodetypes.initializers.ChoiceListValue;
import org.jahia.services.render.RenderService;
import org.jahia.services.render.View;
import org.jahia.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class TemplatesChoiceListInitializerImpl
implements ChoiceListInitializer {
    private static transient Logger logger = LoggerFactory.getLogger(TemplatesChoiceListInitializerImpl.class);

    @Override
    public List<ChoiceListValue> getChoiceListValues(ExtendedPropertyDefinition declaringPropertyDefinition, String param, List<ChoiceListValue> values, Locale locale, Map<String, Object> context) {
        if (context == null) {
            return new ArrayList<ChoiceListValue>();
        }
        JCRNodeWrapper node = (JCRNodeWrapper)context.get("contextNode");
        JCRNodeWrapper parentNode = (JCRNodeWrapper)context.get("contextParent");
        ExtendedNodeType realNodeType = (ExtendedNodeType)context.get("contextType");
        String propertyName = context.containsKey("dependentProperties") ? (String)((List)context.get("dependentProperties")).get(0) : null;
        JCRSiteNode site = null;
        TreeSet<View> views = new TreeSet<View>();
        boolean subViews = false;
        try {
            if (node != null) {
                site = node.getResolveSite();
            }
            if (site == null && parentNode != null) {
                site = parentNode.getResolveSite();
            }
            ArrayList<String> nodeTypeList = new ArrayList<String>();
            String nextParam = "";
            if (param.contains(",")) {
                nextParam = StringUtils.substringAfter((String)param, (String)",");
                param = StringUtils.substringBefore((String)param, (String)",");
            }
            if ("subnodes".equals(param)) {
                JCRValueWrapper[] types;
                subViews = true;
                if (propertyName == null) {
                    propertyName = "j:allowedTypes";
                }
                if (context.containsKey(propertyName)) {
                    types = (JCRValueWrapper[])context.get(propertyName);
                    for (String string : types) {
                        nodeTypeList.add(string);
                    }
                } else if (node != null && node.hasProperty(propertyName)) {
                    JCRPropertyWrapper property = node.getProperty(propertyName);
                    if (property.isMultiple()) {
                        JCRValueWrapper[] types2;
                        for (JCRValueWrapper type : types2 = property.getValues()) {
                            nodeTypeList.add(type.getString());
                        }
                    } else {
                        nodeTypeList.add(property.getValue().getString());
                    }
                } else if (node != null && !"j:allowedTypes".equals(propertyName) && node.hasProperty("j:allowedTypes")) {
                    for (JCRValueWrapper type : types = node.getProperty("j:allowedTypes").getValues()) {
                        nodeTypeList.add(type.getString());
                    }
                } else if (node != null) {
                    JCRNodeIteratorWrapper nodeIterator = node.getNodes();
                    while (nodeIterator.hasNext()) {
                        Node next = (Node)nodeIterator.next();
                        String string = next.getPrimaryNodeType().getName();
                        if (nodeTypeList.contains(string) || !next.isNodeType("jnt:content")) continue;
                        nodeTypeList.add(string);
                    }
                }
                param = nextParam;
            } else if ("reference".equals(param)) {
                if (propertyName == null) {
                    propertyName = "j:node";
                }
                if (context.containsKey(propertyName) && context.get(propertyName) != null) {
                    JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
                    List refNodeUuids = (List)context.get(propertyName);
                    for (String refNodeUuid : refNodeUuids) {
                        try {
                            JCRNodeWrapper refNode2 = session.getNodeByUUID(refNodeUuid);
                            nodeTypeList.addAll(refNode2.getNodeTypes());
                        }
                        catch (Exception e) {
                            logger.warn("Referenced node not found to retrieve its nodetype for initializer", (Throwable)e);
                        }
                    }
                } else if (node != null && node.hasProperty(propertyName)) {
                    try {
                        JCRNodeWrapper refNode3 = (JCRNodeWrapper)node.getProperty(propertyName).getNode();
                        nodeTypeList.addAll(refNode3.getNodeTypes());
                    }
                    catch (ItemNotFoundException refNode3) {}
                } else if (node != null && !"j:node".equals(propertyName) && node.hasProperty("j:node")) {
                    try {
                        JCRNodeWrapper refNode4 = (JCRNodeWrapper)node.getProperty("j:node").getNode();
                        nodeTypeList.addAll(refNode4.getNodeTypes());
                    }
                    catch (ItemNotFoundException refNode4) {
                        // empty catch block
                    }
                }
                param = nextParam;
            } else if ("mainresource".equals(param)) {
                JCRNodeWrapper parent;
                if (node == null) {
                    parent = (JCRNodeWrapper)context.get("contextParent");
                    site = parent.getResolveSite();
                } else {
                    parent = node.getParent();
                }
                try {
                    while (true) {
                        if (parent.isNodeType("jnt:template")) break;
                        parent = parent.getParent();
                    }
                    JCRNodeWrapper matchingParent = parent;
                    if (matchingParent.hasProperty("j:applyOn")) {
                        JCRValueWrapper[] jCRValueWrapperArray;
                        for (JCRValueWrapper v : jCRValueWrapperArray = matchingParent.getProperty("j:applyOn").getValues()) {
                            nodeTypeList.add(v.getString());
                        }
                    }
                }
                catch (ItemNotFoundException itemNotFoundException) {
                    // empty catch block
                }
                if (nodeTypeList.isEmpty()) {
                    nodeTypeList.add("jnt:page");
                }
                param = nextParam;
            } else if (param != null && param.indexOf(":") > 0) {
                nodeTypeList.add(param);
                param = nextParam;
            } else if (node != null) {
                nodeTypeList.addAll(node.getNodeTypes());
            } else if (realNodeType != null) {
                nodeTypeList.add(realNodeType.getName());
            }
            if (nodeTypeList.isEmpty()) {
                nodeTypeList.add("nt:base");
            }
            TreeSet wrappedViews = new TreeSet();
            HashSet<ViewWrapper> wrappedViewsSet = new HashSet<ViewWrapper>();
            for (String s : nodeTypeList) {
                SortedSet<View> viewsSet = RenderService.getInstance().getViewsSet(NodeTypeRegistry.getInstance().getNodeType(s), site, "html");
                if (!viewsSet.isEmpty()) {
                    Iterator iterator = viewsSet.iterator();
                    while (iterator.hasNext()) {
                        wrappedViewsSet.add(new ViewWrapper((View)iterator.next()));
                    }
                    if (subViews && !wrappedViews.isEmpty() && !NodeTypeRegistry.getInstance().getNodeType(s).getName().equals("jnt:contentReference")) {
                        wrappedViews.retainAll(wrappedViewsSet);
                    } else {
                        wrappedViews.addAll(wrappedViewsSet);
                    }
                }
                wrappedViewsSet.clear();
            }
            Iterator iterator = wrappedViews.iterator();
            while (iterator.hasNext()) {
                views.add(((ViewWrapper)iterator.next()).getView());
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        ArrayList<ChoiceListValue> vs = new ArrayList<ChoiceListValue>();
        for (View view : views) {
            boolean bl;
            HashMap<String, Object> map = new HashMap<String, Object>();
            this.fillProperties(map, view.getDefaultProperties());
            this.fillProperties(map, view.getProperties());
            boolean bl2 = bl = site != null && site.getPath().startsWith("/modules");
            if (!this.isViewVisible(view.getKey(), param, map, bl)) continue;
            JahiaTemplatesPackage pkg = view.getModule() != null ? view.getModule() : ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById("default");
            String displayName = Messages.get(pkg, declaringPropertyDefinition.getResourceBundleKey() + "." + JCRContentUtils.replaceColon(view.getKey()), locale, view.getKey());
            ChoiceListValue c = new ChoiceListValue(displayName, map, new ValueImpl(view.getKey(), 1, false));
            try {
                Resource imagePath = pkg.getResource(File.separator + "img" + File.separator + c.getValue().getString() + ".png");
                if (imagePath != null && imagePath.exists()) {
                    String s = Jahia.getContextPath();
                    if (s.equals("/")) {
                        s = "";
                    }
                    c.addProperty("image", s + (pkg.getRootFolderPath().startsWith("/") ? "" : "/") + pkg.getRootFolderPath() + "/img/" + c.getValue().getString() + ".png");
                }
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            vs.add(c);
        }
        Collections.sort(vs);
        return vs;
    }

    private boolean isViewVisible(String viewKey, String param, HashMap<String, Object> viewProperties, boolean isStudio) {
        Object visible = viewProperties.get("visible");
        Object type = viewProperties.get("type");
        return !"false".equals(visible) && (!"studioOnly".equals(visible) || isStudio) && (type == null && StringUtils.isEmpty((String)param) || param.equals(type)) && !viewKey.startsWith("wrapper.") && !viewKey.contains("hidden.");
    }

    private void fillProperties(HashMap<String, Object> map, Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            map.put(entry.getKey().toString(), entry.getValue());
        }
    }

    public class ViewWrapper
    implements Comparable<ViewWrapper> {
        private final View view;

        public ViewWrapper(View view) {
            this.view = view;
        }

        public View getView() {
            return this.view;
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass() == obj.getClass() && this.view.getKey().equals(((ViewWrapper)obj).view.getKey());
        }

        public int hashCode() {
            return this.view.getKey().hashCode();
        }

        @Override
        public int compareTo(ViewWrapper o) {
            return this.view.getKey().compareTo(o.getView().getKey());
        }
    }
}

