/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.nodetypes.initializers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.QueryManagerWrapper;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.ValueImpl;
import org.jahia.services.content.nodetypes.initializers.ChoiceListInitializer;
import org.jahia.services.content.nodetypes.initializers.ChoiceListValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsersChoiceListInitializerImpl
implements ChoiceListInitializer {
    private static final Logger logger = LoggerFactory.getLogger(UsersChoiceListInitializerImpl.class);

    @Override
    public List<ChoiceListValue> getChoiceListValues(ExtendedPropertyDefinition epd, String param, List<ChoiceListValue> values, Locale locale, Map<String, Object> context) {
        ArrayList<ChoiceListValue> vs = new ArrayList<ChoiceListValue>();
        try {
            QueryManagerWrapper qm = JCRSessionFactory.getInstance().getCurrentUserSession().getWorkspace().getQueryManager();
            Query q = qm.createQuery("select * from [jnt:user] as user order by user.name", "JCR-SQL2");
            QueryResult qr = q.execute();
            NodeIterator ni = qr.getNodes();
            while (ni.hasNext()) {
                JCRNodeWrapper node = (JCRNodeWrapper)ni.nextNode();
                if (node.getName().equals("guest")) continue;
                Object name = "";
                if (node.hasProperty("j:firstName")) {
                    name = (String)name + node.getProperty("j:firstName").getString() + " ";
                }
                if (node.hasProperty("j:lastName")) {
                    name = (String)name + node.getProperty("j:lastName").getString();
                }
                if (((String)(name = ((String)name).trim())).equals("")) {
                    name = node.getName();
                }
                if (epd.getRequiredType() == 1) {
                    vs.add(new ChoiceListValue((String)name, new HashMap<String, Object>(), new ValueImpl(node.getPath(), epd.getRequiredType(), false)));
                    continue;
                }
                vs.add(new ChoiceListValue((String)name, new HashMap<String, Object>(), new ValueImpl(node.getIdentifier(), epd.getRequiredType(), false)));
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return vs;
    }
}

