/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.rules;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.drools.compiler.compiler.DroolsParserException;
import org.drools.compiler.compiler.PackageBuilder;
import org.drools.compiler.compiler.PackageBuilderConfiguration;
import org.drools.compiler.compiler.PackageBuilderErrors;
import org.drools.core.RuleBase;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.RuleBaseFactory;
import org.drools.core.StatelessSession;
import org.drools.core.base.EnabledBoolean;
import org.drools.core.common.DroolsObjectInputStream;
import org.drools.core.common.DroolsObjectOutputStream;
import org.drools.core.rule.Package;
import org.drools.core.rule.Rule;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.osgi.BundleDelegatingClassLoader;
import org.jahia.services.content.DefaultEventListener;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCREventIterator;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRObservationManager;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.rules.AbstractNodeFact;
import org.jahia.services.content.rules.AddedNodeFact;
import org.jahia.services.content.rules.ChangedPropertyFact;
import org.jahia.services.content.rules.CopiedNodeFact;
import org.jahia.services.content.rules.DeletedNodeFact;
import org.jahia.services.content.rules.DeletedPropertyFact;
import org.jahia.services.content.rules.DeletedSubNodeFact;
import org.jahia.services.content.rules.MovedNodeFact;
import org.jahia.services.content.rules.NodeFact;
import org.jahia.services.content.rules.OperationTypeFact;
import org.jahia.services.content.rules.PublishedNodeFact;
import org.jahia.services.content.rules.Updateable;
import org.jahia.services.content.rules.UpdateableWithNewFacts;
import org.jahia.services.content.rules.User;
import org.jahia.settings.SettingsBean;
import org.kie.internal.utils.CompositeClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class RulesListener
extends DefaultEventListener
implements DisposableBean {
    private static Logger logger = LoggerFactory.getLogger(RulesListener.class);
    private static List<RulesListener> instances = new ArrayList<RulesListener>();
    private Timer rulesTimer = new Timer("rules-timer", true);
    String name;
    private RuleBase ruleBase;
    ReentrantReadWriteLock ruleBaseLock = new ReentrantReadWriteLock();
    Lock ruleBaseWriteLock = this.ruleBaseLock.writeLock();
    Lock ruleBaseReadLock = this.ruleBaseLock.readLock();
    private long lastInit = 0L;
    private static final int UPDATE_DELAY_FOR_LOCKED_NODE = 2000;
    private Set<String> ruleFiles;
    private ThreadLocal<Boolean> inRules = new ThreadLocal();
    private List<Resource> dslFiles;
    private Map<String, Object> globalObjects;
    private List<String> filesAccepted;
    private Map<String, Collection<String>> modulePackageNameMap;
    private CompositeClassLoader ruleBaseClassLoader;
    private Map<String, Map<String, Set<String>>> disabledRules;
    private RuleBaseConfiguration conf;

    public RulesListener() {
        instances.add(this);
        this.dslFiles = new CopyOnWriteArrayList<Resource>();
        this.globalObjects = new ConcurrentHashMap<String, Object>();
        this.inRules = new ThreadLocal();
        this.modulePackageNameMap = new ConcurrentHashMap<String, Collection<String>>();
    }

    public static RulesListener getInstance(String workspace) {
        for (RulesListener instance : instances) {
            if (!instance.workspace.equals(workspace)) continue;
            return instance;
        }
        return null;
    }

    @Override
    public int getEventTypes() {
        return 63;
    }

    private StatelessSession getStatelessSession(Map<String, Object> globals) {
        StatelessSession session = this.ruleBase.newStatelessSession();
        for (Map.Entry<String, Object> entry : globals.entrySet()) {
            session.setGlobal(entry.getKey(), entry.getValue());
        }
        return session;
    }

    public void executeRules(Object fact, Map<String, Object> globals) {
        this.ruleBaseReadLock.lock();
        try {
            this.getStatelessSession(globals).execute(fact);
        }
        finally {
            this.ruleBaseReadLock.unlock();
        }
    }

    public void executeRules(Object[] facts, Map<String, Object> globals) {
        this.ruleBaseReadLock.lock();
        try {
            this.getStatelessSession(globals).execute(facts);
        }
        finally {
            this.ruleBaseReadLock.unlock();
        }
    }

    public void executeRules(Collection<?> facts, Map<String, Object> globals) {
        this.ruleBaseReadLock.lock();
        try {
            this.getStatelessSession(globals).execute(facts);
        }
        finally {
            this.ruleBaseReadLock.unlock();
        }
    }

    public void setRuleFiles(Set<String> ruleFiles) {
        this.ruleFiles = ruleFiles;
    }

    public void start() throws Exception {
        this.ruleBaseClassLoader = new CompositeClassLoader();
        this.ruleBaseClassLoader.setCachingEnabled(true);
        this.ruleBaseClassLoader.addClassLoader(this.getClass().getClassLoader());
        this.conf = new RuleBaseConfiguration(new ClassLoader[]{this.ruleBaseClassLoader});
        this.initCoreSystemRules();
    }

    private void initCoreSystemRules() {
        this.dslFiles.add((Resource)new FileSystemResource(SettingsBean.getInstance().getJahiaEtcDiskPath() + "/repository/rules/rules.dsl"));
        this.addRules(this.ruleFiles.stream().map(s -> new FileSystemResource(SettingsBean.getInstance().getJahiaEtcDiskPath() + s)).collect(Collectors.toList()), null);
        this.lastInit = System.currentTimeMillis();
    }

    private RuleBase rebuildRuleBase(Collection<String> packageToRemove, Collection<Package> packageToAdd) {
        RuleBase newRuleBase = RuleBaseFactory.newRuleBase((RuleBaseConfiguration)this.conf);
        if (this.ruleBase != null) {
            newRuleBase.addPackages((Package[])Arrays.stream(this.ruleBase.getPackages()).filter(rulePackage -> packageToRemove == null || !packageToRemove.contains(rulePackage.getName())).toArray(Package[]::new));
        }
        if (packageToAdd != null) {
            newRuleBase.addPackages(packageToAdd.toArray(new Package[0]));
        }
        return newRuleBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRuleBasePackage(JahiaTemplatesPackage jahiaTemplatesPackage, Collection<Package> rulePackages) {
        this.ruleBaseWriteLock.lock();
        try {
            for (Package rulePackage : rulePackages) {
                this.applyDisabledRulesConfiguration(rulePackage);
            }
            List<String> packageNames = rulePackages.stream().map(Package::getName).collect(Collectors.toList());
            if (jahiaTemplatesPackage != null) {
                this.addClassLoader(jahiaTemplatesPackage);
                this.modulePackageNameMap.computeIfAbsent(jahiaTemplatesPackage.getIdWithVersion(), s -> new ArrayList()).addAll(packageNames);
            }
            this.ruleBase = this.rebuildRuleBase(packageNames, rulePackages);
            logger.info("Rules package: {} added to runtime rule engine for {}", packageNames, (Object)this.name);
        }
        finally {
            this.ruleBaseWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRuleBasePackage(JahiaTemplatesPackage jahiaTemplatesPackage) {
        this.ruleBaseWriteLock.lock();
        try {
            boolean classLoaderRemoved = this.removeClassLoader(jahiaTemplatesPackage);
            Collection<String> rulePackageNamesToRemove = this.modulePackageNameMap.remove(jahiaTemplatesPackage.getIdWithVersion());
            if (classLoaderRemoved && rulePackageNamesToRemove != null) {
                this.ruleBase = this.rebuildRuleBase(rulePackageNamesToRemove, null);
                logger.info("Rules package: {} removed from runtime rule engine for {}", rulePackageNamesToRemove, (Object)this.name);
            }
        }
        finally {
            this.ruleBaseWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDslFiles() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        for (Resource dslFile : this.dslFiles) {
            InputStream dslFileInputStream = null;
            try {
                dslFileInputStream = dslFile.getInputStream();
                stringBuilder.append(IOUtils.toString((InputStream)dslFileInputStream, (String)"UTF-8")).append("\n");
            }
            finally {
                IOUtils.closeQuietly((InputStream)dslFileInputStream);
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Package recoverCompiledRules(File compiledRulesFile, Resource dsrlFile, ClassLoader packageClassLoader) throws IOException, ClassNotFoundException {
        Package rulePackage = null;
        if (compiledRulesFile.exists() && compiledRulesFile.lastModified() > dsrlFile.lastModified()) {
            DroolsObjectInputStream ois = null;
            try {
                ois = new DroolsObjectInputStream((InputStream)new FileInputStream(compiledRulesFile), packageClassLoader);
                rulePackage = new Package();
                rulePackage.readExternal((ObjectInput)ois);
                logger.info("Rules package: {} from file: {} reloaded from previous compilation for {}", new Object[]{rulePackage.getName(), dsrlFile.getURI(), this.name});
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(ois, null);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)ois, null);
        }
        return rulePackage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Package compileRules(File compiledRulesFile, Resource dsrlFile, ClassLoader packageClassLoader) throws IOException, DroolsParserException {
        List lines;
        long start = System.currentTimeMillis();
        InputStream drlInputStream = dsrlFile.getInputStream();
        try {
            lines = IOUtils.readLines((InputStream)drlInputStream, (Charset)Charset.defaultCharset());
        }
        finally {
            IOUtils.closeQuietly((Closeable)drlInputStream, null);
        }
        StringBuilder drl = new StringBuilder(4096);
        for (String line : lines) {
            if (drl.length() > 0) {
                drl.append("\n");
            }
            if (line.trim().length() > 0 && line.trim().charAt(0) == '#') {
                drl.append(StringUtils.replaceOnce((String)line, (String)"#", (String)"//"));
                continue;
            }
            drl.append(line);
        }
        PackageBuilderConfiguration cfg = packageClassLoader != null ? new PackageBuilderConfiguration(new ClassLoader[]{packageClassLoader}) : new PackageBuilderConfiguration();
        PackageBuilder builder = new PackageBuilder(cfg);
        StringReader drlReader = new StringReader(drl.toString());
        try {
            builder.addPackageFromDrl((Reader)drlReader, (Reader)new StringReader(this.getDslFiles()));
        }
        finally {
            IOUtils.closeQuietly((Closeable)drlReader, null);
        }
        PackageBuilderErrors errors = builder.getErrors();
        if (errors.getErrors().length == 0) {
            Package rulePackage = builder.getPackage();
            DroolsObjectOutputStream oos = null;
            try {
                compiledRulesFile.getParentFile().mkdirs();
                oos = new DroolsObjectOutputStream((OutputStream)new FileOutputStream(compiledRulesFile));
                rulePackage.writeExternal((ObjectOutput)oos);
                IOUtils.closeQuietly((Closeable)oos, null);
            }
            catch (IOException e) {
                logger.error("Error writing rule package to file {}", (Object)compiledRulesFile, (Object)e);
            }
            finally {
                IOUtils.closeQuietly(oos, null);
            }
            logger.info("Rules package: {} from file: {} compiled in {}ms for {}", new Object[]{rulePackage.getName(), dsrlFile.getURI(), System.currentTimeMillis() - start, this.name});
            return rulePackage;
        }
        throw new RuntimeException("Errors when compiling rules in " + String.valueOf(dsrlFile) + " : " + errors.toString());
    }

    public void addRules(File dsrlFile) {
        this.addRules((Resource)(dsrlFile == null ? null : new FileSystemResource(dsrlFile)), null);
    }

    public void addRules(Resource dsrlFiles, JahiaTemplatesPackage jahiaTemplatesPackage) {
        this.addRules(Collections.singleton(dsrlFiles), jahiaTemplatesPackage);
    }

    public void addRules(Collection<Resource> dsrlFiles, JahiaTemplatesPackage jahiaTemplatesPackage) {
        File compiledRulesDir = new File(SettingsBean.getInstance().getJahiaVarDiskPath() + "/compiledRules", jahiaTemplatesPackage != null ? jahiaTemplatesPackage.getIdWithVersion() : "system");
        if (!compiledRulesDir.exists()) {
            compiledRulesDir.mkdirs();
        }
        Collection rulesPackage = dsrlFiles.stream().map(dsrlFile -> {
            try {
                ClassLoader packageClassLoader = jahiaTemplatesPackage != null ? jahiaTemplatesPackage.getClassLoader() : null;
                File compileRulesFile = new File(compiledRulesDir, StringUtils.substringAfterLast((String)dsrlFile.getURL().getPath(), (String)"/") + ".pkg");
                Package rulePackage = this.recoverCompiledRules(compileRulesFile, (Resource)dsrlFile, packageClassLoader);
                if (rulePackage == null) {
                    rulePackage = this.compileRules(compileRulesFile, (Resource)dsrlFile, packageClassLoader);
                }
                return rulePackage;
            }
            catch (IOException | ClassNotFoundException | DroolsParserException e) {
                logger.error(e.getMessage(), e);
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        this.addRuleBasePackage(jahiaTemplatesPackage, rulesPackage);
    }

    private void addClassLoader(JahiaTemplatesPackage aPackage) {
        ArrayList classLoadersToRemove = new ArrayList();
        this.ruleBaseClassLoader.getClassLoaders().forEach(classLoader -> {
            if (classLoader instanceof BundleDelegatingClassLoader && StringUtils.equals((String)((BundleDelegatingClassLoader)classLoader).getBundle().getSymbolicName(), (String)aPackage.getName())) {
                classLoadersToRemove.add(classLoader);
            }
        });
        classLoadersToRemove.forEach(arg_0 -> ((CompositeClassLoader)this.ruleBaseClassLoader).removeClassLoader(arg_0));
        this.ruleBaseClassLoader.addClassLoaderToEnd(aPackage.getClassLoader());
    }

    private boolean removeClassLoader(JahiaTemplatesPackage aPackage) {
        ClassLoader classLoaderToRemove = aPackage.getClassLoader();
        if (classLoaderToRemove == null) {
            for (ClassLoader classLoader : this.ruleBaseClassLoader.getClassLoaders()) {
                if (!(classLoader instanceof BundleDelegatingClassLoader) || aPackage.getBundle().getBundleId() != ((BundleDelegatingClassLoader)classLoader).getBundle().getBundleId()) continue;
                classLoaderToRemove = classLoader;
                break;
            }
        }
        if (classLoaderToRemove != null) {
            this.ruleBaseClassLoader.removeClassLoader(classLoaderToRemove);
            return true;
        }
        return false;
    }

    private long lastModified() {
        long last = 0L;
        for (String s : this.ruleFiles) {
            last = Math.max(last, new File(SettingsBean.getInstance().getJahiaEtcDiskPath() + s).lastModified());
        }
        return last;
    }

    public void onEvent(final EventIterator eventIterator) {
        final int operationType = ((JCREventIterator)eventIterator).getOperationType();
        final JCRSessionWrapper session = ((JCREventIterator)eventIterator).getSession();
        final String userId = session.getUser() != null ? session.getUser().getName() : null;
        final String userRealm = session.getUser() != null ? session.getUser().getRealm() : null;
        Locale locale = session.getLocale();
        final HashMap eventsMap = new HashMap();
        if (Boolean.TRUE.equals(this.inRules.get())) {
            return;
        }
        if (this.ruleBase == null) {
            return;
        }
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(session.getUser(), this.workspace, locale, new JCRCallback<Object>(){
                Map<String, String> copies = null;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object doInJCR(JCRSessionWrapper s) throws RepositoryException {
                    ArrayList<Object> list = new ArrayList<Object>();
                    String nodeFactOperationType = RulesListener.this.getNodeFactOperationType(operationType);
                    while (eventIterator.hasNext()) {
                        Event event = eventIterator.nextEvent();
                        String path = event.getPath();
                        try {
                            JCRNodeWrapper n;
                            NodeFact e;
                            JCRSiteNode resolveSite;
                            if (path.startsWith("/jcr:system/")) continue;
                            String eventUuid = event.getIdentifier();
                            int type = event.getType();
                            if (type == 1) {
                                JCRNodeWrapper n2 = eventUuid != null ? s.getNodeByIdentifier(eventUuid) : s.getNode(path);
                                if (!n2.isNodeType("jmix:observable") || n2.isNodeType("jnt:translation")) continue;
                                String identifier = n2.getIdentifier();
                                AddedNodeFact rn = (AddedNodeFact)eventsMap.get(identifier);
                                if (rn == null) {
                                    rn = this.getFact(n2, session);
                                    rn.setOperationType(nodeFactOperationType);
                                    JCRSiteNode resolveSite2 = n2.getResolveSite();
                                    if (resolveSite2 != null) {
                                        rn.setInstalledModules(resolveSite2.getAllInstalledModules());
                                    } else {
                                        rn.setInstalledModules(new ArrayList<String>());
                                    }
                                    eventsMap.put(identifier, rn);
                                }
                                list.add(rn);
                                continue;
                            }
                            if (type == 4 || type == 16) {
                                JCRNodeWrapper n3;
                                JCRSiteNode resolveSite3;
                                String propertyName = path.substring(path.lastIndexOf(47) + 1);
                                if (!RulesListener.this.propertiesToIgnore.contains(propertyName)) {
                                    try {
                                        AddedNodeFact rn;
                                        JCRPropertyWrapper p = RulesListener.this.getProperty(s, path, eventUuid, propertyName);
                                        JCRNodeWrapper parent = p.getParent();
                                        if (parent.isNodeType("jnt:translation")) {
                                            parent = parent.getParent();
                                        }
                                        if (!parent.isNodeType("nt:resource") && !parent.isNodeType("jmix:observable")) continue;
                                        if (parent.isNodeType("mix:referenceable")) {
                                            String identifier = parent.getIdentifier();
                                            rn = (AddedNodeFact)eventsMap.get(identifier);
                                            if (rn == null) {
                                                rn = type == 4 ? this.getFact(parent, session) : new AddedNodeFact(parent);
                                                rn.setOperationType(nodeFactOperationType);
                                                resolveSite3 = parent.getResolveSite();
                                                if (resolveSite3 != null) {
                                                    rn.setInstalledModules(resolveSite3.getAllInstalledModules());
                                                } else {
                                                    rn.setInstalledModules(new ArrayList<String>());
                                                }
                                                eventsMap.put(identifier, rn);
                                            }
                                        } else {
                                            rn = new AddedNodeFact(parent);
                                            rn.setOperationType(nodeFactOperationType);
                                            resolveSite = parent.getResolveSite();
                                            if (resolveSite != null) {
                                                rn.setInstalledModules(resolveSite.getAllInstalledModules());
                                            } else {
                                                rn.setInstalledModules(new ArrayList<String>());
                                            }
                                        }
                                        list.add(new ChangedPropertyFact(rn, p));
                                    }
                                    catch (PathNotFoundException pnfe) {
                                        if (JCRSessionFactory.getInstance().getProvider(path, false) != null && !logger.isDebugEnabled()) continue;
                                        logger.error("Couldn't access path {}, ignoring it.", (Throwable)pnfe);
                                    }
                                    continue;
                                }
                                if (!propertyName.equals("j:published") || !(n3 = eventUuid != null ? s.getNodeByIdentifier(eventUuid) : s.getNode(path)).isNodeType("jmix:observable")) continue;
                                JCRPropertyWrapper p = RulesListener.this.getProperty(s, path, eventUuid, propertyName);
                                String language = null;
                                if (n3.isNodeType("jnt:translation")) {
                                    language = n3.getLanguage();
                                    n3 = n3.getParent();
                                }
                                e = new PublishedNodeFact(n3, language, !p.getBoolean());
                                ((AbstractNodeFact)e).setOperationType(nodeFactOperationType);
                                resolveSite3 = n3.getResolveSite();
                                if (resolveSite3 != null) {
                                    ((AbstractNodeFact)e).setInstalledModules(resolveSite3.getAllInstalledModules());
                                } else {
                                    ((AbstractNodeFact)e).setInstalledModules(new ArrayList<String>());
                                }
                                list.add(e);
                                continue;
                            }
                            if (type == 2) {
                                String parentPath = null;
                                try {
                                    parentPath = StringUtils.substringBeforeLast((String)path, (String)"/");
                                    JCRNodeWrapper parent = s.getNode(parentPath);
                                    String identifier = parent.getIdentifier();
                                    AddedNodeFact w = (AddedNodeFact)eventsMap.get(identifier);
                                    if (w == null) {
                                        w = new AddedNodeFact(parent);
                                        w.setOperationType(nodeFactOperationType);
                                        resolveSite = parent.getResolveSite();
                                        if (resolveSite != null) {
                                            w.setInstalledModules(resolveSite.getAllInstalledModules());
                                        } else {
                                            w.setInstalledModules(new ArrayList<String>());
                                        }
                                        eventsMap.put(identifier, w);
                                    }
                                    e = new DeletedNodeFact(w, path);
                                    ((DeletedNodeFact)e).setIdentifier(eventUuid);
                                    ((DeletedNodeFact)e).setSession(s);
                                    ((DeletedNodeFact)e).setOperationType(nodeFactOperationType);
                                    ((DeletedNodeFact)e).setTypes(JCRObservationManager.getNodeTypesForDeletedNode(event));
                                    list.add(e);
                                }
                                catch (PathNotFoundException e2) {
                                    logger.debug("Unable to find parent node for path: " + parentPath + ". The parent has also been deleted", (Throwable)e2);
                                    DeletedSubNodeFact deletedSubNodeFact = new DeletedSubNodeFact(path);
                                    deletedSubNodeFact.setIdentifier(eventUuid);
                                    deletedSubNodeFact.setSession(s);
                                    deletedSubNodeFact.setOperationType(nodeFactOperationType);
                                    deletedSubNodeFact.setTypes(JCRObservationManager.getNodeTypesForDeletedNode(event));
                                    list.add(deletedSubNodeFact);
                                }
                                continue;
                            }
                            if (type == 8) {
                                int index = path.lastIndexOf(47);
                                String nodePath = path.substring(0, index);
                                String propertyName = path.substring(index + 1);
                                if (RulesListener.this.propertiesToIgnore.contains(propertyName)) continue;
                                try {
                                    JCRNodeWrapper n4 = s.getNode(nodePath);
                                    String key = n4.isNodeType("mix:referenceable") ? n4.getIdentifier() : n4.getPath();
                                    AddedNodeFact rn = (AddedNodeFact)eventsMap.get(key);
                                    if (rn == null) {
                                        rn = new AddedNodeFact(n4);
                                        rn.setOperationType(nodeFactOperationType);
                                        JCRSiteNode resolveSite4 = n4.getResolveSite();
                                        if (resolveSite4 != null) {
                                            rn.setInstalledModules(resolveSite4.getAllInstalledModules());
                                        } else {
                                            rn.setInstalledModules(new ArrayList<String>());
                                        }
                                        eventsMap.put(key, rn);
                                    }
                                    list.add(new DeletedPropertyFact(rn, propertyName));
                                }
                                catch (PathNotFoundException pathNotFoundException) {}
                                continue;
                            }
                            if (type != 32 || !(n = eventUuid != null ? s.getNodeByIdentifier(eventUuid) : s.getNode(path)).isNodeType("jmix:observable") || n.isNodeType("jnt:translation")) continue;
                            MovedNodeFact e3 = new MovedNodeFact(n, (String)event.getInfo().get("srcAbsPath"));
                            e3.setOperationType(nodeFactOperationType);
                            JCRSiteNode resolveSite5 = n.getResolveSite();
                            if (resolveSite5 != null) {
                                e3.setInstalledModules(resolveSite5.getAllInstalledModules());
                            } else {
                                e3.setInstalledModules(new ArrayList<String>());
                            }
                            list.add(e3);
                        }
                        catch (PathNotFoundException pnfe) {
                            logger.debug("Error when executing event. Unable to find node or property for path: " + path, (Throwable)pnfe);
                        }
                        catch (ItemNotFoundException infe) {
                            logger.debug("Error when executing event. Unable to find node or property for item: " + event.getIdentifier(), (Throwable)infe);
                        }
                        catch (Exception e) {
                            logger.error("Error when executing event", (Throwable)e);
                        }
                    }
                    if (!list.isEmpty()) {
                        long time = System.currentTimeMillis();
                        if (logger.isDebugEnabled()) {
                            if (list.size() > 3) {
                                logger.debug("Executing rules for " + String.valueOf(list.subList(0, 3)) + " ... and " + (list.size() - 3) + " other nodes");
                            } else {
                                logger.debug("Executing rules for " + String.valueOf(list));
                            }
                        }
                        ArrayList<Updateable> delayedUpdates = new ArrayList<Updateable>();
                        Map<String, Object> globals = RulesListener.this.getGlobals(userId, userRealm, delayedUpdates);
                        try {
                            RulesListener.this.inRules.set(Boolean.TRUE);
                            list.add(new OperationTypeFact(nodeFactOperationType));
                            RulesListener.this.executeRules(list, globals);
                            if (list.size() > 3) {
                                logger.info("Rules executed for " + RulesListener.this.workspace + " " + String.valueOf(list.subList(0, 3)) + " ... and " + (list.size() - 3) + " other nodes in " + (System.currentTimeMillis() - time) + "ms");
                            } else {
                                logger.info("Rules executed for " + RulesListener.this.workspace + " " + String.valueOf(list) + " in " + (System.currentTimeMillis() - time) + "ms");
                            }
                            if (s.hasPendingChanges()) {
                                s.save();
                            }
                        }
                        finally {
                            RulesListener.this.inRules.set(null);
                        }
                        if (!delayedUpdates.isEmpty()) {
                            DelayedUpdatesTimerTask t = new DelayedUpdatesTimerTask(userId, userRealm, delayedUpdates, globals);
                            RulesListener.this.rulesTimer.schedule((TimerTask)t, 2000L);
                        }
                    }
                    return null;
                }

                private AddedNodeFact getFact(JCRNodeWrapper node, JCRSessionWrapper session2) throws RepositoryException {
                    if (this.copies == null) {
                        this.copies = session2.getUuidMapping().isEmpty() ? Collections.emptyMap() : MapUtils.invertMap(session2.getUuidMapping());
                    }
                    String sourceUuid = !this.copies.isEmpty() ? this.copies.get(node.getIdentifier()) : null;
                    return sourceUuid != null ? new CopiedNodeFact(node, sourceUuid, session2.getUuidMapping().containsKey("top-" + sourceUuid)) : new AddedNodeFact(node);
                }
            });
        }
        catch (Exception e) {
            logger.error("Error when executing event", (Throwable)e);
        }
    }

    private JCRPropertyWrapper getProperty(JCRSessionWrapper s, String path, String eventUuid, String propertyName) throws RepositoryException {
        JCRPropertyWrapper p = null;
        try {
            p = (JCRPropertyWrapper)s.getItem(path);
        }
        catch (ClassCastException | PathNotFoundException e) {
            try {
                p = s.getNodeByIdentifier(eventUuid).getProperty(propertyName);
            }
            catch (RepositoryException infe) {
                throw e;
            }
        }
        return p;
    }

    public Map<String, Object> getGlobals(String username, String userRealm, List<Updateable> delayedUpdates) {
        HashMap<String, Object> globals = new HashMap<String, Object>();
        globals.put("logger", logger);
        globals.put("user", new User(username, userRealm));
        globals.put("workspace", this.workspace);
        globals.put("delayedUpdates", delayedUpdates);
        for (Map.Entry<String, Object> entry : this.globalObjects.entrySet()) {
            globals.put(entry.getKey(), entry.getValue());
        }
        return globals;
    }

    public void addRulesDescriptor(File file) {
        this.dslFiles.add((Resource)(file == null ? null : new FileSystemResource(file)));
    }

    public void addRulesDescriptor(Resource resource) {
        this.dslFiles.add(resource);
    }

    public void addRulesDescriptor(Resource resource, JahiaTemplatesPackage aPackage) {
        ClassLoader packageClassLoader;
        this.dslFiles.add(resource);
        ClassLoader classLoader = packageClassLoader = aPackage != null ? aPackage.getClassLoader() : null;
        if (packageClassLoader != null) {
            this.addClassLoader(aPackage);
        }
    }

    public void setGlobalObjects(Map<String, Object> globalObjects) {
        this.globalObjects = globalObjects;
    }

    public void addGlobalObject(String key, Object value) {
        this.globalObjects.put(key, value);
    }

    public void removeGlobalObject(String key) {
        this.globalObjects.remove(key);
    }

    public static List<RulesListener> getInstances() {
        return instances;
    }

    public List<String> getFilesAccepted() {
        return this.filesAccepted;
    }

    public void setFilesAccepted(List<String> fileAccepted) {
        this.filesAccepted = fileAccepted;
    }

    String getNodeFactOperationType(int operationType) {
        if (operationType == 13) {
            return "import";
        }
        if (operationType == 1) {
            return "session";
        }
        if (operationType == 4) {
            return "clone";
        }
        return null;
    }

    public void destroy() throws Exception {
        if (this.rulesTimer != null) {
            try {
                this.rulesTimer.cancel();
            }
            catch (Exception e) {
                logger.warn("Error terminating timer thread", (Throwable)e);
            }
        }
    }

    public void removeRules(JahiaTemplatesPackage module) {
        this.removeRuleBasePackage(module);
    }

    public boolean removeRulesDescriptor(Resource resource) {
        return this.dslFiles.remove(resource);
    }

    public Map<String, Collection<String>> getModulePackageNameMap() {
        return this.modulePackageNameMap;
    }

    public void setDisabledRules(String rulesToDisable) {
        if (StringUtils.isBlank((String)rulesToDisable)) {
            this.disabledRules = null;
            return;
        }
        String[] disabledRulesConfig = StringUtils.strip((String)rulesToDisable, (String)"\"").split("\"\\s*\\,\\s*\"");
        if (disabledRulesConfig == null) {
            this.disabledRules = null;
            return;
        }
        HashMap<String, Map<String, Set<String>>> disabledRulesFromConfig = new HashMap<String, Map<String, Set<String>>>();
        for (String ruleCfg : disabledRulesConfig) {
            HashSet<String> rulesForPackage;
            String[] cfg = StringUtils.splitByWholeSeparator((String)ruleCfg, (String)"\".\"");
            String workspace = cfg.length == 3 ? cfg[0] : null;
            String pkg = cfg[workspace != null ? 1 : 0];
            String rule = cfg[workspace != null ? 2 : 1];
            HashMap<String, HashSet<String>> rulesForWorkspace = (HashMap<String, HashSet<String>>)disabledRulesFromConfig.get(workspace);
            if (rulesForWorkspace == null) {
                rulesForWorkspace = new HashMap<String, HashSet<String>>();
                disabledRulesFromConfig.put(workspace, rulesForWorkspace);
            }
            if ((rulesForPackage = (HashSet<String>)rulesForWorkspace.get(pkg)) == null) {
                rulesForPackage = new HashSet<String>();
                rulesForWorkspace.put(pkg, rulesForPackage);
            }
            rulesForPackage.add(rule);
        }
        this.disabledRules = disabledRulesFromConfig;
        logger.info("The following rules are configured to be disabled: {}", this.disabledRules);
    }

    private boolean isRuleDisabled(String packageName, String ruleName) {
        if (this.disabledRules == null) {
            return false;
        }
        Map<String, Set<String>> rulesForWorkspace = this.disabledRules.get(this.getWorkspace());
        if (rulesForWorkspace != null && rulesForWorkspace.containsKey(packageName) && rulesForWorkspace.get(packageName).contains(ruleName)) {
            return true;
        }
        rulesForWorkspace = this.disabledRules.get(null);
        return rulesForWorkspace != null && rulesForWorkspace.containsKey(packageName) && rulesForWorkspace.get(packageName).contains(ruleName);
    }

    private void applyDisabledRulesConfiguration(Package pkg) {
        if (this.disabledRules == null) {
            return;
        }
        for (Rule r : pkg.getRules()) {
            if (!this.isRuleDisabled(pkg.getName(), r.getName())) continue;
            r.setEnabled(EnabledBoolean.ENABLED_FALSE);
            logger.info("Rule \"{}\" from package \"{}\" in workspace \"{}\" has been disabled by configuration", (Object[])new String[]{r.getName(), pkg.getName(), this.getWorkspace()});
        }
    }

    public RuleBase getRuleBase() {
        return this.ruleBase;
    }

    public void setName(String name) {
        this.name = name;
    }

    class DelayedUpdatesTimerTask
    extends TimerTask {
        private String username;
        private String userRealm;
        private List<Updateable> updates;
        private int count = 1;
        private Map<String, Object> globals;

        DelayedUpdatesTimerTask(String username, String userRealm, List<Updateable> updates, Map<String, Object> globals) {
            this.username = username;
            this.userRealm = userRealm;
            this.updates = updates;
            this.globals = globals;
        }

        DelayedUpdatesTimerTask(String username, String userRealm, List<Updateable> updates, Map<String, Object> globals, int count) {
            this.username = username;
            this.userRealm = userRealm;
            this.updates = updates;
            this.count = count;
            this.globals = globals;
        }

        @Override
        public void run() {
            try {
                JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Object>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Object doInJCR(JCRSessionWrapper s) throws RepositoryException {
                        RulesListener.this.inRules.set(Boolean.TRUE);
                        try {
                            ArrayList<Updateable> newDelayed = new ArrayList<Updateable>();
                            ArrayList<Object> newFacts = new ArrayList<Object>();
                            for (Updateable p : DelayedUpdatesTimerTask.this.updates) {
                                if (p instanceof UpdateableWithNewFacts) {
                                    ((UpdateableWithNewFacts)p).doUpdate(s, newDelayed, newFacts);
                                    continue;
                                }
                                p.doUpdate(s, newDelayed);
                            }
                            s.save();
                            if (!newFacts.isEmpty()) {
                                RulesListener.this.executeRules(newFacts, DelayedUpdatesTimerTask.this.globals);
                            }
                            if (!newDelayed.isEmpty()) {
                                DelayedUpdatesTimerTask.this.updates = newDelayed;
                                if (DelayedUpdatesTimerTask.this.count < 3) {
                                    RulesListener.this.rulesTimer.schedule((TimerTask)new DelayedUpdatesTimerTask(DelayedUpdatesTimerTask.this.username, DelayedUpdatesTimerTask.this.userRealm, newDelayed, DelayedUpdatesTimerTask.this.globals, DelayedUpdatesTimerTask.this.count + 1), 2000 * DelayedUpdatesTimerTask.this.count);
                                } else {
                                    logger.error("Node still locked, max count reached, forget pending changes");
                                }
                            }
                        }
                        finally {
                            RulesListener.this.inRules.set(null);
                        }
                        return null;
                    }
                });
            }
            catch (Exception e) {
                logger.error("Cannot set property", (Throwable)e);
            }
        }
    }
}

