/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.events;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import org.apache.jackrabbit.api.observation.JackrabbitEvent;
import org.apache.jackrabbit.commons.iterator.EventIteratorAdapter;
import org.apache.jackrabbit.commons.iterator.FilteredRangeIterator;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.observation.EventState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.commons.AdditionalEventInfo;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FilteredEventIterator
extends EventIteratorAdapter {
    private final SessionImpl session;
    private final long timestamp;
    private final String userData;

    FilteredEventIterator(SessionImpl session, Iterator<EventState> eventStates, long timestamp, String userData, int eventTypes) {
        super((RangeIterator)new FilteredRangeIterator(eventStates, state -> (eventTypes & ((EventState)state).getType()) != 0));
        this.session = session;
        this.timestamp = timestamp;
        this.userData = userData;
    }

    public Object next() {
        return new JCREvent(this.session, (EventState)super.next(), this.timestamp, this.userData);
    }

    static class JCREvent
    implements JackrabbitEvent,
    AdditionalEventInfo,
    Event {
        private static final Logger log = LoggerFactory.getLogger(JCREvent.class);
        private final EventState eventState;
        private final SessionImpl session;
        private String stringValue;
        private final long timestamp;
        private final String userData;

        private static boolean equals(Object o1, Object o2) {
            if (o1 == null) {
                return o2 == null;
            }
            return o1.equals(o2);
        }

        JCREvent(SessionImpl session, EventState eventState, long timestamp, String userData) {
            this.session = session;
            this.eventState = eventState;
            this.timestamp = timestamp;
            this.userData = userData;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof JCREvent) {
                JCREvent other = (JCREvent)obj;
                return this.eventState.equals((Object)other.eventState) && this.session.equals(other.session) && this.timestamp == other.timestamp && JCREvent.equals(this.userData, other.userData);
            }
            return false;
        }

        public NodeId getChildId() {
            return this.eventState.getChildId();
        }

        public long getDate() {
            return this.timestamp;
        }

        public String getIdentifier() throws RepositoryException {
            if (this.eventState.getType() == 64) {
                return null;
            }
            NodeId id = this.eventState.getChildId();
            if (id != null) {
                return id.toString();
            }
            return this.eventState.getParentId().toString();
        }

        public Map<String, String> getInfo() throws RepositoryException {
            HashMap<String, String> info = new HashMap<String, String>();
            for (Map.Entry entry : this.eventState.getInfo().entrySet()) {
                InternalValue value = (InternalValue)entry.getValue();
                String strValue = null;
                if (value != null) {
                    strValue = ValueFormat.getJCRString((QValue)value, (NamePathResolver)this.session);
                }
                info.put((String)entry.getKey(), strValue);
            }
            return info;
        }

        public Set<Name> getMixinTypeNames() {
            return this.eventState.getMixinNames();
        }

        public NodeId getParentId() {
            return this.eventState.getParentId();
        }

        public String getPath() throws RepositoryException {
            Path p = this.getQPath();
            return p != null ? this.session.getJCRPath(p) : null;
        }

        public Name getPrimaryNodeTypeName() {
            return this.eventState.getNodeType();
        }

        public Path getQPath() throws RepositoryException {
            try {
                Path parent = this.eventState.getParentPath();
                Path child = this.eventState.getChildRelPath();
                if (parent == null || child == null) {
                    return null;
                }
                int index = child.getIndex();
                if (index > 0) {
                    return PathFactoryImpl.getInstance().create(parent, child.getName(), index, false);
                }
                return PathFactoryImpl.getInstance().create(parent, child.getName(), false);
            }
            catch (MalformedPathException e) {
                String msg = "internal error: malformed path for event";
                log.debug(msg);
                throw new RepositoryException(msg, (Throwable)e);
            }
        }

        public Object getSessionAttribute(String name) {
            return this.session.getAttribute(name);
        }

        public int getType() {
            return this.eventState.getType();
        }

        public String getUserData() {
            return this.userData;
        }

        public String getUserID() {
            return this.eventState.getUserId();
        }

        public int hashCode() {
            int h = this.eventState.hashCode() ^ Long.hashCode(this.timestamp) ^ this.session.hashCode();
            if (this.userData != null) {
                h ^= this.userData.hashCode();
            }
            return h;
        }

        public boolean isExternal() {
            throw new UnsupportedOperationException();
        }

        public boolean isShareableChildNode() {
            return false;
        }

        public String toString() {
            if (this.stringValue == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("Event: Path: ");
                try {
                    sb.append(this.getPath());
                }
                catch (RepositoryException e) {
                    log.error("Exception retrieving path: " + String.valueOf((Object)e));
                    sb.append("[Error retrieving path]");
                }
                sb.append(", ").append(EventState.valueOf((int)this.getType())).append(": ");
                sb.append(", UserId: ").append(this.getUserID());
                sb.append(", Timestamp: ").append(this.timestamp);
                sb.append(", UserData: ").append(this.userData);
                sb.append(", Info: ").append(this.eventState.getInfo());
                this.stringValue = sb.toString();
            }
            return this.stringValue;
        }
    }
}

