/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.history;

import java.io.Writer;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.version.InternalVersionHistory;
import org.apache.jackrabbit.core.version.InternalVersionManager;
import org.apache.jackrabbit.core.version.InternalVersionManagerImpl;
import org.apache.jackrabbit.core.version.InternalXAVersionManager;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.history.OrphanedVersionHistoryCheckStatus;
import org.jahia.services.history.OrphanedVersionHistoryChecker;
import org.jahia.services.history.UnusedVersionCheckStatus;
import org.jahia.services.history.UnusedVersionChecker;
import org.jahia.services.history.VersionHistoryCheckStatus;
import org.jahia.tools.OutWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeVersionHistoryHelper {
    private static boolean checkingOrphans;
    private static boolean checkingUnused;
    private static final Logger logger;
    private static OrphanedVersionHistoryChecker orphanedChecker;
    protected static final int PURGE_HISTORY_CHUNK;
    private static final String DATA_NODE_NAME = "unusedVersionChecker";
    private static final String LAST_CHECKED_ID_PROPERTY = "lastCheckedNodeId";
    private static UnusedVersionChecker unusedChecker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized OrphanedVersionHistoryCheckStatus checkOrphaned(long maxOrphans, boolean deleteOrphans, Writer statusOut) throws RepositoryException {
        if (checkingOrphans) {
            throw new IllegalStateException("The version history is currently beeing checked for orphans. Cannot start the second process.");
        }
        checkingOrphans = true;
        long timer = System.currentTimeMillis();
        OrphanedVersionHistoryCheckStatus status = new OrphanedVersionHistoryCheckStatus();
        OutWrapper out = new OutWrapper(logger, statusOut);
        out.echo("Start {} orphaned version history", deleteOrphans ? "deleting" : "checking");
        orphanedChecker = new OrphanedVersionHistoryChecker(status, maxOrphans, deleteOrphans, out);
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Object>(){

                @Override
                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    orphanedChecker.perform(session);
                    return null;
                }
            });
        }
        finally {
            checkingOrphans = false;
            orphanedChecker = null;
            out.echo("Done checking orphaned version history in {} ms. Status: {}", System.currentTimeMillis() - timer, status.toString());
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized UnusedVersionCheckStatus checkUnused(long maxUnused, boolean deleteUnused, final long purgeOlderThanTimestamp, Writer statusOut) throws RepositoryException {
        if (checkingUnused) {
            throw new IllegalStateException("Unused versions are currently beeing checked. Cannot start the second process.");
        }
        checkingUnused = true;
        long timer = System.currentTimeMillis();
        UnusedVersionCheckStatus status = new UnusedVersionCheckStatus();
        OutWrapper out = new OutWrapper(logger, statusOut);
        out.echo("Start {} unused versions{}", deleteUnused ? "deleting" : "checking", purgeOlderThanTimestamp <= 0L ? "" : " older than " + String.valueOf(new Date(purgeOlderThanTimestamp)));
        unusedChecker = new UnusedVersionChecker(status, maxUnused, deleteUnused, out);
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Object>(){

                @Override
                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    JCRNodeWrapper data;
                    JCRNodeWrapper root = session.getRootNode();
                    NodeId lastCheckedNodeId = null;
                    if (root.hasNode(NodeVersionHistoryHelper.DATA_NODE_NAME)) {
                        data = root.getNode(NodeVersionHistoryHelper.DATA_NODE_NAME);
                        String lastCheckedNodeUuid = data.getPropertyAsString(NodeVersionHistoryHelper.LAST_CHECKED_ID_PROPERTY);
                        lastCheckedNodeId = lastCheckedNodeUuid == null ? null : NodeId.valueOf((String)lastCheckedNodeUuid);
                    }
                    lastCheckedNodeId = unusedChecker.perform(session, purgeOlderThanTimestamp, lastCheckedNodeId);
                    data = root.hasNode(NodeVersionHistoryHelper.DATA_NODE_NAME) ? root.getNode(NodeVersionHistoryHelper.DATA_NODE_NAME) : root.addNode(NodeVersionHistoryHelper.DATA_NODE_NAME, "nt:unstructured");
                    data.setProperty(NodeVersionHistoryHelper.LAST_CHECKED_ID_PROPERTY, lastCheckedNodeId == null ? null : lastCheckedNodeId.toString());
                    session.save();
                    return null;
                }
            });
        }
        finally {
            checkingUnused = false;
            unusedChecker = null;
            out.echo("Done checking unused versions in {} ms. Status: {}", System.currentTimeMillis() - timer, status.toString());
        }
        return status;
    }

    public static void forceStopOrphanedCheck() {
        if (orphanedChecker != null) {
            orphanedChecker.stop();
        }
    }

    public static void forceStopUnusedCheck() {
        if (unusedChecker != null) {
            unusedChecker.stop();
        }
    }

    static void internalPurgeVersionHistories(List<InternalVersionHistory> histories, JCRSessionWrapper session, VersionHistoryCheckStatus status) throws VersionException, RepositoryException {
        SessionImpl providerSession = (SessionImpl)session.getProviderSession(session.getNode("/").getProvider());
        InternalVersionManager vm = providerSession.getInternalVersionManager();
        int[] result = null;
        if (vm instanceof InternalVersionManagerImpl) {
            result = ((InternalVersionManagerImpl)vm).purgeVersions((Session)providerSession, histories);
        } else if (vm instanceof InternalXAVersionManager) {
            result = ((InternalXAVersionManager)vm).purgeVersions((Session)providerSession, histories);
        } else {
            logger.warn("Unknown implemmentation of the InternalVersionManager: {}.", (Object)vm.getClass().getName());
        }
        if (result != null) {
            if (!(status instanceof OrphanedVersionHistoryCheckStatus)) {
                status.checked += (long)histories.size();
            }
            status.deleted += (long)result[0];
            status.deletedVersionItems += (long)result[1];
        }
    }

    private static VersionHistoryCheckStatus internalPurgeVersionHistories(Set<String> nodeIdentifiers) {
        VersionHistoryCheckStatus status = new VersionHistoryCheckStatus();
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSession(session -> {
                SessionImpl providerSession = (SessionImpl)session.getProviderSession(session.getNode("/").getProvider());
                InternalVersionManager vm = providerSession.getInternalVersionManager();
                LinkedList<InternalVersionHistory> histories = new LinkedList<InternalVersionHistory>();
                for (String id : nodeIdentifiers) {
                    try {
                        histories.add(vm.getVersionHistoryOfNode(NodeId.valueOf((String)id)));
                    }
                    catch (ItemNotFoundException itemNotFoundException) {}
                }
                NodeVersionHistoryHelper.internalPurgeVersionHistories(histories, session, status);
                return Boolean.TRUE;
            });
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return status;
    }

    public static boolean isCheckingOrphans() {
        return checkingOrphans;
    }

    public static boolean isCheckingUnused() {
        return checkingUnused;
    }

    static void purgeUnusedVersions(List<NodeId> unusedVersions, JCRSessionWrapper session, UnusedVersionCheckStatus status) throws PathNotFoundException, RepositoryException {
        SessionImpl providerSession = (SessionImpl)session.getProviderSession(session.getNode("/").getProvider());
        InternalVersionManager vm = providerSession.getInternalVersionManager();
        int result = 0;
        if (vm instanceof InternalVersionManagerImpl) {
            result = ((InternalVersionManagerImpl)vm).purgeUnusedVersions(providerSession, unusedVersions);
        } else if (vm instanceof InternalXAVersionManager) {
            result = ((InternalXAVersionManager)vm).purgeUnusedVersions(providerSession, unusedVersions);
        } else {
            logger.warn("Unknown implemmentation of the InternalVersionManager: {}.", (Object)vm.getClass().getName());
        }
        status.deletedVersionItems += (long)result;
    }

    static void purgeVersionHistories(List<NodeId> historyIds, JCRSessionWrapper session, VersionHistoryCheckStatus status) throws VersionException, RepositoryException {
        SessionImpl providerSession = (SessionImpl)session.getProviderSession(session.getNode("/").getProvider());
        InternalVersionManager vm = providerSession.getInternalVersionManager();
        LinkedList<InternalVersionHistory> histories = new LinkedList<InternalVersionHistory>();
        for (NodeId id : historyIds) {
            try {
                histories.add(vm.getVersionHistory(id));
            }
            catch (ItemNotFoundException itemNotFoundException) {}
        }
        NodeVersionHistoryHelper.internalPurgeVersionHistories(histories, session, status);
    }

    public static VersionHistoryCheckStatus purgeVersionHistoryForNodes(NodeIterator nodes, Writer statusOut) throws RepositoryException {
        VersionHistoryCheckStatus chunkResult;
        OutWrapper out = new OutWrapper(logger, statusOut);
        out.echo("Start checking version history");
        HashSet<String> ids = new HashSet<String>();
        VersionHistoryCheckStatus status = new VersionHistoryCheckStatus();
        while (nodes.hasNext()) {
            ids.add(nodes.nextNode().getIdentifier());
            if (ids.size() < PURGE_HISTORY_CHUNK) continue;
            chunkResult = NodeVersionHistoryHelper.internalPurgeVersionHistories(ids);
            ids.clear();
            status.merge(chunkResult);
            out.echo(status.toString());
        }
        if (!ids.isEmpty()) {
            chunkResult = NodeVersionHistoryHelper.internalPurgeVersionHistories(ids);
            ids.clear();
            status.merge(chunkResult);
            out.echo(status.toString());
        }
        return status;
    }

    public static VersionHistoryCheckStatus purgeVersionHistoryForNodes(Set<String> nodeIdentifiers) {
        return NodeVersionHistoryHelper.purgeVersionHistoryForNodes(nodeIdentifiers, (Writer)null);
    }

    public static VersionHistoryCheckStatus purgeVersionHistoryForNodes(Set<String> nodeIdentifiers, Writer statusOut) {
        OutWrapper out = new OutWrapper(logger, statusOut);
        out.echo("Start checking version history for {} nodes, using batch of {} nodes", nodeIdentifiers.size(), PURGE_HISTORY_CHUNK);
        HashSet<String> ids = new HashSet<String>();
        VersionHistoryCheckStatus status = new VersionHistoryCheckStatus();
        for (String nodeIdentifier : nodeIdentifiers) {
            ids.add(nodeIdentifier);
            if (ids.size() < PURGE_HISTORY_CHUNK) continue;
            VersionHistoryCheckStatus chunkResult = NodeVersionHistoryHelper.internalPurgeVersionHistories(ids);
            ids.clear();
            status.merge(chunkResult);
        }
        if (!ids.isEmpty()) {
            VersionHistoryCheckStatus chunkResult = NodeVersionHistoryHelper.internalPurgeVersionHistories(ids);
            ids.clear();
            status.merge(chunkResult);
        }
        out.echo("Done checking version history for nodes. Version history status: {}", status.toString());
        return status;
    }

    private NodeVersionHistoryHelper() {
    }

    static {
        logger = LoggerFactory.getLogger(NodeVersionHistoryHelper.class);
        PURGE_HISTORY_CHUNK = Integer.getInteger("org.jahia.services.history.purgeVersionHistoryBatchSize", 100);
    }
}

