/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.history;

import java.util.Calendar;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.persistence.pool.BundleDbPersistenceManager;
import org.apache.jackrabbit.core.persistence.pool.DerbyPersistenceManager;
import org.apache.jackrabbit.core.persistence.util.NodeInfo;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.version.InternalVersionManager;
import org.apache.jackrabbit.core.version.InternalVersionManagerImpl;
import org.apache.jackrabbit.core.version.InternalXAVersionManager;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.util.ISO8601;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.history.NodeVersionHistoryHelper;
import org.jahia.services.history.UnusedVersionCheckStatus;
import org.jahia.tools.OutWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UnusedVersionChecker {
    private static final Logger logger = LoggerFactory.getLogger(UnusedVersionChecker.class);
    private final UnusedVersionCheckStatus status;
    private final long maxUnused;
    private final boolean deleteUnused;
    private final OutWrapper out;
    private final List<NodeId> nodesToCheck = new LinkedList<NodeId>();
    private final List<NodeId> unused = new LinkedList<NodeId>();
    private boolean forceStop;
    private BundleDbPersistenceManager persistenceManager;

    UnusedVersionChecker(UnusedVersionCheckStatus status, long maxUnused, boolean deleteUnused, OutWrapper out) {
        this.status = status;
        this.maxUnused = maxUnused;
        this.deleteUnused = deleteUnused;
        this.out = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeId checkUnused(JCRSessionWrapper session) throws RepositoryException {
        NodeId lastCheckedNodeId = null;
        try {
            long timer = System.currentTimeMillis();
            Map existsReferencesToNodes = this.persistenceManager.existsReferencesToNodes(this.nodesToCheck);
            if (logger.isDebugEnabled()) {
                logger.debug("persistenceManager.existsReferencesToNodes took {} ms", (Object)(System.currentTimeMillis() - timer));
            }
            int purgeVersionsBatchSize = Integer.getInteger("org.jahia.services.history.purgeVersionsBatchSize", 100);
            for (Map.Entry ref : existsReferencesToNodes.entrySet()) {
                lastCheckedNodeId = (NodeId)ref.getKey();
                ++this.status.checked;
                this.nodesToCheck.remove(ref.getKey());
                if (!((Boolean)ref.getValue()).booleanValue()) {
                    ++this.status.orphaned;
                    if (this.deleteUnused) {
                        this.unused.add((NodeId)ref.getKey());
                    }
                    if (this.status.orphaned >= this.maxUnused) {
                        this.out.echo("{} versions checked and the limit of {} versions is reached. Stopping checks.", this.status.checked, this.maxUnused);
                        break;
                    }
                    if (this.deleteUnused && this.status.orphaned > 0L && this.unused.size() >= purgeVersionsBatchSize) {
                        this.delete(session);
                    }
                }
                if (!this.forceStop) continue;
                NodeId nodeId = lastCheckedNodeId;
                return nodeId;
            }
        }
        catch (ItemStateException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        finally {
            if (this.status.orphaned < this.maxUnused) {
                this.out.echo(this.status.toString());
            }
        }
        return lastCheckedNodeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete(JCRSessionWrapper session) {
        this.out.echo("Start deleting {} versions", this.unused.size());
        try {
            long nb = this.status.deletedVersionItems;
            long timer = System.currentTimeMillis();
            NodeVersionHistoryHelper.purgeUnusedVersions(this.unused, session, this.status);
            this.out.echo("deleted {} version items in {} ms", this.status.deletedVersionItems - nb, System.currentTimeMillis() - timer);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.out.echo("Error deleting version histories. Cause: {}", e.getMessage());
        }
        finally {
            this.unused.clear();
        }
    }

    private Map<NodeId, NodeInfo> getAllNodeInfos(NodeId bigger, int maxCount) {
        Map batch = Collections.emptyMap();
        try {
            batch = this.persistenceManager.getAllNodeInfos(bigger, maxCount);
        }
        catch (ItemStateException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return batch;
    }

    private int getCheckUnusedBatchSize() {
        int checkUnusedBatchSize = Integer.getInteger("org.jahia.services.history.checkUnusedBatchSize", 0);
        if (checkUnusedBatchSize != 0) {
            return checkUnusedBatchSize;
        }
        if (this.persistenceManager instanceof DerbyPersistenceManager) {
            return 100;
        }
        if (this.persistenceManager.getStorageModel() == 2) {
            return 500;
        }
        return 1000;
    }

    private boolean isOlder(NodeInfo info, long purgeOlderThanTimestamp) {
        if (purgeOlderThanTimestamp <= 0L) {
            return true;
        }
        Calendar created = null;
        if (info.getCreated() != null) {
            try {
                created = ISO8601.parse((String)info.getCreated());
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.warn("Error parsing creation date " + info.getCreated() + " for node " + String.valueOf(info.getId()), (Throwable)e);
                }
                logger.warn("Error parsing creation date " + info.getCreated() + " for node " + String.valueOf(info.getId()));
            }
        }
        return created != null && created.getTimeInMillis() < purgeOlderThanTimestamp;
    }

    private boolean isRootVersion(NodeInfo info) {
        List predecessors = (List)info.getReferences().get(NameConstants.JCR_PREDECESSORS);
        return predecessors == null || predecessors.isEmpty();
    }

    NodeId perform(JCRSessionWrapper session, long purgeOlderThanTimestamp) throws RepositoryException {
        return this.perform(session, purgeOlderThanTimestamp, null);
    }

    NodeId perform(JCRSessionWrapper session, long purgeOlderThanTimestamp, NodeId lastCheckedNodeId) throws RepositoryException {
        SessionImpl providerSession = (SessionImpl)session.getProviderSession(session.getNode("/").getProvider());
        InternalVersionManager vm = providerSession.getInternalVersionManager();
        PersistenceManager pm = null;
        if (vm instanceof InternalVersionManagerImpl) {
            pm = ((InternalVersionManagerImpl)vm).getPersistenceManager();
        } else if (vm instanceof InternalXAVersionManager) {
            pm = ((InternalXAVersionManager)vm).getPersistenceManager();
        } else {
            logger.warn("Unknown implemmentation of the InternalVersionManager: {}.", (Object)vm.getClass().getName());
        }
        if (pm == null || !(pm instanceof BundleDbPersistenceManager)) {
            this.out.echo("The provided PersistenceManager {} is not an instance of BundleDbPersistenceManager. Unable to proceed.", pm);
            return lastCheckedNodeId;
        }
        this.persistenceManager = (BundleDbPersistenceManager)pm;
        lastCheckedNodeId = this.traverse(session, purgeOlderThanTimestamp, lastCheckedNodeId);
        if (this.forceStop) {
            this.out.echo("Request received to stop checking nodes.");
        } else if (this.deleteUnused && this.unused.size() > 0) {
            this.delete(session);
        }
        return lastCheckedNodeId;
    }

    void stop() {
        this.forceStop = true;
    }

    private NodeId traverse(JCRSessionWrapper session, long purgeOlderThanTimestamp, NodeId lastCheckedNodeId) throws RepositoryException {
        int nodeInfosBatchSize = Integer.getInteger("org.jahia.services.history.loadVersionBundleBatchSize", 8000);
        int checkUnusedBatchSize = this.getCheckUnusedBatchSize();
        NodeId lastReadNodeId = lastCheckedNodeId;
        boolean endReadingNodesSequence = false;
        block0: do {
            Map<NodeId, NodeInfo> batch;
            if ((batch = this.getAllNodeInfos(lastReadNodeId, nodeInfosBatchSize)).size() < nodeInfosBatchSize) {
                endReadingNodesSequence = true;
            }
            for (NodeInfo info : batch.values()) {
                lastReadNodeId = info.getId();
                if (this.forceStop) {
                    return lastCheckedNodeId;
                }
                if (!NameConstants.NT_VERSION.equals(info.getNodeTypeName()) || this.isRootVersion(info) || !this.isOlder(info, purgeOlderThanTimestamp)) continue;
                this.nodesToCheck.add(info.getId());
                if (this.nodesToCheck.size() < checkUnusedBatchSize) continue;
                lastCheckedNodeId = this.checkUnused(session);
                if (this.status.orphaned < this.maxUnused) continue;
                break block0;
            }
        } while (!endReadingNodesSequence);
        if (!this.nodesToCheck.isEmpty() && this.status.orphaned < this.maxUnused) {
            lastCheckedNodeId = this.checkUnused(session);
        }
        if (this.deleteUnused && this.unused.size() > 0) {
            this.delete(session);
        }
        if (endReadingNodesSequence && this.nodesToCheck.isEmpty()) {
            return null;
        }
        return lastCheckedNodeId;
    }
}

