/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Binary;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.value.ValueHelper;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRMultipleValueUtils;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.importexport.ExportContext;
import org.jahia.services.importexport.ImportExportBaseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import pl.touk.throwing.ThrowingPredicate;

public class DocumentViewExporter {
    protected static final Logger logger = LoggerFactory.getLogger(DocumentViewExporter.class);
    private static final String CDATA = "CDATA";
    private static final String NS_URI = "http://www.w3.org/2000/xmlns/";
    private static final Pattern TEMPLATE_PATTERN = Pattern.compile("/sites/[^/]*/templates/(.*)");
    private JCRSessionWrapper session;
    private final ContentHandler ch;
    private final boolean noRecurse;
    private final boolean skipBinary;
    private Set<String> typesToIgnore = new HashSet<String>();
    private Set<String> externalReferences = new HashSet<String>();
    private final Map<String, String> prefixes;
    private final HashMap<String, String> exportedShareable;
    private JCRNodeWrapper rootNode;
    private List<JCRNodeWrapper> nodesList;
    private final Stack<String> stack;
    private List<String> propertiesToIgnore = new ArrayList<String>(ImportExportBaseService.DEFAULT_PROPERTIES_TO_IGNORE);
    private ExportContext exportContext;

    public DocumentViewExporter(JCRSessionWrapper session, ContentHandler ch, boolean skipBinary, boolean noRecurse) {
        this.session = session;
        this.ch = ch;
        this.noRecurse = noRecurse;
        this.skipBinary = skipBinary;
        this.stack = new Stack();
        this.prefixes = new HashMap<String, String>();
        try {
            Map<String, String> map = NodeTypeRegistry.getInstance().getNamespaces();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (StringUtils.isEmpty((String)entry.getKey()) || entry.getKey().startsWith("xml")) continue;
                this.prefixes.put(entry.getKey(), entry.getValue());
            }
            for (String prefix : session.getNamespacePrefixes()) {
                if (StringUtils.isEmpty((String)prefix) || prefix.startsWith("xml") || map.containsKey(prefix)) continue;
                this.prefixes.put(prefix, session.getNamespaceURI(prefix));
            }
        }
        catch (RepositoryException e) {
            logger.warn("Namespace not correctly exported", (Throwable)e);
        }
        this.exportedShareable = new HashMap();
    }

    public void setTypesToIgnore(Set<String> typesToIgnore) {
        this.typesToIgnore = typesToIgnore;
    }

    @Deprecated(since="8.2.1.0", forRemoval=true)
    public void setPublicationStatusSession(JCRSessionWrapper publicationStatusSession) {
    }

    public void export(JCRNodeWrapper node) throws SAXException, RepositoryException {
        TreeSet<JCRNodeWrapper> set = new TreeSet<JCRNodeWrapper>(new Comparator<JCRNodeWrapper>(){

            @Override
            public int compare(JCRNodeWrapper o1, JCRNodeWrapper o2) {
                return o1.getPath().compareTo(o2.getPath());
            }
        });
        set.add(node);
        this.export(node, set);
    }

    public void export(JCRNodeWrapper rootNode, SortedSet<JCRNodeWrapper> nodes) throws SAXException, RepositoryException {
        this.rootNode = rootNode;
        this.ch.startDocument();
        this.nodesList = new ArrayList<JCRNodeWrapper>(nodes);
        long nodesListSize = this.nodesList.size();
        for (int i = 0; i < this.nodesList.size(); ++i) {
            if ((long)this.nodesList.size() != nodesListSize) {
                ArrayList<JCRNodeWrapper> subList = new ArrayList<JCRNodeWrapper>(this.nodesList.subList(i, this.nodesList.size()));
                Collections.sort(subList, nodes.comparator());
                this.nodesList.removeAll(subList);
                this.nodesList.addAll(subList);
                nodesListSize = this.nodesList.size();
            }
            if (!this.nodesList.get(i).getProvider().canExportNode(this.nodesList.get(i))) continue;
            this.exportNode(this.nodesList.get(i));
        }
        while (!this.stack.isEmpty()) {
            String end = this.stack.pop();
            String name = end.substring(end.lastIndexOf(47) + 1);
            String encodedName = ISO9075.encode((String)name);
            this.endElement(encodedName);
        }
        this.ch.endDocument();
    }

    private void exportNode(JCRNodeWrapper node) throws SAXException, RepositoryException {
        try {
            if (this.typesToIgnore.stream().noneMatch(ThrowingPredicate.unchecked(arg_0 -> ((JCRNodeWrapper)node).isNodeType(arg_0)))) {
                Object path = "";
                JCRNodeWrapper current = node;
                while (!current.getPath().equals("/")) {
                    path = "/" + current.getName() + (String)path;
                    current = current.getParent();
                }
                if (((String)path).equals("")) {
                    path = "/";
                }
                if (!((String)path).equals(this.rootNode.getPath())) {
                    String encodedName;
                    String name;
                    String parentpath = ((String)path).substring(0, ((String)path).lastIndexOf(47));
                    while (!(this.stack.isEmpty() || parentpath.startsWith(this.stack.peek() + "/") || parentpath.equals(this.stack.peek()))) {
                        String end = this.stack.pop();
                        if (this.stack.isEmpty()) {
                            throw new RepositoryException("Node not in path : " + node.getPath());
                        }
                        name = end.substring(end.lastIndexOf(47) + 1);
                        encodedName = ISO9075.encode((String)name);
                        this.endElement(encodedName);
                    }
                    if (this.stack.isEmpty() && !node.getPath().equals(this.rootNode.getPath())) {
                        String name2 = this.rootNode.getName();
                        String encodedName2 = ISO9075.encode((String)name2);
                        AttributesImpl atts = new AttributesImpl();
                        this.startElement(encodedName2, atts);
                        if (this.rootNode.getPath().equals("/")) {
                            this.stack.push("");
                        } else {
                            this.stack.push(this.rootNode.getPath());
                        }
                    }
                    while (!this.stack.isEmpty() && !this.stack.peek().equals(parentpath)) {
                        String peek = this.stack.peek();
                        name = parentpath.substring(peek.length() + 1);
                        if (name.contains("/")) {
                            name = name.substring(0, name.indexOf(47));
                        }
                        encodedName = ISO9075.encode((String)name);
                        String currentpath = peek + "/" + name;
                        JCRNodeWrapper n = this.session.getNode(currentpath);
                        String pt = n.getPrimaryNodeTypeName();
                        AttributesImpl atts = new AttributesImpl();
                        atts.addAttribute("http://www.jcp.org/jcr/1.0", "primaryType", "jcr:primaryType", CDATA, pt);
                        this.setProviderRootAttribute(n, atts);
                        this.startElement(encodedName, atts);
                        this.stack.push(currentpath);
                    }
                }
                AttributesImpl atts = new AttributesImpl();
                if (node.isNodeType("jmix:shareable")) {
                    if (this.exportedShareable.containsKey(node.getIdentifier())) {
                        atts.addAttribute("http://www.jahia.org/jahia/1.0", "share", "j:share", CDATA, this.exportedShareable.get(node.getIdentifier()));
                        String encodedName = ISO9075.encode((String)node.getName());
                        this.startElement(encodedName, atts);
                        this.endElement(encodedName);
                        if (this.exportContext != null) {
                            this.exportContext.logExportXmlDocumentElementProcessed(node.getPath());
                        }
                        return;
                    }
                    this.exportedShareable.put(node.getIdentifier(), node.getPath());
                }
                PropertyIterator propsIterator = node.getRealNode().getProperties();
                TreeSet<String> sortedProps = new TreeSet<String>();
                boolean isResource = node.isNodeType("nt:resource");
                while (propsIterator.hasNext()) {
                    boolean isBinaryPropertyType;
                    Property property = propsIterator.nextProperty();
                    if (!node.getProvider().canExportProperty(property) || this.propertiesToIgnore.contains(property.getName())) continue;
                    boolean bl = isBinaryPropertyType = property.getType() == 2;
                    if (this.exportContext != null && isResource && isBinaryPropertyType && property.getName().equals("jcr:data")) {
                        String binaryPathInZip = this.buildBinaryPathInZip(node);
                        Binary binary = property.getBinary();
                        if (this.exportContext.getLiveExportContext() != null && this.exportContext.getLiveExportContext().isBinaryAlreadyCollected(binaryPathInZip, binary)) {
                            atts.addAttribute(this.prefixes.get("j"), "isSameAsLiveBinary", "j:isSameAsLiveBinary", CDATA, "1");
                        } else {
                            this.exportContext.collectBinaryToExport(binaryPathInZip, binary);
                        }
                    }
                    if (isBinaryPropertyType && this.skipBinary) continue;
                    sortedProps.add(property.getName());
                }
                for (String prop : sortedProps) {
                    try {
                        String value;
                        Property property = node.getRealNode().getProperty(prop);
                        if (!node.hasProperty(prop)) continue;
                        String key = property.getName();
                        String prefix = null;
                        String localname = key;
                        if (key.indexOf(58) > -1) {
                            prefix = key.substring(0, key.indexOf(58));
                            localname = key.substring(key.indexOf(58) + 1);
                        }
                        String encodedLocalName = ISO9075.encode((String)localname);
                        if (!property.isMultiple()) {
                            value = property.getDefinition().getRequiredType() == 9 || property.getDefinition().getRequiredType() == 10 ? JCRMultipleValueUtils.encode(this.getValue(property.getValue())) : this.getValue(property.getValue());
                        } else {
                            Value[] vs = property.getValues();
                            ArrayList<String> values = new ArrayList<String>();
                            for (Value v : vs) {
                                values.add(JCRMultipleValueUtils.encode(this.getValue(v)));
                            }
                            StringBuilder b = new StringBuilder();
                            for (int i = 0; i < values.size(); ++i) {
                                String v = (String)values.get(i);
                                b.append(v);
                                if (i + 1 >= values.size()) continue;
                                b.append(" ");
                            }
                            value = b.toString();
                        }
                        if (prefix == null) {
                            atts.addAttribute("", encodedLocalName, encodedLocalName, CDATA, value);
                            continue;
                        }
                        atts.addAttribute(this.prefixes.get(prefix), encodedLocalName, prefix + ":" + encodedLocalName, CDATA, value);
                    }
                    catch (RepositoryException e) {
                        logger.error("Cannot export property", (Throwable)e);
                    }
                }
                this.setProviderRootAttribute(node, atts);
                String encodedName = ISO9075.encode((String)node.getName());
                this.startElement(encodedName, atts);
                if (((String)path).equals("/")) {
                    this.stack.push("");
                } else {
                    this.stack.push((String)path);
                }
                if (!this.noRecurse) {
                    ArrayList<Object> exportedMountPointNodes = new ArrayList<Object>();
                    JCRNodeIteratorWrapper ni = node.getNodes();
                    while (ni.hasNext()) {
                        JCRNodeWrapper mountPointNode;
                        String mountPointName;
                        JCRNodeWrapper c = (JCRNodeWrapper)ni.next();
                        if (!c.getProvider().canExportNode(c) || exportedMountPointNodes.contains(c.getName())) continue;
                        if (!"/".equals(path) && !c.getProvider().equals(node.getProvider()) && node.hasNode(mountPointName = c.getName() + "-mount") && !exportedMountPointNodes.contains(mountPointName) && (mountPointNode = node.getNode(mountPointName)).isNodeType("jnt:mountPoint")) {
                            this.exportNode(mountPointNode);
                            exportedMountPointNodes.add(mountPointName);
                        }
                        this.exportNode(c);
                        if (!c.getName().endsWith("-mount") || !c.isNodeType("jnt:mountPoint")) continue;
                        exportedMountPointNodes.add(c.getName());
                    }
                }
                if (this.exportContext != null) {
                    this.exportContext.logExportXmlDocumentElementProcessed((String)path);
                }
            }
        }
        catch (Exception e) {
            logger.warn("Unable to export node with path {}, it won't be part of the export. Set class in DEBUG to get full error", (Object)node.getPath());
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    private String buildBinaryPathInZip(JCRNodeWrapper ntResourceNode) throws RepositoryException {
        JCRNodeWrapper node = ntResourceNode.getParent();
        String path = this.rootNode.getPath().equals("/") ? node.getPath() : node.getPath().substring(this.rootNode.getParent().getPath().length());
        String name = ntResourceNode.getName().equals("jcr:content") ? node.getName() : JCRContentUtils.replaceColon(ntResourceNode.getName());
        return path + "/" + name;
    }

    private void setProviderRootAttribute(JCRNodeWrapper node, AttributesImpl atts) throws RepositoryException {
        if (!"/".equals(node.getPath()) && !node.getProvider().equals(node.getParent().getProvider())) {
            if (node.getProvider().isDynamicallyMounted()) {
                JCRNodeWrapper mountPoint = this.session.getNodeByIdentifier(node.getProvider().getKey());
                atts.addAttribute("", "j:dynamicMountPointProviderPath", "j:dynamicMountPointProviderPath", CDATA, mountPoint.getPath());
            } else {
                atts.addAttribute("", "j:staticMountPointProviderKey", "j:staticMountPointProviderKey", CDATA, node.getProvider().getKey());
            }
        }
    }

    private String getValue(Value v) throws RepositoryException {
        if (v.getType() == 9 || v.getType() == 10) {
            try {
                JCRNodeWrapper reference = this.session.getNodeByUUID(v.getString());
                Object path = reference.getPath();
                Matcher matcher = TEMPLATE_PATTERN.matcher((CharSequence)path);
                if (matcher.matches()) {
                    path = "$currentSite/templates/" + matcher.group(1);
                } else {
                    boolean root = this.rootNode.getPath().equals("/");
                    if (!(root || ((String)path).startsWith(this.rootNode.getPath() + "/") || ((String)path).equals(this.rootNode.getPath()))) {
                        this.externalReferences.add(v.getString());
                    } else if (this.typesToIgnore.stream().noneMatch(ThrowingPredicate.unchecked(arg_0 -> ((JCRNodeWrapper)reference).isNodeType(arg_0))) && reference.getResolveSite() != null) {
                        if (reference.getResolveSite().getSiteKey().equals("systemsite")) {
                            boolean foundInExportedNodes = false;
                            for (JCRNodeWrapper node : this.nodesList) {
                                if (!((String)path).startsWith(node.getPath() + "/") && !((String)path).equals(node.getPath())) continue;
                                foundInExportedNodes = true;
                                break;
                            }
                            if (!foundInExportedNodes) {
                                this.nodesList.add(reference);
                            }
                        }
                        path = this.rootNode.getPath().equals(path) ? "#/" : "#" + ((String)path).substring(this.rootNode.getPath().length() + (root ? -1 : 0));
                    }
                }
                return path;
            }
            catch (ItemNotFoundException e) {
                return "";
            }
        }
        if (v.getType() == 2) {
            return ValueHelper.serialize((Value)v, (boolean)false);
        }
        return v.getString();
    }

    private void startElement(String qualifiedName, AttributesImpl atts) throws SAXException {
        if (qualifiedName.equals("")) {
            qualifiedName = "content";
        }
        if (this.stack.isEmpty()) {
            for (String prefix : new TreeSet<String>(this.prefixes.keySet())) {
                String uri = this.prefixes.get(prefix);
                atts.addAttribute(NS_URI, prefix, "xmlns:" + prefix, CDATA, uri);
                this.ch.startPrefixMapping(prefix, uri);
                this.ch.endPrefixMapping(prefix);
            }
        }
        this.ch.startElement("", qualifiedName, qualifiedName, atts);
    }

    private void endElement(String qualifiedName) throws SAXException {
        if (qualifiedName.equals("")) {
            qualifiedName = "content";
        }
        this.ch.endElement("", qualifiedName, qualifiedName);
    }

    public List<String> getPropertiestoIgnore() {
        return this.propertiesToIgnore;
    }

    public void setPropertiestoIgnore(List<String> propertiestoIgnore) {
        this.propertiesToIgnore = propertiestoIgnore;
    }

    public Set<String> getExternalReferences() {
        return this.externalReferences;
    }

    public void setExternalReferences(Set<String> externalReferences) {
        this.externalReferences = externalReferences;
    }

    public List<JCRNodeWrapper> getNodesList() {
        return this.nodesList;
    }

    public void setExportContext(ExportContext exportContext) {
        this.exportContext = exportContext;
    }

    public ExportContext getExportContext() {
        return this.exportContext;
    }

    @Deprecated(since="8.2.1.0", forRemoval=true)
    public void addObserver(PropertyChangeListener propertyChangeListener) {
    }

    public void configureForLiveExport() {
        this.propertiesToIgnore.remove("jcr:uuid");
    }
}

