/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.TextExtractor;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.util.ISO8601;
import org.jahia.exceptions.JahiaException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.categories.Category;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.nodetypes.ExtendedItemDefinition;
import org.jahia.services.content.nodetypes.ExtendedNodeDefinition;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.content.nodetypes.ValueImpl;
import org.jahia.services.importexport.DefinitionsMapping;
import org.jahia.services.importexport.LegacyPidMappingTool;
import org.jahia.services.seo.VanityUrl;
import org.jahia.services.seo.jcr.VanityUrlManager;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.Patterns;
import org.jahia.utils.i18n.ResourceBundleMarker;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Deprecated(since="8.2.1.0", forRemoval=true)
public class LegacyImportHandler
extends DefaultHandler {
    private static Logger logger = LoggerFactory.getLogger(LegacyImportHandler.class);
    private static final int CTX_PAGE = 0;
    private static final int CTX_CTN = 1;
    private static final int CTX_LIST = 2;
    private static final int CTX_FIELD = 3;
    private static final int CTX_SKIP = 4;
    private static final int CTX_SHAREABLE = 5;
    private static final int CTX_DIRECTSUBNODES = 6;
    private static final int CTX_NAVLINK = 7;
    private NodeTypeRegistry registry;
    private DefinitionsMapping mapping;
    private Locale locale;
    private JCRNodeWrapper currentSiteNode;
    private Stack<PageContext> currentCtx = new Stack();
    private String originatingJahiaRelease = null;
    private int ctnId = 1;
    private Map<String, String> uuidMapping = new HashMap<String, String>();
    private Map<String, List<String>> references = new HashMap<String, List<String>>();
    private JCRSessionWrapper session;
    private final LegacyPidMappingTool legacyPidMappingTool;
    private final String externalLinkType;
    private final String externalLinkUrlPropertyName;
    private final boolean externalLinkInternationalized;
    private static final String HTTP_WWW_JAHIA_ORG = "http://www.jahia.org/";
    private static final String PAGE = "page";
    private static final String LINK = "link";
    private static final String EMPTY = "empty";
    public static final Set<String> READ_ROLES = new HashSet<String>(Arrays.asList("reader"));
    public static final Set<String> WRITE_ROLES = new HashSet<String>(Arrays.asList("editor", "contributor"));
    public static final Set<String> ADMIN_ROLES = new HashSet<String>(Arrays.asList("reviewer", "owner"));
    public static Set<String> CUSTOM_CONTENT_READ_ROLES;
    public static Set<String> CUSTOM_CONTENT_WRITE_ROLES;
    public static Set<String> CUSTOM_CONTENT_ADMIN_ROLES;
    public static Set<String> CUSTOM_FILES_READ_ROLES;
    public static Set<String> CUSTOM_FILES_WRITE_ROLES;
    private String currentNode;
    private int level = 0;
    private VanityUrlManager urlMgr;

    public LegacyImportHandler(JCRSessionWrapper session, JCRNodeWrapper currentSiteNode, NodeTypeRegistry registry, DefinitionsMapping mapping, Locale locale, String originatingJahiaRelease, LegacyPidMappingTool legacyPidMappingTool, int initialCtnId) {
        this.session = session;
        this.uuidMapping = session.getUuidMapping();
        this.currentSiteNode = currentSiteNode;
        this.ctnId = initialCtnId < 1 ? 1 : initialCtnId;
        this.registry = registry;
        if (mapping == null) {
            mapping = new DefinitionsMapping();
        }
        this.mapping = mapping;
        this.locale = locale;
        this.originatingJahiaRelease = originatingJahiaRelease;
        this.legacyPidMappingTool = legacyPidMappingTool;
        String s = SettingsBean.getInstance().lookupString("legacy.import.externalLink.nodeType");
        this.externalLinkType = StringUtils.isNotBlank((String)s) ? s.trim() : "jnt:externalLink";
        s = SettingsBean.getInstance().lookupString("legacy.import.externalLink.urlPropertyName");
        this.externalLinkUrlPropertyName = StringUtils.isNotBlank((String)s) ? s.trim() : "j:url";
        this.externalLinkInternationalized = SettingsBean.getInstance().lookupBoolean("legacy.import.externalLink.internationalized");
        this.urlMgr = (VanityUrlManager)SpringContextSingleton.getBean("org.jahia.services.seo.jcr.VanityUrlManager");
    }

    public void setReferences(Map<String, List<String>> references) {
        this.references = references;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        int ctx = -1;
        String uuid = null;
        try {
            this.currentNode = localName;
            uuid = attributes.getValue("jcr:uuid");
            if (!this.currentCtx.isEmpty()) {
                ctx = this.currentCtx.peek().ctx.peek();
            }
            if (logger.isDebugEnabled()) {
                logger.debug(StringUtils.repeat((String)" ", (int)this.level) + "<" + this.currentNode + "> , ctx = " + ctx);
            }
            ++this.level;
            Map<String, String> creationMetadata = this.getMetadataForNodeCreation(attributes);
            if (ctx == -1) {
                if (HTTP_WWW_JAHIA_ORG.equals(uri) && PAGE.equals(localName)) {
                    this.createPage(attributes.getValue("http://www.jcp.org/jcr/1.0", "primaryType"), attributes.getValue("jahia:title"), attributes.getValue("jahia:template"), attributes.getValue(HTTP_WWW_JAHIA_ORG, "pageKey"), uuid, creationMetadata, attributes.getValue("jahia:pid"), attributes.getValue("jcr:mixinTypes"), this.getAdditionalProperties(attributes.getValue("jcr:additionalProperties")));
                    this.setAcl(attributes.getValue(HTTP_WWW_JAHIA_ORG, "acl"));
                    this.setMetadata(attributes);
                    this.setSeoURLs(attributes.getValue(HTTP_WWW_JAHIA_ORG, "urlMappings"));
                    return;
                }
                if (HTTP_WWW_JAHIA_ORG.equals(uri) && EMPTY.equals(localName)) {
                    logger.warn("The site " + this.currentSiteNode.getDisplayableName() + " was not published in language " + String.valueOf(this.locale) + ", nothing to import");
                    return;
                }
                logger.error("Unexpected root markup: <" + uri + ":" + localName + " /> for site" + this.currentSiteNode.getDisplayableName());
                return;
            }
            switch (ctx) {
                case 0: {
                    if (localName.endsWith("List") && this.getCurrentContentType() != null && this.getCurrentContentType().getChildNodeDefinitionsAsMap().containsKey(StringUtils.substringBeforeLast((String)localName, (String)"List"))) {
                        ExtendedNodeDefinition nodeDef = this.getCurrentContentType().getChildNodeDefinitionsAsMap().get(StringUtils.substringBeforeLast((String)localName, (String)"List"));
                        this.createContentList(nodeDef, uuid, creationMetadata, attributes);
                        this.setMetadata(attributes);
                        this.setAcl(attributes.getValue(HTTP_WWW_JAHIA_ORG, "acl"));
                        this.setSeoURLs(attributes.getValue(HTTP_WWW_JAHIA_ORG, "urlMappings"));
                        break;
                    }
                    logger.error("Unexpected " + localName + " element (" + uuid + ") in import file - skipping it and its subtree (more info in debug mode)");
                    if (logger.isDebugEnabled() && localName.endsWith("List")) {
                        if (this.getCurrentContentType() == null) {
                            logger.debug("CurrentContentType is null!");
                        } else {
                            logger.debug("Only the following elements are allowed sccording to the source definitions: " + this.getCurrentContentType().getChildNodeDefinitionsAsMap().keySet().toString());
                        }
                    }
                    this.currentCtx.peek().pushSkip();
                    break;
                }
                case 1: {
                    ExtendedItemDefinition itemDef;
                    if (localName.endsWith("List") && this.getCurrentContentType() != null && this.getCurrentContentType().getChildNodeDefinitionsAsMap().containsKey(StringUtils.substringBeforeLast((String)localName, (String)"List"))) {
                        ExtendedNodeDefinition nodeDef = this.getCurrentContentType().getChildNodeDefinitionsAsMap().get(StringUtils.substringBeforeLast((String)localName, (String)"List"));
                        try {
                            this.createContentList(nodeDef, uuid, creationMetadata, attributes);
                            if (this.currentCtx.peek().ctx.peek() != 6) {
                                this.setMetadata(attributes);
                                this.setAcl(attributes.getValue(HTTP_WWW_JAHIA_ORG, "acl"));
                                this.setSeoURLs(attributes.getValue(HTTP_WWW_JAHIA_ORG, "urlMappings"));
                            }
                        }
                        catch (ConstraintViolationException cve) {
                            logger.error("Error when creating contentList with def={} (localname={} , uuid={} , currentContentType={})", new Object[]{nodeDef.getName(), localName, uuid, this.getCurrentContentType().getName()});
                        }
                        break;
                    }
                    logger.debug("create field " + localName);
                    if (this.getCurrentContentType().getChildNodeDefinitionsAsMap().containsKey(localName) && this.getCurrentContentType().getPropertyDefinitionsAsMap().containsKey(localName)) {
                        ExtendedItemDefinition itemDef2;
                        itemDef = this.getCurrentContentType().getChildNodeDefinitionsAsMap().get(localName);
                        if (!itemDef.getDeclaringNodeType().getName().equals(this.getCurrentContentType().getNodeTypeDefinition().getName()) && (itemDef2 = (ExtendedItemDefinition)this.getCurrentContentType().getPropertyDefinitionsAsMap().get(localName)).getDeclaringNodeType().getName().equals(this.getCurrentContentType().getNodeTypeDefinition().getName())) {
                            itemDef = itemDef2;
                        }
                    } else {
                        itemDef = this.getCurrentContentType().getChildNodeDefinitionsAsMap().containsKey(localName) ? (ExtendedItemDefinition)this.getCurrentContentType().getChildNodeDefinitionsAsMap().get(localName) : (ExtendedItemDefinition)this.getCurrentContentType().getPropertyDefinitionsAsMap().get(localName);
                    }
                    if (itemDef == null) {
                        logger.error("Definition not found for field " + localName + " in node " + this.getCurrentContentType().getName() + " , uuid=" + uuid);
                    } else if (logger.isDebugEnabled()) {
                        if (itemDef.isNode()) {
                            logger.debug("The field {} is a subnode of the node type {} (child node definition = {})", new Object[]{localName, this.getCurrentContentType().getName(), itemDef.getName()});
                        } else {
                            logger.debug("The field is a property: " + localName);
                        }
                    }
                    if (itemDef != null && (itemDef.isNode() || this.setPropertyField(this.getCurrentContentType(), localName, attributes.getValue("jahia:value"), creationMetadata))) {
                        String mappedProperty = this.mapping.getMappedProperty(this.getCurrentContentType(), localName);
                        if ("#skip".equals(mappedProperty)) {
                            this.currentCtx.peek().pushSkip();
                            break;
                        }
                        this.currentCtx.peek().pushField(mappedProperty);
                        break;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Not imported field " + localName + ", definition not found");
                        StringBuilder s = new StringBuilder();
                        for (String def : this.getCurrentContentType().getChildNodeDefinitionsAsMap().keySet()) {
                            s.append(def).append(", ");
                        }
                        logger.debug("Allowed sub definitions: " + String.valueOf(s.length() > 0 ? s : "none"));
                        for (String def : this.getCurrentContentType().getPropertyDefinitionsAsMap().keySet()) {
                            s.append(def).append(", ");
                        }
                        logger.debug("Allowed properties: " + String.valueOf(s.length() > 0 ? s : "none"));
                    }
                    this.currentCtx.peek().pushSkip();
                    break;
                }
                case 2: {
                    String pt = attributes.getValue("http://www.jcp.org/jcr/1.0", "primaryType");
                    if (pt == null && StringUtils.startsWith((String)this.originatingJahiaRelease, (String)"5")) {
                        pt = qName;
                    }
                    this.createContent(pt, uuid, attributes.getValue("jahia:jahiaLinkActivation_picker_relationship"), creationMetadata, attributes.getValue("jcr:mixinTypes"), this.getAdditionalProperties(attributes.getValue("jcr:additionalProperties")));
                    this.setMetadata(attributes);
                    this.setAcl(attributes.getValue(HTTP_WWW_JAHIA_ORG, "acl"));
                    this.setSeoURLs(attributes.getValue(HTTP_WWW_JAHIA_ORG, "urlMappings"));
                    break;
                }
                case 3: {
                    this.setNodeField(uri, localName, uuid, attributes);
                    break;
                }
                case 5: {
                    if ("#shareableSource".equals(this.mapping.getMappedNode(this.getCurrentContentType(), localName))) {
                        this.createShareableNode(attributes.getValue("jahia:value"));
                        break;
                    }
                    this.currentCtx.peek().pushSkip();
                    break;
                }
                case 4: {
                    this.currentCtx.peek().pushSkip();
                    break;
                }
                case 7: {
                    this.currentCtx.peek().pushNavLink(this.getCurrentContentType(), attributes.getValue(HTTP_WWW_JAHIA_ORG, "acl"));
                    this.currentCtx.peek().properties.peek().putAll(this.convertToProperties(attributes));
                    JCRNodeWrapper page = this.currentCtx.peek().contents.peek();
                    String title = attributes.getValue("jahia:title");
                    if (HTTP_WWW_JAHIA_ORG.equals(uri) && PAGE.equals(localName)) {
                        String acl = null;
                        if (logger.isDebugEnabled()) {
                            logger.debug("page acls: " + this.currentCtx.peek().acls.toString());
                        }
                        for (String a : this.currentCtx.peek().acls) {
                            if (a == null) continue;
                            acl = a;
                        }
                        if (attributes.getValue(HTTP_WWW_JAHIA_ORG, "acl") != null) {
                            acl = attributes.getValue(HTTP_WWW_JAHIA_ORG, "acl");
                        }
                        Map<String, String> props = this.currentCtx.peek().properties.peek();
                        this.createPage(attributes.getValue("http://www.jcp.org/jcr/1.0", "primaryType"), title, attributes.getValue("jahia:template"), attributes.getValue(HTTP_WWW_JAHIA_ORG, "pageKey"), uuid, creationMetadata, attributes.getValue("jahia:pid"), attributes.getValue("jcr:mixinTypes"), this.getAdditionalProperties(attributes.getValue("jcr:additionalProperties")));
                        this.setMetadata(props, creationMetadata);
                        this.setAcl(acl);
                        this.setSeoURLs(attributes.getValue(HTTP_WWW_JAHIA_ORG, "urlMappings"));
                        break;
                    }
                    if (HTTP_WWW_JAHIA_ORG.equals(uri) && LINK.equals(localName)) {
                        this.createInternalLink(page, title, uuid, attributes.getValue("jahia:reference"), "jnt:nodeLink", creationMetadata, attributes.getValue("jcr:mixinTypes"), this.getAdditionalProperties(attributes.getValue("jcr:additionalProperties")));
                        break;
                    }
                    if (!HTTP_WWW_JAHIA_ORG.equals(uri) || !localName.equals("url")) break;
                    this.createExternalLink(page, title, uuid, attributes.getValue("jahia:value"), this.externalLinkType, this.externalLinkUrlPropertyName, this.externalLinkInternationalized, creationMetadata, attributes.getValue("jcr:mixinTypes"), this.getAdditionalProperties(attributes.getValue("jcr:additionalProperties")));
                    break;
                }
                case 6: {
                    String ctnPt = attributes.getValue("http://www.jcp.org/jcr/1.0", "primaryType");
                    if (ctnPt == null && StringUtils.startsWith((String)this.originatingJahiaRelease, (String)"5")) {
                        ctnPt = qName;
                    }
                    this.createContent(ctnPt, uuid, attributes.getValue("jahia:jahiaLinkActivation_picker_relationship"), creationMetadata, attributes.getValue("jcr:mixinTypes"), this.getAdditionalProperties(attributes.getValue("jcr:additionalProperties")));
                    this.setMetadata(attributes);
                    this.setAcl(attributes.getValue(HTTP_WWW_JAHIA_ORG, "acl"));
                    this.setSeoURLs(attributes.getValue(HTTP_WWW_JAHIA_ORG, "urlMappings"));
                }
            }
        }
        catch (RepositoryException e) {
            logger.error(MessageFormat.format("Error while processing element: [uri={0}], [localName={1}], [qName={2}], [uuid={3}], [ctx={4}]", uri, localName, qName, uuid, ctx));
            throw new SAXException((Exception)((Object)e));
        }
    }

    private JSONObject getAdditionalProperties(String value) {
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        try {
            return new JSONObject(value);
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.error("Impossible to read additional properties", (Throwable)e);
            } else {
                logger.error("Impossible to read additional properties: {}", (Object)e.getMessage());
            }
            return null;
        }
    }

    private Map<String, String> convertToProperties(Attributes attributes) {
        HashMap<String, String> properties = new HashMap<String, String>();
        int l = attributes.getLength();
        for (int i = 0; i < l; ++i) {
            properties.put(attributes.getQName(i), attributes.getValue(i));
        }
        return properties;
    }

    private Map<String, String> getMetadataForNodeCreation(Attributes attributes) {
        HashMap<String, String> metadataMap = new HashMap<String, String>();
        metadataMap.put("jahia:createdBy", attributes.getValue("jahia:createdBy"));
        String date = attributes.getValue("jcr:created");
        metadataMap.put("jcr:created", (String)(date != null && date.length() == 19 ? date + ".000Z" : date));
        metadataMap.put("jahia:lastModifiedBy", attributes.getValue("jahia:lastModifiedBy"));
        date = attributes.getValue("jcr:lastModified");
        metadataMap.put("jcr:lastModified", (String)(date != null && date.length() == 19 ? date + ".000Z" : date));
        return metadataMap;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.currentCtx.peek().ctx.peek() == 0) {
            --this.level;
            this.currentCtx.pop();
            if (!this.currentCtx.isEmpty()) {
                this.currentCtx.peek().pop();
                if (logger.isDebugEnabled()) {
                    logger.debug(StringUtils.repeat((String)" ", (int)this.level) + "</" + localName + "> , popped full ctx , ctx = " + String.valueOf(this.currentCtx.peek().ctx.empty() ? EMPTY : (Serializable)this.currentCtx.peek().ctx.peek()));
                }
            }
        } else {
            --this.level;
            if (logger.isDebugEnabled()) {
                logger.debug(StringUtils.repeat((String)" ", (int)this.level) + "</" + localName + "> , ctx = " + String.valueOf(this.currentCtx.peek().ctx.peek()));
            }
            this.currentCtx.peek().pop();
        }
    }

    private void createPage(String primaryType, String title, String template, String pageKey, String uuid, Map<String, String> creationMetadata, String pageId, String mixinsToAdd, JSONObject propertiesToSet) throws RepositoryException {
        JCRNodeWrapper subPage;
        ExtendedNodeType t;
        try {
            t = this.registry.getNodeType(primaryType);
        }
        catch (NoSuchNodeTypeException e) {
            t = this.registry.getNodeType("jnt:page");
        }
        if (this.uuidMapping.containsKey(uuid)) {
            subPage = this.session.getNodeByIdentifier(this.uuidMapping.get(uuid));
        } else {
            JCRNodeWrapper parent;
            JCRNodeWrapper jCRNodeWrapper = parent = this.currentCtx.isEmpty() ? this.currentSiteNode : this.getCurrentPageNode();
            if (!parent.isCheckedOut()) {
                this.session.checkout(parent);
            }
            if (this.currentCtx.isEmpty()) {
                pageKey = "home";
            }
            if (pageKey == null) {
                try {
                    pageKey = JCRContentUtils.generateNodeName(title);
                }
                catch (NullPointerException npe) {
                    pageKey = "untitled";
                    logger.error(MessageFormat.format("Impossible to generate a system name from page title =[{0}] , uuid={1}", title, uuid), (Throwable)npe);
                }
            }
            pageKey = pageKey.replace('/', '_');
            pageKey = JCRContentUtils.replaceColon(pageKey);
            pageKey = pageKey.replace('[', '_');
            pageKey = pageKey.replace(']', '_');
            ExtendedNodeType pageType = this.registry.getNodeType("jnt:page");
            String templateName = "";
            if (!StringUtils.isEmpty((String)template)) {
                templateName = this.mapping.getMappedPropertyValue(pageType, "jahia:template", template);
            }
            templateName = StringUtils.substringAfterLast((String)("/" + templateName), (String)"/");
            subPage = this.addOrCheckoutPageNode(templateName, parent, pageKey, creationMetadata);
            this.uuidMapping.put(uuid, subPage.getIdentifier());
            this.performActions(this.mapping.getActions(pageType, "jahia:template", template), subPage, creationMetadata);
            this.performActions(this.mapping.getActions(t), subPage, creationMetadata);
        }
        this.currentCtx.push(new PageContext(subPage, t));
        if (StringUtils.isNotBlank((String)title)) {
            Node translation = this.getOrCreateI18N(subPage, this.locale, creationMetadata);
            if (!translation.isCheckedOut()) {
                this.session.checkout(translation);
            }
            translation.setProperty("jcr:title", title);
        }
        this.handleAdditionalMixinsAndProperties(subPage, mixinsToAdd, propertiesToSet, creationMetadata);
        if (this.legacyPidMappingTool != null) {
            this.legacyPidMappingTool.defineLegacyMapping(Integer.valueOf(pageId), subPage, this.locale);
        }
    }

    private void createExternalLink(JCRNodeWrapper page, String title, String uuid, String url, String nodeType, Map<String, String> creationMetadata) throws RepositoryException {
        this.createExternalLink(page, title, uuid, url, nodeType, "j:url", false, creationMetadata, null, null);
    }

    private void createExternalLink(JCRNodeWrapper page, String title, String uuid, String url, String nodeType, String urlPropertyName, boolean urlIsLocalized, Map<String, String> creationMetadata, String mixinsToAdd, JSONObject propertiesToSet) throws RepositoryException {
        JCRNodeWrapper sub;
        if (this.uuidMapping.containsKey(uuid)) {
            sub = this.session.getNodeByIdentifier(this.uuidMapping.get(uuid));
        } else {
            sub = this.addOrCheckoutNode(page, "link_" + this.ctnId++, nodeType, null, creationMetadata);
            this.uuidMapping.put(uuid, sub.getIdentifier());
        }
        Node translation = null;
        if (StringUtils.isNotBlank((String)url)) {
            if (urlIsLocalized) {
                translation = this.getOrCreateI18N(sub, this.locale, creationMetadata);
                translation.setProperty(urlPropertyName, url);
            } else {
                sub.setProperty(urlPropertyName, url);
            }
        }
        if (StringUtils.isNotBlank((String)title)) {
            if (translation == null) {
                translation = this.getOrCreateI18N(sub, this.locale, creationMetadata);
            }
            translation.setProperty("jcr:title", title);
        }
        this.handleAdditionalMixinsAndProperties(sub, mixinsToAdd, propertiesToSet, creationMetadata);
    }

    private void createInternalLink(JCRNodeWrapper page, String title, String uuid, String reference, String nodeType, Map<String, String> creationMetadata, String mixinsToAdd, JSONObject propertiesToSet) throws RepositoryException {
        JCRNodeWrapper sub;
        if (this.uuidMapping.containsKey(uuid)) {
            sub = this.session.getNodeByIdentifier(this.uuidMapping.get(uuid));
        } else {
            sub = this.addOrCheckoutNode(page, "link_" + this.ctnId++, nodeType, null, creationMetadata);
            if (!this.references.containsKey(reference)) {
                this.references.put(reference, new ArrayList());
            }
            this.references.get(reference).add(sub.getIdentifier() + "/j:node");
            this.uuidMapping.put(uuid, sub.getIdentifier());
        }
        if (StringUtils.isNotBlank((String)title)) {
            Node translation = this.getOrCreateI18N(sub, this.locale, creationMetadata);
            if (!translation.isCheckedOut()) {
                this.session.checkout(translation);
            }
            translation.setProperty("jcr:title", title);
        }
        if (!sub.isCheckedOut()) {
            this.session.checkout(sub);
        }
        sub.setProperty("jcr:title", title);
        this.handleAdditionalMixinsAndProperties(sub, mixinsToAdd, propertiesToSet, creationMetadata);
    }

    private JCRNodeWrapper addOrCheckoutPageNode(String template, JCRNodeWrapper parent, String nodeName, Map<String, String> creationMetadata) throws RepositoryException {
        JCRNodeWrapper node;
        try {
            node = parent.getNode(nodeName);
            if (!node.isCheckedOut()) {
                this.session.checkout(node);
            }
        }
        catch (PathNotFoundException e) {
            if (!parent.isCheckedOut()) {
                this.session.checkout(parent);
            }
            Calendar created = !StringUtils.isEmpty((String)creationMetadata.get("jcr:created")) ? ISO8601.parse((String)creationMetadata.get("jcr:created")) : null;
            String createdBy = creationMetadata.get("jahia:createdBy");
            Calendar lastModified = !StringUtils.isEmpty((String)creationMetadata.get("jcr:lastModified")) ? ISO8601.parse((String)creationMetadata.get("jcr:lastModified")) : null;
            String lastModifiedBy = creationMetadata.get("jahia:lastModifiedBy");
            node = parent.addNode(nodeName, "jnt:page", null, created, createdBy, lastModified, lastModifiedBy);
        }
        if (template != null) {
            node.setProperty("j:templateName", template);
        }
        return node;
    }

    private Node getOrCreateI18N(JCRNodeWrapper node, Locale locale, Map<String, String> creationMetadata) throws RepositoryException {
        Calendar created = !StringUtils.isEmpty((String)creationMetadata.get("jcr:created")) ? ISO8601.parse((String)creationMetadata.get("jcr:created")) : null;
        String createdBy = creationMetadata.get("jahia:createdBy");
        Calendar lastModified = !StringUtils.isEmpty((String)creationMetadata.get("jcr:lastModified")) ? ISO8601.parse((String)creationMetadata.get("jcr:lastModified")) : null;
        String lastModifiedBy = creationMetadata.get("jahia:lastModifiedBy");
        return node.getOrCreateI18N(locale, created, createdBy, lastModified, lastModifiedBy);
    }

    private JCRNodeWrapper checkoutNode(JCRNodeWrapper node) throws RepositoryException {
        if (!node.isCheckedOut()) {
            this.session.checkout(node);
        }
        return node;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JCRNodeWrapper addOrCheckoutNode(JCRNodeWrapper parent, String nodeName, String nodeType, List<String> followingNodeNames, Map<String, String> creationMetadata) throws RepositoryException {
        JCRNodeWrapper node;
        try {
            node = parent.getNode(nodeName);
            if (node.isCheckedOut()) return node;
            this.session.checkout(node);
            return node;
        }
        catch (PathNotFoundException e) {
            JCRNodeWrapper nextNode;
            block10: {
                if (!parent.isCheckedOut()) {
                    this.session.checkout(parent);
                }
                if (StringUtils.isEmpty((String)nodeType)) {
                    nodeType = "jnt:contentList";
                }
                try {
                    Calendar created = !StringUtils.isEmpty((String)creationMetadata.get("jcr:created")) ? ISO8601.parse((String)creationMetadata.get("jcr:created")) : null;
                    String createdBy = creationMetadata.get("jahia:createdBy");
                    Calendar lastModified = !StringUtils.isEmpty((String)creationMetadata.get("jcr:lastModified")) ? ISO8601.parse((String)creationMetadata.get("jcr:lastModified")) : null;
                    String lastModifiedBy = creationMetadata.get("jahia:lastModifiedBy");
                    node = parent.addNode(nodeName, nodeType, null, created, createdBy, lastModified, lastModifiedBy);
                }
                catch (ConstraintViolationException cve) {
                    throw new ConstraintViolationException(MessageFormat.format("Error while adding node {0} of type {1} to node {2}", nodeName, nodeType, parent.getPath()), (Throwable)cve);
                }
                if (CollectionUtils.isEmpty(followingNodeNames)) return node;
                boolean takeNextName = false;
                JCRNodeIteratorWrapper it = parent.getNodes();
                while (it.hasNext()) {
                    nextNode = (JCRNodeWrapper)it.next();
                    int index = followingNodeNames.indexOf(nextNode.getName());
                    if (index > -1) {
                        if (!followingNodeNames.get(index).equals(nodeName)) {
                            parent.orderBefore(node.getName(), nextNode.getName());
                            return node;
                        }
                        takeNextName = true;
                        continue;
                    }
                    if (!takeNextName) {
                        continue;
                    }
                    break block10;
                }
                return node;
            }
            parent.orderBefore(node.getName(), nextNode.getName());
            return node;
        }
    }

    private void createContentList(ExtendedNodeDefinition listDefinition, String uuid, Map<String, String> creationMetadata, Attributes attributes) throws RepositoryException {
        String nodeName = this.mapping.getMappedNode(this.getCurrentContentType(), listDefinition.getName());
        String nodeType = "jnt:contentList";
        if (nodeName.indexOf("|") > 0) {
            nodeType = StringUtils.substringBefore((String)nodeName, (String)"|");
            nodeName = StringUtils.substringAfter((String)nodeName, (String)"|");
        }
        ExtendedNodeType primaryNodeType = listDefinition.getRequiredPrimaryTypes()[0];
        try {
            primaryNodeType = this.registry.getNodeType(StringUtils.substringBeforeLast((String)listDefinition.getRequiredPrimaryTypes()[0].getName(), (String)"List"));
        }
        catch (NoSuchNodeTypeException noSuchNodeTypeException) {
            // empty catch block
        }
        String mappedNodeType = this.mapping.getMappedType(primaryNodeType);
        if ("#skip".equals(nodeName) || "#skip".equals(mappedNodeType)) {
            this.currentCtx.peek().pushSkip();
        } else if ("#navlink".equals(nodeName) || "#navlink".equals(mappedNodeType)) {
            this.currentCtx.peek().pushNavLink(listDefinition.getRequiredPrimaryTypes()[0], null);
        } else if ("#directSubNodes".equals(nodeName) || "#directSubNodes".equals(mappedNodeType)) {
            this.currentCtx.peek().pushDirectContainer();
        } else {
            JCRNodeWrapper parent = this.getCurrentContentNode();
            if (StringUtils.contains((String)nodeName, (String)"/")) {
                String parentPath = StringUtils.substringBeforeLast((String)nodeName, (String)"/");
                parent = parent.hasNode(parentPath) ? parent.getNode(parentPath) : parent.addNode(parentPath, "jnt:contentList");
                nodeName = StringUtils.substringAfterLast((String)nodeName, (String)"/");
            }
            if (StringUtils.isEmpty((String)nodeType) && parent.getPrimaryNodeType().getChildNodeDefinitionsAsMap().get(nodeName) != null) {
                String[] strings = parent.getPrimaryNodeType().getChildNodeDefinitionsAsMap().get(nodeName).getRequiredPrimaryTypeNames();
                nodeType = strings[0];
            }
            List<String> mappedOldNodeNames = this.mapping.getMappedNodesForType(this.getCurrentContentType(), true);
            int indexOfName = mappedOldNodeNames.indexOf(listDefinition.getName());
            List<String> mappedNewNodeNames = null;
            if (indexOfName != -1) {
                mappedNewNodeNames = this.mapping.getMappedNodesForType(this.getCurrentContentType(), false).subList(indexOfName, mappedOldNodeNames.size());
            }
            JCRNodeWrapper node = this.addOrCheckoutNode(parent, nodeName, nodeType, mappedNewNodeNames, creationMetadata);
            this.performActions(this.mapping.getActions(this.getCurrentContentType(), listDefinition.getName()), node, creationMetadata);
            this.uuidMapping.put(uuid, node.getIdentifier());
            ExtendedNodeType listType = listDefinition.getRequiredPrimaryTypes()[0];
            this.currentCtx.peek().pushList(node, listType);
            if (this.currentCtx.peek().properties.peek() != null) {
                for (Map.Entry<String, String> entry : this.currentCtx.peek().properties.peek().entrySet()) {
                    this.setPropertyField(this.getCurrentContentType(), entry.getKey(), entry.getValue(), creationMetadata);
                }
            }
        }
        this.handleContainerListSorting(attributes.getValue("jahia:sortHandler"), primaryNodeType);
    }

    private void handleContainerListSorting(String sortHandler, ExtendedNodeType primaryNodeType) {
        if (sortHandler == null || sortHandler.length() == 0) {
            return;
        }
        JCRNodeWrapper node = this.currentCtx.peek().contents.peek();
        String path = node.getPath();
        try {
            String[] sortConfig = StringUtils.split((String)sortHandler, (String)"; ");
            String field = sortConfig[sortConfig.length - 1];
            String targetProperty = this.mapping.getMappedProperty(primaryNodeType, field);
            String direction = sortConfig[1];
            if (targetProperty != null && (node.isNodeType("jnt:contentList") || node.isNodeType("jnt:area"))) {
                logger.debug("Setting automatic ordering for list {} using property {} and direction {}", (Object[])new String[]{path, targetProperty, direction});
                node.addMixin("jmix:orderedList");
                node.setProperty("firstField", targetProperty);
                node.setProperty("firstDirection", direction != null && "desc".equals(direction) ? "desc" : "asc");
            } else {
                logger.error("Unable to handle container list sorting property " + sortHandler + " as the target node is not a list: " + path);
            }
        }
        catch (Exception e) {
            logger.error("Unable to handle container list sorting property " + sortHandler + " on node " + path, (Throwable)e);
        }
    }

    private void createShareableNode(String uuid) throws RepositoryException {
        if (!this.references.containsKey(uuid)) {
            this.references.put(uuid, new ArrayList());
        }
        this.references.get(uuid).add(this.getCurrentContentNode().getIdentifier() + "/@ctn" + this.ctnId++);
        this.currentCtx.peek().pushSkip();
    }

    private void createContent(String primaryType, String uuid, String pickerRelationshipUuid, Map<String, String> creationMetadata, String mixinsToAdd, JSONObject propertiesToSet) throws RepositoryException {
        ExtendedNodeType t = this.registry.getNodeType(primaryType);
        String nodeType = this.mapping.getMappedType(t);
        if (nodeType.equals("#skip")) {
            this.currentCtx.peek().pushSkip();
        } else if (nodeType.equals("#navlink")) {
            this.currentCtx.peek().pushNavLink(t, null);
        } else if (nodeType.equals("#shareable")) {
            this.currentCtx.peek().pushShareable(t);
        } else {
            JCRNodeWrapper node = null;
            if (this.uuidMapping.containsKey(uuid)) {
                node = this.session.getNodeByIdentifier(this.uuidMapping.get(uuid));
                if (pickerRelationshipUuid != null) {
                    this.currentCtx.peek().pushSkip();
                } else {
                    this.currentCtx.peek().pushContainer(node, t);
                }
            } else if (pickerRelationshipUuid != null) {
                node = this.addOrCheckoutNode(this.getCurrentContentNode(), StringUtils.substringAfter((String)nodeType, (String)":") + "_" + this.ctnId++, "jnt:contentReference", null, creationMetadata);
                String contentRefUuid = node.getIdentifier();
                this.uuidMapping.put(uuid, contentRefUuid);
                this.performActions(this.mapping.getActions(t), node, creationMetadata);
                if (this.uuidMapping.containsKey(pickerRelationshipUuid)) {
                    JCRNodeWrapper source = this.session.getNodeByIdentifier(this.uuidMapping.get(pickerRelationshipUuid));
                    node.setProperty("j:node", source);
                } else {
                    if (!this.references.containsKey(pickerRelationshipUuid)) {
                        this.references.put(pickerRelationshipUuid, new ArrayList());
                    }
                    this.references.get(pickerRelationshipUuid).add(contentRefUuid + "/j:node");
                }
                this.currentCtx.peek().pushSkip();
            } else {
                try {
                    ExtendedNodeType nt = NodeTypeRegistry.getInstance().getNodeType(nodeType);
                    if (StringUtils.startsWith((String)this.originatingJahiaRelease, (String)"5") && nt.isNodeType("jnt:nodeLink")) {
                        this.currentCtx.peek().pushNavLink(this.getCurrentContentType(), null);
                        return;
                    }
                }
                catch (NoSuchNodeTypeException e) {
                    logger.error("Unexpected nodetype " + nodeType + " - skipping it and its subtree");
                    this.currentCtx.peek().pushSkip();
                    return;
                }
                node = this.addOrCheckoutNode(this.getCurrentContentNode(), StringUtils.substringAfter((String)nodeType, (String)":") + "_" + this.ctnId++, nodeType, null, creationMetadata);
                this.uuidMapping.put(uuid, node.getIdentifier());
                this.performActions(this.mapping.getActions(t), node, creationMetadata);
                this.currentCtx.peek().pushContainer(node, t);
            }
            this.handleAdditionalMixinsAndProperties(node, mixinsToAdd, propertiesToSet, creationMetadata);
            if (this.currentCtx.peek().properties.peek() != null) {
                for (Map.Entry<String, String> entry : this.currentCtx.peek().properties.peek().entrySet()) {
                    ExtendedNodeType currentContentType = this.getCurrentContentType();
                    String fieldName = entry.getKey();
                    logger.debug("About to import field {}/{}", (Object)currentContentType.getName(), (Object)fieldName);
                    if (this.setPropertyField(currentContentType, fieldName, entry.getValue(), creationMetadata) || "#skip".equals(fieldName)) continue;
                    logger.error("Not imported field {}/{}", (Object)currentContentType.getName(), (Object)fieldName);
                }
            }
        }
    }

    private void performActions(List<DefinitionsMapping.Action> actions, JCRNodeWrapper node, Map<String, String> creationMetadata) throws RepositoryException {
        for (DefinitionsMapping.Action action : actions) {
            if (action instanceof DefinitionsMapping.AddMixin) {
                DefinitionsMapping.AddMixin addMixinAction = (DefinitionsMapping.AddMixin)action;
                node = this.checkoutNode(node);
                node.addMixin(addMixinAction.getNodeType());
                continue;
            }
            if (action instanceof DefinitionsMapping.AddNode) {
                DefinitionsMapping.AddNode addNodeAction = (DefinitionsMapping.AddNode)action;
                JCRNodeWrapper addedNode = this.addOrCheckoutNode(node, addNodeAction.getName(), addNodeAction.getNodeType(), null, Collections.emptyMap());
                this.setProperties(addedNode, addNodeAction.getProperties(), creationMetadata);
                continue;
            }
            if (!(action instanceof DefinitionsMapping.SetProperties)) continue;
            DefinitionsMapping.SetProperties setPropertiesAction = (DefinitionsMapping.SetProperties)action;
            this.setProperties(node, setPropertiesAction.getProperties(), creationMetadata);
        }
    }

    private void setProperties(JCRNodeWrapper node, Map<String, String> properties, Map<String, String> creationMetadata) {
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (String p : properties.keySet()) {
                sb.append(MessageFormat.format("[{0}={1}]", p, properties.get(p)));
            }
            logger.debug("setProperties action called on {} with values : {}", (Object)node.getPath(), (Object)sb.toString());
        }
        if (properties == null) {
            return;
        }
        for (Map.Entry<String, String> property : properties.entrySet()) {
            String propertyName = property.getKey();
            try {
                this.setPropertyField(null, null, node, propertyName, property.getValue(), creationMetadata);
            }
            catch (RepositoryException e) {
                logger.error("Error setting property: " + propertyName + " on node: " + node.getPath(), (Throwable)e);
            }
        }
    }

    private void setMetadata(Attributes attributes) throws RepositoryException {
        int l = attributes.getLength();
        for (int i = 0; i < l; ++i) {
            String name = attributes.getQName(i);
            this.setPropertyField(null, name, attributes.getValue(i), this.getMetadataForNodeCreation(attributes));
        }
    }

    private void setMetadata(Map<String, String> properties, Map<String, String> creationMetadata) throws RepositoryException {
        for (Map.Entry<String, String> property : properties.entrySet()) {
            this.setPropertyField(null, property.getKey(), property.getValue(), creationMetadata);
        }
    }

    private void setSeoURLs(String urlMapping) {
        if (StringUtils.isBlank((String)urlMapping)) {
            return;
        }
        for (String mapping : StringUtils.split((String)urlMapping, (String)"===")) {
            if (StringUtils.isBlank((String)mapping)) continue;
            String[] mappingItems = StringUtils.split((String)mapping, (String)"$$$");
            JCRNodeWrapper node = this.getCurrentContentNode();
            String url = mappingItems[0];
            Boolean isActive = Boolean.valueOf(mappingItems[1]);
            Boolean isDefault = Boolean.valueOf(mappingItems[2]);
            try {
                String site = node.getResolveSite().getSiteKey();
                if (this.urlMgr.findExistingVanityUrls(url, site, node.getSession()).isEmpty()) {
                    VanityUrl vanityUrl = new VanityUrl(url, site, this.locale.toString(), isDefault, isActive);
                    this.urlMgr.saveVanityUrlMapping(node, vanityUrl, node.getSession());
                    continue;
                }
                logger.error("Impossible to save URL mapping " + url + " on node " + node.getPath());
            }
            catch (RepositoryException re) {
                logger.error("Impossible to save URL mapping " + url + " on node " + node.getPath());
            }
        }
    }

    private void setAcl(String acl) {
        if (acl != null) {
            JCRNodeWrapper node = this.getCurrentContentNode();
            StringTokenizer st = new StringTokenizer(acl, "|");
            try {
                while (st.hasMoreTokens()) {
                    String ace = st.nextToken();
                    if (ace.equals("break")) {
                        node.setAclInheritanceBreak(true);
                        continue;
                    }
                    if (ace.equals("none")) continue;
                    int colonIndex = ace.lastIndexOf(":");
                    String perm = ace.substring(colonIndex + 1);
                    if (perm.length() != 3) {
                        logger.error("Skipping inconsistent acl entry: " + ace);
                        continue;
                    }
                    HashSet<String> grantedRoles = new HashSet<String>();
                    HashSet<String> removedRoles = new HashSet<String>();
                    if (perm.charAt(0) == 'r') {
                        if (CollectionUtils.isEmpty(CUSTOM_CONTENT_READ_ROLES)) {
                            grantedRoles.addAll(READ_ROLES);
                        } else {
                            grantedRoles.addAll(CUSTOM_CONTENT_READ_ROLES);
                        }
                    } else if (CollectionUtils.isEmpty(CUSTOM_CONTENT_READ_ROLES)) {
                        removedRoles.addAll(READ_ROLES);
                    } else {
                        removedRoles.addAll(CUSTOM_CONTENT_READ_ROLES);
                    }
                    if (perm.charAt(1) == 'w') {
                        if (CollectionUtils.isEmpty(CUSTOM_CONTENT_WRITE_ROLES)) {
                            grantedRoles.addAll(WRITE_ROLES);
                        } else {
                            grantedRoles.addAll(CUSTOM_CONTENT_WRITE_ROLES);
                        }
                    } else if (CollectionUtils.isEmpty(CUSTOM_CONTENT_WRITE_ROLES)) {
                        removedRoles.addAll(WRITE_ROLES);
                    } else {
                        removedRoles.addAll(CUSTOM_CONTENT_WRITE_ROLES);
                    }
                    if (perm.charAt(2) == 'a') {
                        if (CollectionUtils.isEmpty(CUSTOM_CONTENT_ADMIN_ROLES)) {
                            grantedRoles.addAll(ADMIN_ROLES);
                        } else {
                            grantedRoles.addAll(CUSTOM_CONTENT_ADMIN_ROLES);
                        }
                    } else if (CollectionUtils.isEmpty(CUSTOM_CONTENT_ADMIN_ROLES)) {
                        removedRoles.addAll(ADMIN_ROLES);
                    } else {
                        removedRoles.addAll(CUSTOM_CONTENT_ADMIN_ROLES);
                    }
                    String principal = ace.substring(0, colonIndex);
                    if (principal.equals("g:guest")) {
                        principal = "u:guest";
                    }
                    if (!grantedRoles.isEmpty()) {
                        node.grantRoles(principal, grantedRoles);
                    }
                    if (removedRoles.isEmpty()) continue;
                    node.denyRoles(principal, removedRoles);
                }
            }
            catch (RepositoryException e) {
                logger.error("Cannot set user or group ACL entry !!", (Throwable)e);
            }
        }
    }

    private void setNodeField(String uri, String localName, String uuid, Attributes attributes) throws RepositoryException, SAXException {
        JCRNodeWrapper sub;
        JCRNodeWrapper node = this.getCurrentContentNode();
        String title = attributes.getValue("jahia:title");
        String propertyName = this.currentCtx.peek().propertyNames.peek();
        boolean isProperty = false;
        for (String s : node.getNodeTypes()) {
            ExtendedNodeType nt = NodeTypeRegistry.getInstance().getNodeType(s);
            if (nt.getChildNodeDefinitionsAsMap().containsKey(propertyName)) break;
            if (!nt.getPropertyDefinitionsAsMap().containsKey(propertyName)) continue;
            isProperty = true;
            break;
        }
        Map<String, String> creationMetadata = this.getMetadataForNodeCreation(attributes);
        if (HTTP_WWW_JAHIA_ORG.equals(uri) && PAGE.equals(localName)) {
            this.createPage(attributes.getValue("http://www.jcp.org/jcr/1.0", "primaryType"), title, attributes.getValue("jahia:template"), attributes.getValue(HTTP_WWW_JAHIA_ORG, "pageKey"), uuid, creationMetadata, attributes.getValue("jahia:pid"), attributes.getValue("jcr:mixinTypes"), this.getAdditionalProperties(attributes.getValue("jcr:additionalProperties")));
            this.setAcl(attributes.getValue(HTTP_WWW_JAHIA_ORG, "acl"));
        } else if (HTTP_WWW_JAHIA_ORG.equals(uri) && LINK.equals(localName)) {
            String reference = attributes.getValue("jahia:reference");
            if (StringUtils.isNotBlank((String)reference)) {
                if (!isProperty && !node.hasNode(propertyName)) {
                    sub = this.addOrCheckoutNode(node, propertyName, "jnt:nodeLink", null, creationMetadata);
                    if (StringUtils.isNotBlank((String)title)) {
                        Node translation = this.getOrCreateI18N(sub, this.locale, creationMetadata);
                        translation.setProperty("jcr:title", title);
                    }
                    sub.setProperty("jcr:title", title);
                    if (!this.references.containsKey(reference)) {
                        this.references.put(reference, new ArrayList());
                    }
                    this.references.get(reference).add(sub.getIdentifier() + "/j:node");
                } else if (isProperty && !node.hasProperty(propertyName)) {
                    JCRNodeWrapper target = node;
                    if (node.getApplicablePropertyDefinition(propertyName) != null && node.getApplicablePropertyDefinition(propertyName).isInternationalized()) {
                        target = this.getOrCreateI18N(node, this.locale, creationMetadata);
                    }
                    if (!this.references.containsKey(reference)) {
                        this.references.put(reference, new ArrayList());
                    }
                    this.references.get(reference).add(target.getIdentifier() + "/" + propertyName);
                }
            } else {
                logger.error("Invalid reference on markup " + uuid);
            }
            this.currentCtx.peek().pushSkip();
        } else if (HTTP_WWW_JAHIA_ORG.equals(uri) && localName.equals("url")) {
            String value = attributes.getValue("jahia:value");
            if (!node.hasNode(propertyName)) {
                sub = this.addOrCheckoutNode(node, propertyName, "jnt:externalLink", null, creationMetadata);
                if (StringUtils.isNotBlank((String)title)) {
                    Node translation = this.getOrCreateI18N(sub, this.locale, creationMetadata);
                    translation.setProperty("jcr:title", title);
                }
                sub.setProperty("j:url", value);
            } else if (!isProperty || !node.hasProperty(propertyName)) {
                // empty if block
            }
            this.currentCtx.peek().pushSkip();
        } else {
            throw new SAXException("Unexpected " + localName);
        }
    }

    private boolean setPropertyField(ExtendedNodeType baseType, String localName, String value, Map<String, String> creationMetadata) throws RepositoryException {
        String propertyName = baseType != null ? this.mapping.getMappedProperty(baseType, localName) : this.mapping.getMappedMetadataProperty(localName);
        logger.debug("localName: " + localName + ", propertyName: " + propertyName);
        return this.setPropertyField(baseType, localName, this.getCurrentContentNode(), propertyName, value, creationMetadata);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean setPropertyField(ExtendedNodeType baseType, String localName, JCRNodeWrapper node, String propertyName, String value, Map<String, String> creationMetadata) throws RepositoryException {
        ExtendedPropertyDefinition propertyDefinition;
        JCRNodeWrapper parent = node;
        String mixinType = null;
        if (propertyName.contains("|")) {
            mixinType = StringUtils.substringBefore((String)propertyName, (String)"|");
            propertyName = StringUtils.substringAfter((String)propertyName, (String)"|");
        }
        if (StringUtils.contains((String)propertyName, (String)"/")) {
            String parentPath = StringUtils.substringBeforeLast((String)propertyName, (String)"/");
            if (parent.hasNode(parentPath)) {
                parent = parent.getNode(parentPath);
            }
            propertyName = StringUtils.substringAfterLast((String)propertyName, (String)"/");
        }
        parent = this.checkoutNode(parent);
        if (!StringUtils.isEmpty((String)mixinType) && !parent.isNodeType(mixinType)) {
            parent.addMixin(mixinType);
        }
        if ((propertyDefinition = parent.getApplicablePropertyDefinition(propertyName)) == null) {
            return false;
        }
        if (propertyDefinition.isProtected()) {
            return false;
        }
        if (!StringUtils.isNotBlank((String)value) || value.equals("<empty>")) return false;
        JCRNodeWrapper n = parent;
        if (propertyDefinition.isInternationalized()) {
            n = this.getOrCreateI18N(parent, this.locale, creationMetadata);
        }
        if (!n.isCheckedOut()) {
            this.session.checkout(n);
        }
        switch (propertyDefinition.getRequiredType()) {
            case 5: {
                GregorianCalendar cal = new GregorianCalendar();
                try {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                    Date d = df.parse(value);
                    cal.setTime(d);
                    n.setProperty(propertyName, cal);
                    return true;
                }
                catch (ParseException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                return true;
            }
            case 9: 
            case 10: {
                if (propertyDefinition.isMultiple()) {
                    String[] strings;
                    for (String s : strings = Patterns.TRIPPLE_DOLLAR.split(value)) {
                        this.createReferenceValue(s, propertyDefinition.getSelector(), n, propertyName);
                    }
                    return true;
                }
                this.createReferenceValue(value, propertyDefinition.getSelector(), n, propertyName);
                return true;
            }
            default: {
                switch (propertyDefinition.getSelector()) {
                    case 2: {
                        if (value.contains("=\"###")) {
                            int count = 1;
                            StringBuilder buf = new StringBuilder(value);
                            while (buf.indexOf("=\"###") > -1) {
                                int to;
                                int from = buf.indexOf("=\"###") + 2;
                                String ref = buf.substring(from, to = buf.indexOf("\"", from));
                                if (ref.startsWith("###/webdav")) {
                                    ref = StringUtils.substringAfter((String)ref, (String)"###/webdav");
                                    buf.replace(from, to, "##doc-context##/{workspace}/##ref:link" + count + "##");
                                } else if (ref.startsWith("###file:")) {
                                    ref = StringUtils.substringAfter((String)ref, (String)"###file:");
                                    int qmPos = ref.indexOf(63);
                                    boolean isUuid = false;
                                    if (qmPos != -1) {
                                        if (StringUtils.substring((String)ref, (int)(qmPos + 1)).startsWith("uuid=default:")) {
                                            ref = StringUtils.substring((String)ref, (int)(qmPos + 14));
                                            isUuid = true;
                                        } else {
                                            ref = StringUtils.substringBefore((String)ref, (String)"?");
                                        }
                                    }
                                    if (!isUuid) {
                                        ref = this.correctFilename(ref);
                                    }
                                    buf.replace(from, to, "##doc-context##/{workspace}/##ref:link" + count + "##");
                                } else {
                                    ref = StringUtils.substringAfterLast((String)ref, (String)"/");
                                    String params = "";
                                    int pos = ref.indexOf(63);
                                    if (pos == -1) {
                                        pos = ref.indexOf(35);
                                    }
                                    if (pos != -1) {
                                        params = ref.substring(pos);
                                        ref = ref.substring(0, pos);
                                    }
                                    buf.replace(from, to, "##cms-context##/{mode}/{lang}/##ref:link" + count + "##.html" + params);
                                }
                                try {
                                    ref = URLDecoder.decode(ref, "UTF-8");
                                }
                                catch (UnsupportedEncodingException unsupportedEncodingException) {
                                    // empty catch block
                                }
                                if (!this.references.containsKey(ref)) {
                                    this.references.put(ref, new ArrayList());
                                }
                                this.references.get(ref).add(n.getIdentifier() + "/[" + count + "]" + propertyDefinition.getName());
                                ++count;
                            }
                            value = buf.toString();
                        }
                        n.setProperty(propertyName, value);
                        if (!logger.isDebugEnabled()) return true;
                        logger.debug("Setting on node " + n.getPath() + " property " + propertyName + " with value=" + value);
                        return true;
                    }
                    default: {
                        String[] vcs = propertyDefinition.getValueConstraints();
                        List<String> constraints = Arrays.asList(vcs);
                        if (!propertyDefinition.isMultiple()) {
                            if (value.startsWith("<jahia-resource")) {
                                if ((value = ResourceBundleMarker.parseMarkerValue(value).getResourceKey()).startsWith(propertyDefinition.getResourceBundleKey())) {
                                    value = value.substring(propertyDefinition.getResourceBundleKey().length() + 1);
                                }
                            } else if ("jcr:description".equals(propertyName)) {
                                value = this.removeHtmlTags(value);
                            }
                            String string = value = baseType != null ? this.mapping.getMappedPropertyValue(baseType, localName, value) : value;
                            if (this.valueMatchesContraints(value, constraints)) {
                                try {
                                    n.setProperty(propertyName, value);
                                    if (!logger.isDebugEnabled()) return true;
                                    logger.debug("Setting on node " + n.getPath() + " property " + propertyName + " with value=" + value);
                                    return true;
                                }
                                catch (Exception e) {
                                    logger.error("Impossible to set property " + propertyName + " due to exception", (Throwable)e);
                                }
                                return true;
                            }
                            logger.error("Impossible to set property " + propertyName + " due to some constraint error");
                            logger.error(" - value       = " + value);
                            logger.error(" - constraints = " + constraints.toString());
                            return true;
                        }
                        String[] strings = Patterns.TRIPPLE_DOLLAR.split(value);
                        ArrayList<ValueImpl> values = new ArrayList<ValueImpl>();
                        for (String string : strings) {
                            if (string.startsWith("<jahia-resource") && (string = ResourceBundleMarker.parseMarkerValue(string).getResourceKey()).startsWith(propertyDefinition.getResourceBundleKey())) {
                                string = string.substring(propertyDefinition.getResourceBundleKey().length() + 1);
                            }
                            String string2 = value = baseType != null ? this.mapping.getMappedPropertyValue(baseType, localName, value) : value;
                            if (!constraints.isEmpty() && !constraints.contains(value)) continue;
                            values.add(new ValueImpl(string, propertyDefinition.getRequiredType()));
                        }
                        n.setProperty(propertyName, values.toArray(new Value[values.size()]));
                        if (!logger.isDebugEnabled()) return true;
                        logger.debug("Setting on node " + n.getPath() + " property " + propertyName + " with value=" + String.valueOf(values));
                        return true;
                    }
                }
            }
        }
    }

    private boolean valueMatchesContraints(String value, List<String> constraints) {
        if (constraints == null) {
            return true;
        }
        if (constraints.isEmpty()) {
            return true;
        }
        if (constraints.contains(value)) {
            return true;
        }
        for (String constraint : constraints) {
            if (!Pattern.compile(constraint).matcher(value).matches()) continue;
            return true;
        }
        return false;
    }

    private void createReferenceValue(String value, int selector, Node node, String prop) throws RepositoryException {
        try {
            switch (selector) {
                case 13: {
                    List<Category> c = ServicesRegistry.getInstance().getCategoryService().getCategory(value);
                    if (c.isEmpty()) {
                        logger.warn("Cannot find category : " + value);
                        break;
                    }
                    if (!this.references.containsKey(c.get(0).getID())) {
                        this.references.put(c.get(0).getID(), new ArrayList());
                    }
                    this.references.get(c.get(0).getID()).add(node.getIdentifier() + "/" + prop);
                    if (c.size() > 1) {
                        logger.warn("Multiple category match : " + value);
                    }
                    break;
                }
                default: {
                    if (value.startsWith("/")) {
                        if (!this.references.containsKey(value = this.correctFilename(value))) {
                            this.references.put(value, new ArrayList());
                        }
                        this.references.get(value).add(node.getIdentifier() + "/" + prop);
                        break;
                    }
                    String uuid = StringUtils.substringAfter((String)value, (String)":");
                    if (!this.references.containsKey(uuid)) {
                        this.references.put(uuid, new ArrayList());
                    }
                    this.references.get(uuid).add(node.getIdentifier() + "/" + prop);
                    break;
                }
            }
        }
        catch (JahiaException e) {
            logger.error("Cannot get categories", (Throwable)e);
        }
    }

    private String correctFilename(String value) {
        Matcher m;
        if (((String)value).startsWith("/content/users/") && (m = Pattern.compile("/content/users/([^/]+)(/.*)?").matcher((CharSequence)value)).matches()) {
            value = ServicesRegistry.getInstance().getJahiaUserManagerService().getUserSplittingRule().getPathForUsername(m.group(1));
            value = (String)value + (m.group(2) != null ? m.group(2) : "");
        }
        return JCRContentUtils.escapeNodePath((String)value);
    }

    private String removeHtmlTags(String value) {
        Source source = new Source((CharSequence)value);
        TextExtractor textExtractor = source.getTextExtractor();
        textExtractor.setExcludeNonHTMLElements(true);
        textExtractor.setConvertNonBreakingSpaces(false);
        textExtractor.setIncludeAttributes(false);
        return textExtractor.toString();
    }

    private void handleAdditionalMixinsAndProperties(JCRNodeWrapper node, String mixinsToAdd, JSONObject propertiesToSet, Map<String, String> creationMetadata) {
        if (node == null) {
            return;
        }
        if (StringUtils.isNotBlank((String)mixinsToAdd)) {
            if (logger.isDebugEnabled()) {
                logger.debug(MessageFormat.format("Adding mixins [{0}] to the node {1} in language {2}", mixinsToAdd, node.getPath(), this.locale.toString()));
            }
            for (String mixin : Arrays.asList(StringUtils.split((String)mixinsToAdd))) {
                try {
                    if (!StringUtils.isNotBlank((String)mixin) || node.isNodeType(mixin)) continue;
                    node.addMixin(mixin);
                }
                catch (RepositoryException re) {
                    logger.error(MessageFormat.format("Imposible to apply mixin {0} to the node {1}", mixin, node.getPath()), (Throwable)re);
                }
            }
        }
        if (propertiesToSet != null) {
            Iterator properties = propertiesToSet.keys();
            while (properties.hasNext()) {
                String propName = (String)properties.next();
                try {
                    String propValue = String.valueOf(propertiesToSet.get(propName));
                    if (logger.isDebugEnabled()) {
                        logger.debug(MessageFormat.format("Setting the property {0} with value [{1}] on the node {2} in language {3}", propName, propValue, node.getPath(), this.locale.toString()));
                    }
                    this.setPropertyField(null, null, node, propName, propValue, creationMetadata);
                }
                catch (Exception e) {
                    logger.error(MessageFormat.format("Error while setting additional property {0} on the node {1} for locale {2}", propName, node.getPath(), this.locale.toString()), (Throwable)e);
                }
            }
        }
    }

    private JCRNodeWrapper getCurrentPageNode() {
        return (JCRNodeWrapper)this.currentCtx.peek().contents.firstElement();
    }

    private JCRNodeWrapper getCurrentContentNode() {
        return this.currentCtx.peek().contents.peek();
    }

    private ExtendedNodeType getCurrentContentType() {
        return this.currentCtx.peek().contentsType.peek();
    }

    public int getCtnId() {
        return this.ctnId;
    }

    class PageContext {
        Stack<Integer> ctx = new Stack();
        Stack<JCRNodeWrapper> contents = new Stack();
        Stack<ExtendedNodeType> contentsType = new Stack();
        Stack<String> propertyNames = new Stack();
        Stack<String> acls = new Stack();
        Stack<Map<String, String>> properties = new Stack();

        PageContext(JCRNodeWrapper page, ExtendedNodeType pageType) {
            this.contents.push(page);
            this.contentsType.push(pageType);
            this.propertyNames.push(null);
            this.acls.push(null);
            this.properties.push(null);
            this.ctx.push(0);
        }

        void pushList(JCRNodeWrapper node, ExtendedNodeType type) {
            if (logger.isDebugEnabled()) {
                logger.debug(" push " + LegacyImportHandler.this.currentNode + " , ctx = 2");
            }
            this.contents.push(node);
            this.contentsType.push(type);
            this.propertyNames.push(null);
            this.acls.push(null);
            this.properties.push((Map<String, String>)(this.properties.peek() != null ? new HashMap<String, String>(this.properties.peek()) : null));
            this.ctx.push(2);
        }

        void pushContainer(JCRNodeWrapper node, ExtendedNodeType type) {
            if (logger.isDebugEnabled()) {
                logger.debug(" push " + LegacyImportHandler.this.currentNode + " , ctx = 1");
            }
            this.contents.push(node);
            this.contentsType.push(type);
            this.propertyNames.push(null);
            this.acls.push(null);
            this.properties.push((Map<String, String>)(this.properties.peek() != null ? new HashMap<String, String>(this.properties.peek()) : null));
            this.ctx.push(1);
        }

        void pushDirectContainer() {
            this.contents.push(LegacyImportHandler.this.getCurrentContentNode());
            this.contentsType.push(null);
            this.propertyNames.push(null);
            this.acls.push(null);
            this.properties.push(null);
            this.ctx.push(6);
        }

        void pushField(String propertyName) {
            if (logger.isDebugEnabled()) {
                logger.debug(" push " + LegacyImportHandler.this.currentNode + " , ctx = 3");
            }
            this.contents.push(this.contents.peek());
            this.contentsType.push(this.contentsType.peek());
            this.propertyNames.push(propertyName);
            this.acls.push(null);
            this.properties.push(null);
            this.ctx.push(3);
        }

        void pushNavLink(ExtendedNodeType t, String acl) {
            if (logger.isDebugEnabled()) {
                logger.debug(" push " + LegacyImportHandler.this.currentNode + " , ctx = 7");
            }
            this.contents.push(this.contents.peek());
            this.contentsType.push(this.contentsType.peek());
            this.propertyNames.push(null);
            this.acls.push(acl);
            this.properties.push(this.ctx.peek() == 7 && this.properties.peek() != null ? new HashMap<String, String>(this.properties.peek()) : new HashMap<String, String>());
            this.ctx.push(7);
        }

        void pushSkip() {
            if (logger.isDebugEnabled()) {
                logger.debug(" push " + LegacyImportHandler.this.currentNode + " , ctx = 4");
            }
            this.contents.push(this.contents.peek());
            this.contentsType.push(this.contentsType.peek());
            this.propertyNames.push(null);
            this.acls.push(null);
            this.properties.push(null);
            this.ctx.push(4);
        }

        void pushShareable(ExtendedNodeType t) {
            if (logger.isDebugEnabled()) {
                logger.debug(" push " + LegacyImportHandler.this.currentNode + " , ctx = 5");
            }
            this.contents.push(this.contents.peek());
            this.contentsType.push(t);
            this.propertyNames.push(null);
            this.acls.push(null);
            this.properties.push(null);
            this.ctx.push(5);
        }

        void pop() {
            this.contents.pop();
            this.contentsType.pop();
            this.propertyNames.pop();
            this.acls.pop();
            this.properties.pop();
            this.ctx.pop();
        }
    }
}

