/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport.validation;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.importexport.validation.ValidationResult;
import org.jahia.utils.i18n.Messages;

public class ConstraintsValidatorResult
implements ValidationResult,
Serializable {
    Map<String, Set<String>> missingMandatoryProperties = new TreeMap<String, Set<String>>();
    Map<String, Set<String>> missingMandatoryI18NProperties = new TreeMap<String, Set<String>>();
    Map<String, String> otherConstraintViolations = new HashMap<String, String>();

    public ConstraintsValidatorResult(Map<String, Set<String>> missingMandatoryProperties, Map<String, Set<String>> missingMandatoryI18NProperties, Map<String, String> missingConstraint) {
        this.missingMandatoryProperties = missingMandatoryProperties;
        this.missingMandatoryI18NProperties = missingMandatoryI18NProperties;
        this.otherConstraintViolations = missingConstraint;
    }

    public ConstraintsValidatorResult(ConstraintsValidatorResult result1, ConstraintsValidatorResult result2) {
        this.missingMandatoryProperties.putAll(result1.missingMandatoryProperties);
        this.missingMandatoryI18NProperties.putAll(result1.missingMandatoryI18NProperties);
        this.otherConstraintViolations.putAll(result1.otherConstraintViolations);
        for (Map.Entry<String, Set<String>> entry : result2.missingMandatoryProperties.entrySet()) {
            if (this.missingMandatoryProperties.containsKey(entry.getKey())) {
                this.missingMandatoryProperties.get(entry.getKey()).addAll((Collection<String>)entry.getValue());
                continue;
            }
            this.missingMandatoryProperties.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Set<String>> entry : result2.missingMandatoryI18NProperties.entrySet()) {
            if (this.missingMandatoryI18NProperties.containsKey(entry.getKey())) {
                this.missingMandatoryI18NProperties.get(entry.getKey()).addAll((Collection<String>)entry.getValue());
                continue;
            }
            this.missingMandatoryI18NProperties.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : result2.otherConstraintViolations.entrySet()) {
            this.otherConstraintViolations.put(entry.getKey(), (String)entry.getValue());
        }
    }

    public Map<String, Set<String>> getMissingMandatoryProperties() {
        return this.missingMandatoryProperties;
    }

    public Map<String, Set<String>> getMissingMandatoryI18NProperties() {
        return this.missingMandatoryI18NProperties;
    }

    public Map<String, String> getOtherConstraintViolations() {
        return this.otherConstraintViolations;
    }

    public int getLength() {
        return this.otherConstraintViolations.size() + this.missingMandatoryI18NProperties.size() + this.missingMandatoryProperties.size();
    }

    @Override
    public boolean isSuccessful() {
        return this.missingMandatoryProperties.isEmpty() && this.missingMandatoryI18NProperties.isEmpty() && this.otherConstraintViolations.isEmpty();
    }

    @Override
    public ValidationResult merge(ValidationResult toBeMergedWith) {
        return toBeMergedWith == null || toBeMergedWith.isSuccessful() || !(toBeMergedWith instanceof ConstraintsValidatorResult) ? this : new ConstraintsValidatorResult(this, (ConstraintsValidatorResult)toBeMergedWith);
    }

    @Override
    public boolean isBlocking() {
        return true;
    }

    @Override
    public Set<String> getFormatedMessages(Locale locale) {
        HashSet<String> messages = new HashSet<String>();
        messages.addAll(this.getImportErrorMissingProperties(this.getMissingMandatoryProperties(), locale));
        messages.addAll(this.getImportErrorMissingProperties(this.getMissingMandatoryI18NProperties(), locale));
        if (!this.getOtherConstraintViolations().isEmpty()) {
            messages.add(Messages.getInternalWithArguments("failure.import.constraintViolation", locale, this.getOtherConstraintViolations().size()) + String.valueOf(this.getOtherConstraintViolations().keySet()));
        }
        return messages;
    }

    private Set<String> getImportErrorMissingProperties(Map<String, Set<String>> missingProperties, Locale uiLocale) {
        HashSet<String> messages = new HashSet<String>();
        for (Map.Entry<String, Set<String>> missingPropertiesEntry : missingProperties.entrySet()) {
            for (String missingProperty : missingPropertiesEntry.getValue()) {
                messages.add(Messages.getInternalWithArguments("failure.import.missingProperty", uiLocale, missingProperty, missingPropertiesEntry.getKey()));
            }
        }
        return messages;
    }

    public String toString() {
        StringBuilder out = new StringBuilder(128);
        out.append("[").append(StringUtils.substringAfterLast((String)this.getClass().getName(), (String)".")).append("=").append(this.isSuccessful() ? "successful" : "failure");
        if (!this.isSuccessful()) {
            out.append(", missingMandatoryProperties=").append(this.missingMandatoryProperties);
            out.append(", missingMandatoryI18NProperties=").append(this.missingMandatoryI18NProperties);
            out.append(", otherConstraintViolations=").append(this.otherConstraintViolations);
        }
        out.append("]");
        return out.toString();
    }
}

