/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport.validation;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.importexport.validation.ValidationResult;
import org.jahia.utils.i18n.Messages;

public class MissingTemplatesValidationResult
implements ValidationResult,
Serializable {
    private static final long serialVersionUID = -6930213514434249772L;
    private Map<String, Set<String>> missing = new TreeMap<String, Set<String>>();
    private String targetTemplateSet;
    private boolean targetTemplateSetPresent;
    private Map<String, Integer> modulesMissingCounts = Collections.emptyMap();

    public MissingTemplatesValidationResult(Map<String, Set<String>> missing, String targetTemplateSet, boolean targetTemplateSetPresent, Map<String, Integer> modulesMissingCounts) {
        this.missing = missing;
        this.targetTemplateSet = targetTemplateSet;
        this.targetTemplateSetPresent = targetTemplateSetPresent;
        if (modulesMissingCounts != null) {
            this.modulesMissingCounts = modulesMissingCounts;
        }
    }

    protected MissingTemplatesValidationResult(MissingTemplatesValidationResult result1, MissingTemplatesValidationResult result2) {
        this.missing.putAll(result1.getMissingTemplates());
        this.targetTemplateSet = result1.getTargetTemplateSet();
        this.targetTemplateSetPresent = result1.isTargetTemplateSetPresent();
        if (this.targetTemplateSetPresent && !result2.isTargetTemplateSetPresent()) {
            this.targetTemplateSet = result2.getTargetTemplateSet();
            this.targetTemplateSetPresent = false;
        }
        for (Map.Entry<String, Set<String>> item : result2.getMissingTemplates().entrySet()) {
            if (this.missing.containsKey(item.getKey())) {
                this.missing.get(item.getKey()).addAll((Collection<String>)item.getValue());
                continue;
            }
            this.missing.put(item.getKey(), item.getValue());
        }
    }

    public Map<String, Set<String>> getMissingTemplates() {
        return this.missing;
    }

    public String getTargetTemplateSet() {
        return this.targetTemplateSet;
    }

    public Map<String, Integer> getTemplateSetsMissingCounts() {
        return this.modulesMissingCounts;
    }

    @Override
    public boolean isSuccessful() {
        return this.missing.isEmpty();
    }

    public boolean isTargetTemplateSetPresent() {
        return this.targetTemplateSetPresent;
    }

    @Override
    public ValidationResult merge(ValidationResult toBeMergedWith) {
        return toBeMergedWith == null || toBeMergedWith.isSuccessful() || !(toBeMergedWith instanceof MissingTemplatesValidationResult) ? this : new MissingTemplatesValidationResult(this, (MissingTemplatesValidationResult)toBeMergedWith);
    }

    @Override
    public boolean isBlocking() {
        return true;
    }

    @Override
    public Set<String> getFormatedMessages(Locale locale) {
        return Collections.singleton(Messages.getInternalWithArguments("failure.import.missingTemplates", locale, this.getMissingTemplates().size()) + String.valueOf(this.getMissingTemplates().keySet()));
    }

    public String toString() {
        StringBuilder out = new StringBuilder(128);
        out.append("[").append(StringUtils.substringAfterLast((String)this.getClass().getName(), (String)".")).append("=").append(this.isSuccessful() ? "successful" : "failure");
        out.append(", targetTemplateSet=").append(this.targetTemplateSet);
        out.append(", targetTemplateSetPresent=").append(this.targetTemplateSetPresent);
        out.append(", modulesMissingCounts=").append(this.modulesMissingCounts);
        out.append(", missingTemplates=").append(this.missing);
        out.append("]");
        return out.toString();
    }
}

